/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.actuator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class JobExecutorHealthIndicator
extends AbstractHealthIndicator {
    private final JobExecutor jobExecutor;

    public JobExecutorHealthIndicator(JobExecutor jobExecutor) {
        this.jobExecutor = Objects.requireNonNull(jobExecutor);
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        boolean active = this.jobExecutor.isActive();
        builder = active ? builder.up() : builder.down();
        builder.withDetail("jobExecutor", (Object)Details.from(this.jobExecutor));
    }

    public static class Details {
        private final String name;
        private final String lockOwner;
        private final int lockTimeInMillis;
        private final int maxJobsPerAcquisition;
        private final int waitTimeInMillis;
        private final Set<String> processEngineNames;

        private Details(DetailsBuilder builder) {
            this.name = builder.name;
            this.lockOwner = builder.lockOwner;
            this.lockTimeInMillis = builder.lockTimeInMillis;
            this.maxJobsPerAcquisition = builder.maxJobsPerAcquisition;
            this.waitTimeInMillis = builder.waitTimeInMillis;
            this.processEngineNames = Collections.unmodifiableSet(new HashSet<String>(builder.processEngineNames));
        }

        public static DetailsBuilder builder() {
            return new DetailsBuilder();
        }

        private static Details from(JobExecutor jobExecutor) {
            DetailsBuilder builder = Details.builder().name(jobExecutor.getName()).lockOwner(jobExecutor.getLockOwner()).lockTimeInMillis(jobExecutor.getLockTimeInMillis()).maxJobsPerAcquisition(jobExecutor.getMaxJobsPerAcquisition()).waitTimeInMillis(jobExecutor.getWaitTimeInMillis());
            for (ProcessEngineImpl processEngineImpl : jobExecutor.getProcessEngines()) {
                builder.processEngineName(processEngineImpl.getName());
            }
            return builder.build();
        }

        public String getName() {
            return this.name;
        }

        public String getLockOwner() {
            return this.lockOwner;
        }

        public int getLockTimeInMillis() {
            return this.lockTimeInMillis;
        }

        public int getMaxJobsPerAcquisition() {
            return this.maxJobsPerAcquisition;
        }

        public int getWaitTimeInMillis() {
            return this.waitTimeInMillis;
        }

        public Set<String> getProcessEngineNames() {
            return this.processEngineNames;
        }

        public String toString() {
            return "Details [name=" + this.name + ", lockOwner=" + this.lockOwner + ", lockTimeInMillis=" + this.lockTimeInMillis + ", maxJobsPerAcquisition=" + this.maxJobsPerAcquisition + ", waitTimeInMillis=" + this.waitTimeInMillis + ", processEngineNames=" + this.processEngineNames + "]";
        }

        public static class DetailsBuilder {
            private String name;
            private String lockOwner;
            private int lockTimeInMillis;
            private int maxJobsPerAcquisition;
            private int waitTimeInMillis;
            private Set<String> processEngineNames;

            DetailsBuilder() {
            }

            public DetailsBuilder name(String name) {
                this.name = name;
                return this;
            }

            public DetailsBuilder lockOwner(String lockOwner) {
                this.lockOwner = lockOwner;
                return this;
            }

            public DetailsBuilder lockTimeInMillis(int lockTimeInMillis) {
                this.lockTimeInMillis = lockTimeInMillis;
                return this;
            }

            public DetailsBuilder maxJobsPerAcquisition(int maxJobsPerAcquisition) {
                this.maxJobsPerAcquisition = maxJobsPerAcquisition;
                return this;
            }

            public DetailsBuilder waitTimeInMillis(int waitTimeInMillis) {
                this.waitTimeInMillis = waitTimeInMillis;
                return this;
            }

            public DetailsBuilder processEngineName(String processEngineName) {
                if (this.processEngineNames == null) {
                    this.processEngineNames = new HashSet<String>();
                }
                this.processEngineNames.add(processEngineName);
                return this;
            }

            public DetailsBuilder processEngineNames(Set<? extends String> processEngineNames) {
                if (this.processEngineNames == null) {
                    this.processEngineNames = new HashSet<String>();
                }
                this.processEngineNames.addAll(processEngineNames);
                return this;
            }

            public DetailsBuilder clearProcessEngineNames(Set<? extends String> processEngineNames) {
                if (this.processEngineNames != null) {
                    this.processEngineNames.clear();
                }
                return this;
            }

            public Details build() {
                return new Details(this);
            }
        }
    }
}

