/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.process_test_coverage.model.AggregatedCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.ClassCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredElement;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredSequenceFlow;
import org.camunda.bpm.extension.process_test_coverage.model.MethodCoverage;
import org.camunda.bpm.extension.process_test_coverage.util.CoveredElementComparator;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;

public class AggregatedClassCoverage
implements AggregatedCoverage {
    private List<ClassCoverage> classCoverages;
    private Map<String, List<ClassCoverage>> classCoveragesByProcessDefinitionKey = new HashMap<String, List<ClassCoverage>>();

    public AggregatedClassCoverage(List<ClassCoverage> classCoverages) {
        this.classCoverages = classCoverages;
        this.organizeByProcessDefinitionKey();
    }

    private void organizeByProcessDefinitionKey() {
        for (ClassCoverage classCoverage : this.classCoverages) {
            for (ProcessDefinition processDefinition : classCoverage.getProcessDefinitions()) {
                String key = processDefinition.getKey();
                if (!this.classCoveragesByProcessDefinitionKey.containsKey(key)) {
                    this.classCoveragesByProcessDefinitionKey.put(key, new ArrayList());
                }
                this.classCoveragesByProcessDefinitionKey.get(key).add(classCoverage);
            }
        }
    }

    @Override
    public Set<String> getCoveredFlowNodeIds(String processDefinitionKey) {
        HashSet<String> coveredFlowNodeIds = new HashSet<String>();
        for (ClassCoverage classCoverage : this.classCoveragesByProcessDefinitionKey.get(processDefinitionKey)) {
            coveredFlowNodeIds.addAll(classCoverage.getCoveredFlowNodeIds(processDefinitionKey));
        }
        return coveredFlowNodeIds;
    }

    @Override
    public Set<CoveredFlowNode> getCoveredFlowNodes(String processDefinitionKey) {
        TreeSet<CoveredElement> coveredFlowNodes = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (ClassCoverage classCoverage : this.classCoveragesByProcessDefinitionKey.get(processDefinitionKey)) {
            coveredFlowNodes.addAll(classCoverage.getCoveredFlowNodes(processDefinitionKey));
        }
        return coveredFlowNodes;
    }

    @Override
    public Set<String> getCoveredSequenceFlowIds(String processDefinitionKey) {
        HashSet<String> coveredSequenceFlowIds = new HashSet<String>();
        for (ClassCoverage classCoverage : this.classCoveragesByProcessDefinitionKey.get(processDefinitionKey)) {
            coveredSequenceFlowIds.addAll(classCoverage.getCoveredSequenceFlowIds(processDefinitionKey));
        }
        return coveredSequenceFlowIds;
    }

    @Override
    public Set<CoveredSequenceFlow> getCoveredSequenceFlows(String processDefinitionKey) {
        TreeSet<CoveredElement> coveredSequenceFlows = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (ClassCoverage classCoverage : this.classCoveragesByProcessDefinitionKey.get(processDefinitionKey)) {
            coveredSequenceFlows.addAll(classCoverage.getCoveredSequenceFlows(processDefinitionKey));
        }
        return coveredSequenceFlows;
    }

    @Override
    public Set<ProcessDefinition> getProcessDefinitions() {
        TreeSet<ProcessDefinition> processDefinitions = new TreeSet<ProcessDefinition>(new Comparator<ProcessDefinition>(){

            @Override
            public int compare(ProcessDefinition o1, ProcessDefinition o2) {
                return o1.getResourceName().compareTo(o2.getResourceName());
            }
        });
        for (ClassCoverage classCoverage : this.classCoverages) {
            processDefinitions.addAll(classCoverage.getProcessDefinitions());
        }
        return processDefinitions;
    }

    @Override
    public double getCoveragePercentage() {
        Set<ProcessDefinition> processDefinitions = this.getProcessDefinitions();
        HashSet<FlowNode> definitionsFlowNodes = new HashSet<FlowNode>();
        HashSet<SequenceFlow> definitionsSequenceFlows = new HashSet<SequenceFlow>();
        TreeSet<CoveredElement> coveredFlowNodes = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        TreeSet<CoveredElement> coveredSequenceFlows = new TreeSet<CoveredElement>(CoveredElementComparator.instance());
        for (ProcessDefinition processDefinition : processDefinitions) {
            String processDefinitionKey = processDefinition.getKey();
            MethodCoverage deploymentWithProcessDefinition = this.getMethodCoverage(processDefinitionKey);
            definitionsFlowNodes.addAll(deploymentWithProcessDefinition.getProcessDefinitionsFlowNodes(processDefinitionKey));
            definitionsSequenceFlows.addAll(deploymentWithProcessDefinition.getProcessDefinitionsSequenceFlows(processDefinitionKey));
            coveredFlowNodes.addAll(this.getCoveredFlowNodes(processDefinitionKey));
            coveredSequenceFlows.addAll(this.getCoveredSequenceFlows(processDefinitionKey));
        }
        double bpmnElementsCount = definitionsFlowNodes.size() + definitionsSequenceFlows.size();
        double coveredElementsCount = coveredFlowNodes.size() + coveredSequenceFlows.size();
        return coveredElementsCount / bpmnElementsCount;
    }

    @Override
    public double getCoveragePercentage(String processDefinitionKey) {
        MethodCoverage deploymentWithProcessDefinition = this.getMethodCoverage(processDefinitionKey);
        Set<FlowNode> definitionsFlowNodes = deploymentWithProcessDefinition.getProcessDefinitionsFlowNodes(processDefinitionKey);
        Set<SequenceFlow> definitionsSequenceFlows = deploymentWithProcessDefinition.getProcessDefinitionsSequenceFlows(processDefinitionKey);
        Set<CoveredFlowNode> coveredFlowNodes = this.getCoveredFlowNodes(processDefinitionKey);
        Set<CoveredSequenceFlow> coveredSequenceFlows = this.getCoveredSequenceFlows(processDefinitionKey);
        double bpmnElementsCount = definitionsFlowNodes.size() + definitionsSequenceFlows.size();
        double coveredElementsCount = coveredFlowNodes.size() + coveredSequenceFlows.size();
        return coveredElementsCount / bpmnElementsCount;
    }

    private MethodCoverage getMethodCoverage(String processDefinitionKey) {
        return this.classCoveragesByProcessDefinitionKey.get(processDefinitionKey).get(0).getAnyMethodCoverage();
    }
}

