/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.junit.rules;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.CoverageTestRunState;
import org.camunda.bpm.extension.process_test_coverage.model.ClassCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredElement;
import org.camunda.bpm.extension.process_test_coverage.model.MethodCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.ProcessCoverage;

public class DefaultCoverageTestRunState
implements CoverageTestRunState {
    private Logger log = Logger.getLogger(DefaultCoverageTestRunState.class.getCanonicalName());
    private ClassCoverage classCoverage = new ClassCoverage();
    private String testClassName;
    private String currentTestMethodName;
    private List<String> excludedProcessDefinitionKeys;

    @Override
    public void addCoveredElement(CoveredElement coveredElement) {
        if (!this.isExcluded(coveredElement)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.info("addCoveredElement(" + coveredElement + ")");
            }
            this.classCoverage.addCoveredElement(this.currentTestMethodName, coveredElement);
        }
    }

    @Override
    public void endCoveredElement(CoveredElement coveredElement) {
        if (!this.isExcluded(coveredElement)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.info("endCoveredElement(" + coveredElement + ")");
            }
            this.classCoverage.endCoveredElement(this.currentTestMethodName, coveredElement);
        }
    }

    @Override
    public void initializeTestMethodCoverage(ProcessEngine processEngine, String deploymentId, List<ProcessDefinition> processDefinitions, String testName) {
        MethodCoverage testCoverage = new MethodCoverage(deploymentId);
        for (ProcessDefinition processDefinition : processDefinitions) {
            ProcessCoverage processCoverage = new ProcessCoverage(processEngine, processDefinition);
            testCoverage.addProcessCoverage(processCoverage);
        }
        this.classCoverage.addTestMethodCoverage(testName, testCoverage);
    }

    @Override
    public MethodCoverage getTestMethodCoverage(String testName) {
        return this.classCoverage.getTestMethodCoverage(testName);
    }

    @Override
    public MethodCoverage getCurrentTestMethodCoverage() {
        return this.classCoverage.getTestMethodCoverage(this.currentTestMethodName);
    }

    @Override
    public ClassCoverage getClassCoverage() {
        return this.classCoverage;
    }

    @Override
    public String getCurrentTestMethodName() {
        return this.currentTestMethodName;
    }

    @Override
    public void setCurrentTestMethodName(String currentTestName) {
        this.currentTestMethodName = currentTestName;
    }

    @Override
    public String getTestClassName() {
        return this.testClassName;
    }

    @Override
    public void setTestClassName(String className) {
        this.testClassName = className;
    }

    @Override
    public void setExcludedProcessDefinitionKeys(List<String> excludedProcessDefinitionKeys) {
        this.excludedProcessDefinitionKeys = excludedProcessDefinitionKeys;
    }

    private boolean isExcluded(CoveredElement coveredElement) {
        if (this.excludedProcessDefinitionKeys != null) {
            return this.excludedProcessDefinitionKeys.contains(coveredElement.getProcessDefinitionKey());
        }
        return false;
    }
}

