/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.scenario.impl;

import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.scenario.impl.AbstractExecutable;
import org.camunda.bpm.scenario.impl.ProcessRunnerImpl;
import org.camunda.bpm.scenario.impl.util.Api;
import org.camunda.bpm.scenario.impl.util.Log;

public abstract class JobExecutable
extends AbstractExecutable<Job> {
    protected JobExecutable(ProcessRunnerImpl runner, Job job) {
        super(runner);
        this.delegate = job;
    }

    @Override
    public String getExecutionId() {
        return ((Job)this.delegate).getExecutionId();
    }

    @Override
    protected Job getDelegate() {
        return (Job)this.getManagementService().createJobQuery().jobId(((Job)this.delegate).getId()).singleResult();
    }

    protected void executeJob() {
        this.log();
        this.getManagementService().executeJob(((Job)this.delegate).getId());
    }

    @Override
    public void execute() {
        this.executeJob();
        this.runner.setExecuted();
    }

    @Override
    public int compareTo(AbstractExecutable other) {
        int compare = super.compareTo(other);
        return compare == 0 ? idComparator.compare(((Job)this.delegate).getId(), ((Job)((JobExecutable)other).delegate).getId()) : compare;
    }

    private void log() {
        String config;
        JobEntity entity = (JobEntity)this.delegate;
        String type = entity.getJobHandlerType();
        if (Api.feature(JobEntity.class.getName(), "getJobHandlerConfigurationRaw", new Class[0]).isSupported()) {
            config = entity.getJobHandlerConfigurationRaw();
        } else {
            try {
                config = (String)JobEntity.class.getMethod("getJobHandlerConfiguration", new Class[0]).invoke((Object)entity, new Object[0]);
            }
            catch (Exception e) {
                config = "";
            }
        }
        Log.Action.Executing_Job.log(type, config, null, ((ProcessDefinition)this.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(this.runner.processInstance.getProcessDefinitionId()).singleResult()).getKey(), this.runner.processInstance.getId(), null, null);
    }
}

