/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.spring.impl.client;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.client.ExternalTaskClient;
import org.camunda.bpm.client.ExternalTaskClientBuilder;
import org.camunda.bpm.client.backoff.BackoffStrategy;
import org.camunda.bpm.client.interceptor.ClientRequestInterceptor;
import org.camunda.bpm.client.spring.impl.client.ClientConfiguration;
import org.camunda.bpm.client.spring.impl.client.util.ClientLoggerUtil;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public class ClientFactory
implements FactoryBean<ExternalTaskClient>,
InitializingBean {
    protected static final ClientLoggerUtil LOG = ClientLoggerUtil.CLIENT_LOGGER;
    protected ClientConfiguration clientConfiguration;
    protected BackoffStrategy backoffStrategy;
    protected List<ClientRequestInterceptor> requestInterceptors = new ArrayList<ClientRequestInterceptor>();
    protected ExternalTaskClient client;
    protected PropertyResolver propertyResolver;

    public ExternalTaskClient getObject() {
        if (this.client == null) {
            ExternalTaskClientBuilder clientBuilder = ExternalTaskClient.create();
            if (this.clientConfiguration.getBaseUrl() != null) {
                clientBuilder.baseUrl(this.resolve(this.clientConfiguration.getBaseUrl()));
            }
            if (this.clientConfiguration.getWorkerId() != null) {
                clientBuilder.workerId(this.resolve(this.clientConfiguration.getWorkerId()));
            }
            this.addClientRequestInterceptors(clientBuilder);
            if (this.clientConfiguration.getMaxTasks() != null) {
                clientBuilder.maxTasks(this.clientConfiguration.getMaxTasks().intValue());
            }
            if (this.clientConfiguration.getUsePriority() != null && !this.clientConfiguration.getUsePriority().booleanValue()) {
                clientBuilder.usePriority(false);
            }
            if (this.clientConfiguration.getDefaultSerializationFormat() != null) {
                clientBuilder.defaultSerializationFormat(this.resolve(this.clientConfiguration.getDefaultSerializationFormat()));
            }
            if (this.clientConfiguration.getDateFormat() != null) {
                clientBuilder.dateFormat(this.resolve(this.clientConfiguration.getDateFormat()));
            }
            if (this.clientConfiguration.getAsyncResponseTimeout() != null) {
                clientBuilder.asyncResponseTimeout(this.clientConfiguration.getAsyncResponseTimeout().longValue());
            }
            if (this.clientConfiguration.getLockDuration() != null) {
                clientBuilder.lockDuration(this.clientConfiguration.getLockDuration().longValue());
            }
            if (this.clientConfiguration.getDisableAutoFetching() != null && this.clientConfiguration.getDisableAutoFetching().booleanValue()) {
                clientBuilder.disableAutoFetching();
            }
            if (this.clientConfiguration.getDisableBackoffStrategy() != null && this.clientConfiguration.getDisableBackoffStrategy().booleanValue()) {
                clientBuilder.disableBackoffStrategy();
            }
            if (this.backoffStrategy != null) {
                clientBuilder.backoffStrategy(this.backoffStrategy);
            }
            this.client = clientBuilder.build();
        }
        LOG.bootstrapped();
        return this.client;
    }

    protected void addClientRequestInterceptors(ExternalTaskClientBuilder taskClientBuilder) {
        this.requestInterceptors.forEach(arg_0 -> ((ExternalTaskClientBuilder)taskClientBuilder).addInterceptor(arg_0));
    }

    @Autowired(required=false)
    public void setRequestInterceptors(List<ClientRequestInterceptor> requestInterceptors) {
        if (requestInterceptors != null) {
            this.requestInterceptors.addAll(requestInterceptors);
            LOG.requestInterceptorsFound(this.requestInterceptors.size());
        }
    }

    @Autowired(required=false)
    public void setClientBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
        LOG.backoffStrategyFound();
    }

    public Class<ExternalTaskClient> getObjectType() {
        return ExternalTaskClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public List<ClientRequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    protected void close() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Autowired(required=false)
    protected void setPropertyConfigurer(PropertySourcesPlaceholderConfigurer configurer) {
        PropertySources appliedPropertySources = configurer.getAppliedPropertySources();
        this.propertyResolver = new PropertySourcesPropertyResolver(appliedPropertySources);
    }

    protected String resolve(String property) {
        if (this.propertyResolver == null) {
            return property;
        }
        if (property != null) {
            return this.propertyResolver.resolvePlaceholders(property);
        }
        return null;
    }
}

