/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions.cmmn;

import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseActivityInstanceEntity;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.assertions.bpmn.AbstractProcessAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.CaseExecutionAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.CaseInstanceAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.CaseTaskAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.HumanTaskAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.MilestoneAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.ProcessTaskAssert;
import org.camunda.bpm.engine.test.assertions.cmmn.StageAssert;

public abstract class AbstractCaseAssert<S extends AbstractCaseAssert<S, A>, A extends CaseExecution>
extends AbstractProcessAssert<S, A> {
    @Override
    public A getActual() {
        return (A)((CaseExecution)this.actual);
    }

    protected AbstractCaseAssert(ProcessEngine engine, A actual, Class<?> selfType) {
        super(engine, actual, selfType);
    }

    protected S isAvailable() {
        return this.hasState(CaseExecutionState.AVAILABLE);
    }

    protected S isEnabled() {
        return this.hasState(CaseExecutionState.ENABLED);
    }

    protected S isDisabled() {
        return this.hasState(CaseExecutionState.DISABLED);
    }

    protected S isActive() {
        return this.hasState(CaseExecutionState.ACTIVE);
    }

    protected S isCompleted() {
        return this.hasState(CaseExecutionState.COMPLETED);
    }

    protected S isClosed() {
        return this.hasState(CaseExecutionState.CLOSED);
    }

    protected S isTerminated() {
        return this.hasState(CaseExecutionState.TERMINATED);
    }

    protected CaseInstanceAssert isCaseInstance() {
        this.isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((CaseExecution)this.actual).getCaseInstanceId()).overridingErrorMessage("Expected %s to be the case instance, but found it not to be!", new Object[0])).isEqualTo((Object)((CaseExecution)this.actual).getId());
        return CaseInstanceAssert.assertThat(this.engine, (CaseInstance)this.actual);
    }

    protected StageAssert isStage() {
        this.hasType("stage");
        return StageAssert.assertThat(this.engine, (CaseExecution)this.actual);
    }

    protected HumanTaskAssert isHumanTask() {
        this.hasType("humanTask");
        return HumanTaskAssert.assertThat(this.engine, (CaseExecution)this.actual);
    }

    protected ProcessTaskAssert isProcessTask() {
        this.hasType("processTask");
        return ProcessTaskAssert.assertThat(this.engine, (CaseExecution)this.actual);
    }

    protected CaseTaskAssert isCaseTask() {
        this.hasType("caseTask");
        return CaseTaskAssert.assertThat(this.engine, (CaseExecution)this.actual);
    }

    protected MilestoneAssert isMilestone() {
        this.hasType("milestone");
        return MilestoneAssert.assertThat(this.engine, (CaseExecution)this.actual);
    }

    protected CaseExecutionAssert caseExecution(CaseExecutionQuery query) {
        CaseExecutionAssert caseExecutionAssert = this.descendantCaseExecution(query);
        A caseExecution = caseExecutionAssert.getActual();
        if (caseExecution != null) {
            Assertions.assertThat((String)caseExecution.getParentId()).isEqualTo((Object)((CaseExecution)this.actual).getId());
        }
        return new CaseExecutionAssert(this.engine, (CaseExecution)caseExecution);
    }

    protected CaseExecutionAssert descendantCaseExecution(CaseExecutionQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Illegal call of caseExecution(query = 'null') - but must not be null!");
        }
        this.isNotNull();
        CaseExecution caseExecution = (CaseExecution)query.singleResult();
        return new CaseExecutionAssert(this.engine, caseExecution);
    }

    protected HumanTaskAssert humanTask(CaseExecutionQuery query) {
        A caseExecution = this.caseExecution(query).getActual();
        return CaseExecutionAssert.assertThat(this.engine, caseExecution).isHumanTask();
    }

    protected HumanTaskAssert humanTask(String activityId) {
        return this.humanTask(this.caseExecutionQuery().activityId(activityId));
    }

    protected CaseTaskAssert caseTask(CaseExecutionQuery query) {
        A caseExecution = this.caseExecution(query).getActual();
        return CaseExecutionAssert.assertThat(this.engine, caseExecution).isCaseTask();
    }

    protected CaseTaskAssert caseTask(String activityId) {
        return this.caseTask(this.caseExecutionQuery().activityId(activityId));
    }

    protected ProcessTaskAssert processTask(CaseExecutionQuery query) {
        A caseExecution = this.caseExecution(query).getActual();
        return CaseExecutionAssert.assertThat(this.engine, caseExecution).isProcessTask();
    }

    protected ProcessTaskAssert processTask(String activityId) {
        return this.processTask(this.caseExecutionQuery().activityId(activityId));
    }

    protected StageAssert stage(CaseExecutionQuery query) {
        A caseExecution = this.caseExecution(query).getActual();
        return CaseExecutionAssert.assertThat(this.engine, caseExecution).isStage();
    }

    protected StageAssert stage(String activityId) {
        return this.stage(this.caseExecutionQuery().activityId(activityId));
    }

    protected MilestoneAssert milestone(CaseExecutionQuery query) {
        A caseExecution = this.caseExecution(query).getActual();
        return CaseExecutionAssert.assertThat(this.engine, caseExecution).isMilestone();
    }

    protected MilestoneAssert milestone(String activityId) {
        return this.milestone(this.caseExecutionQuery().activityId(activityId));
    }

    private S hasState(CaseExecutionState state) {
        Assertions.assertThat((Object)this.actual).isNotNull();
        A current = this.getCurrent();
        int actualState = current != null ? ((CaseExecutionEntity)current).getState() : this.getHistoricState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualState).overridingErrorMessage(String.format("Expected %s to be in state '%s', but found it to be '%s'!", this.toString((A)((CaseExecution)this.actual)), state, CaseExecutionState.CASE_EXECUTION_STATES.get(actualState)), new Object[0])).isEqualTo(state.getStateCode());
        AbstractCaseAssert self = this;
        return (S)((Object)self);
    }

    private S hasType(String type) {
        Assertions.assertThat((Object)this.actual).isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((CaseExecution)this.actual).getActivityType()).overridingErrorMessage(String.format("Expected %s to be a '%s', but found it to be a '%s'!", this.toString((A)((CaseExecution)this.actual)), type, ((CaseExecution)this.actual).getActivityType()), new Object[0])).isEqualTo((Object)type);
        AbstractCaseAssert self = this;
        return (S)((Object)self);
    }

    @Override
    protected A getCurrent() {
        CaseExecution caseExecution = (CaseExecution)this.caseExecutionQuery().caseExecutionId(((CaseExecution)this.actual).getId()).singleResult();
        return (A)caseExecution;
    }

    protected int getHistoricState() {
        this.isNotNull();
        HistoricCaseActivityInstance historicCaseActivityInstance = (HistoricCaseActivityInstance)this.historicCaseActivityInstanceQuery().caseExecutionId(((CaseExecution)this.actual).getId()).singleResult();
        String message = "Please make sure you have set the history service of the engine to at least level 'activity' or a higher level before making use of this assertion!";
        ((ObjectAssert)Assertions.assertThat((Object)historicCaseActivityInstance).overridingErrorMessage(message, new Object[0])).isNotNull();
        return ((HistoricCaseActivityInstanceEntity)historicCaseActivityInstance).getCaseActivityInstanceState();
    }

    @Override
    protected CaseExecutionQuery caseExecutionQuery() {
        return super.caseExecutionQuery().caseInstanceId(((CaseExecution)this.actual).getCaseInstanceId());
    }

    @Override
    protected HistoricCaseActivityInstanceQuery historicCaseActivityInstanceQuery() {
        return super.historicCaseActivityInstanceQuery().caseInstanceId(((CaseExecution)this.actual).getCaseInstanceId());
    }

    @Override
    protected String toString(A caseExecution) {
        if (caseExecution != null) {
            return !((CaseExecution)this.actual).getCaseInstanceId().equals(((CaseExecution)this.actual).getId()) ? String.format("%s {id='%s', activityId='%s' }", caseExecution.getActivityType(), caseExecution.getId(), caseExecution.getActivityId(), caseExecution.getCaseInstanceId()) : String.format("%s {id='%s', activityId='%s'" + (((CaseInstance)caseExecution).getBusinessKey() != null ? ", businessKey='%s'}" : "}"), CaseInstance.class.getSimpleName(), caseExecution.getId(), caseExecution.getActivityId(), ((CaseInstance)caseExecution).getBusinessKey());
        }
        return null;
    }

    protected MapAssert<String, Object> variables() {
        return Assertions.assertThat(this.vars());
    }

    protected Map<String, Object> vars() {
        A current = this.getCurrent();
        if (current != null) {
            return this.caseService().getVariables(current.getId());
        }
        return this.getHistoricVariablesMap();
    }

    private Map<String, Object> getHistoricVariablesMap() {
        throw new UnsupportedOperationException();
    }

    protected S hasVars(String[] names) {
        boolean shouldHaveVariables = names != null;
        boolean shouldHaveSpecificVariables = names != null && names.length > 0;
        Map<String, Object> vars = this.vars();
        StringBuffer message = new StringBuffer();
        message.append("Expecting %s to hold ");
        message.append(shouldHaveVariables ? "case variables" + (shouldHaveSpecificVariables ? " %s, " : ", ") : "no variables at all, ");
        message.append("instead we found it to hold " + (vars.isEmpty() ? "no variables at all." : "the variables %s."));
        if (vars.isEmpty() && this.getCurrent() == null) {
            message.append(" (Please make sure you have set the history service of the engine to at least 'audit' or a higher level before making use of this assertion for historic instances!)");
        }
        MapAssert assertion = (MapAssert)this.variables().overridingErrorMessage(message.toString(), new Object[]{this.toString((A)((CaseExecution)this.actual)), shouldHaveSpecificVariables ? Arrays.asList(names) : vars.keySet(), vars.keySet()});
        if (shouldHaveVariables) {
            if (shouldHaveSpecificVariables) {
                assertion.containsKeys((Object[])names);
            } else {
                assertion.isNotEmpty();
            }
        } else {
            assertion.isEmpty();
        }
        AbstractCaseAssert self = this;
        return (S)((Object)self);
    }
}

