/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions.bpmn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.util.Lists;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.assertions.bpmn.AbstractProcessAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.CalledProcessInstanceAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.ExternalTaskAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.JobAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.TaskAssert;

public class ProcessInstanceAssert
extends AbstractProcessAssert<ProcessInstanceAssert, ProcessInstance> {
    protected ProcessInstanceAssert(ProcessEngine engine, ProcessInstance actual) {
        super(engine, actual, ProcessInstanceAssert.class);
    }

    protected ProcessInstanceAssert(ProcessEngine engine, ProcessInstance actual, Class<?> selfType) {
        super(engine, actual, selfType);
    }

    protected static ProcessInstanceAssert assertThat(ProcessEngine engine, ProcessInstance actual) {
        return new ProcessInstanceAssert(engine, actual);
    }

    @Override
    protected ProcessInstance getCurrent() {
        return (ProcessInstance)this.processInstanceQuery().singleResult();
    }

    @Override
    protected String toString(ProcessInstance processInstance) {
        return processInstance != null ? String.format("%s {id='%s', processDefinitionId='%s', businessKey='%s'}", ProcessInstance.class.getSimpleName(), processInstance.getId(), processInstance.getProcessDefinitionId(), processInstance.getBusinessKey()) : null;
    }

    public ProcessInstanceAssert isWaitingAt(String ... activityIds) {
        return this.isWaitingAt(activityIds, true, false);
    }

    public ProcessInstanceAssert isNotWaitingAt(String ... activityIds) {
        return this.isWaitingAt(activityIds, false, false);
    }

    public ProcessInstanceAssert isWaitingAtExactly(String ... activityIds) {
        return this.isWaitingAt(activityIds, true, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProcessInstanceAssert isWaitingAt(String[] activityIds, boolean isWaitingAt, boolean exactly) {
        ProcessInstance current = (ProcessInstance)this.getExistingCurrent();
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])activityIds).overridingErrorMessage("Expecting list of activityIds not to be null, not to be empty and not to contain null values: %s.", new Object[]{Lists.newArrayList((Object[])activityIds)})).isNotNull()).isNotEmpty()).doesNotContainNull();
        List activeActivityIds = this.runtimeService().getActiveActivityIds(((ProcessInstance)this.actual).getId());
        String message = "Expecting %s " + (isWaitingAt ? "to be waiting at " + (exactly ? "exactly " : "") + "%s, " : "NOT to be waiting at %s, ") + "but it is actually waiting at %s.";
        ListAssert assertion = (ListAssert)Assertions.assertThat((List)activeActivityIds).overridingErrorMessage(message, new Object[]{this.toString(current), Lists.newArrayList((Object[])activityIds), activeActivityIds});
        if (exactly) {
            if (!isWaitingAt) throw new UnsupportedOperationException();
            assertion.containsOnly((Object[])activityIds);
            return this;
        } else if (isWaitingAt) {
            assertion.contains((Object[])activityIds);
            return this;
        } else {
            assertion.doesNotContain((Object[])activityIds);
        }
        return this;
    }

    public ProcessInstanceAssert isWaitingFor(String ... messageNames) {
        return this.isWaitingFor(messageNames, true);
    }

    public ProcessInstanceAssert isNotWaitingFor(String ... messageNames) {
        return this.isWaitingFor(messageNames, false);
    }

    private ProcessInstanceAssert isWaitingFor(String[] messageNames, boolean isWaitingFor) {
        this.isNotNull();
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])messageNames).overridingErrorMessage("Expecting list of messageNames not to be null, not to be empty and not to contain null values: %s.", new Object[]{Lists.newArrayList((Object[])messageNames)})).isNotNull()).isNotEmpty()).doesNotContainNull();
        for (String messageName : messageNames) {
            List executions = this.executionQuery().messageEventSubscriptionName(messageName).list();
            ListAssert assertion = (ListAssert)Assertions.assertThat((List)executions).overridingErrorMessage("Expecting %s " + (isWaitingFor ? "to be waiting for %s, " : "NOT to be waiting for %s, ") + "but actually did " + (isWaitingFor ? "not " : "") + "find it to be waiting for message [%s].", new Object[]{this.actual, Arrays.asList(messageNames), messageName});
            if (isWaitingFor) {
                assertion.isNotEmpty();
                continue;
            }
            assertion.isEmpty();
        }
        return this;
    }

    public ProcessInstanceAssert hasPassed(String ... activityIds) {
        return this.hasPassed(activityIds, true, false);
    }

    public ProcessInstanceAssert hasPassedInOrder(String ... activityIds) {
        return this.hasPassed(activityIds, true, true);
    }

    public ProcessInstanceAssert hasNotPassed(String ... activityIds) {
        return this.hasPassed(activityIds, false, false);
    }

    private ProcessInstanceAssert hasPassed(String[] activityIds, boolean hasPassed, boolean inOrder) {
        this.isNotNull();
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])activityIds).overridingErrorMessage("Expecting list of activityIds not to be null, not to be empty and not to contain null values: %s.", new Object[]{Lists.newArrayList((Object[])activityIds)})).isNotNull()).isNotEmpty()).doesNotContainNull();
        List finishedInstances = ((HistoricActivityInstanceQuery)((HistoricActivityInstanceQuery)this.historicActivityInstanceQuery().finished().orderByHistoricActivityInstanceEndTime().asc()).orderPartiallyByOccurrence().asc()).list();
        ArrayList<String> finished = new ArrayList<String>(finishedInstances.size());
        for (HistoricActivityInstance instance : finishedInstances) {
            finished.add(instance.getActivityId());
        }
        String message = "Expecting %s " + (hasPassed ? "to have passed activities %s at least once" + (inOrder ? " and in order" : "") + ", " : "NOT to have passed activities %s, ") + "but actually we instead we found that it passed %s. (Please make sure you have set the history service of the engine to at least 'activity' or a higher level before making use of this assertion!)";
        ListAssert assertion = (ListAssert)Assertions.assertThat(finished).overridingErrorMessage(message, new Object[]{this.actual, Lists.newArrayList((Object[])activityIds), Lists.newArrayList(finished)});
        if (hasPassed) {
            assertion.contains((Object[])activityIds);
            if (inOrder) {
                List<String> remainingFinished = finished;
                for (int i = 0; i < activityIds.length; ++i) {
                    ((ListAssert)Assertions.assertThat(remainingFinished).overridingErrorMessage(message, new Object[]{this.actual, Lists.newArrayList((Object[])activityIds), Lists.newArrayList(finished)})).contains((Object[])new String[]{activityIds[i]});
                    remainingFinished = remainingFinished.subList(remainingFinished.indexOf(activityIds[i]) + 1, remainingFinished.size());
                }
            }
        } else {
            assertion.doesNotContain((Object[])activityIds);
        }
        return this;
    }

    public ProcessInstanceAssert hasVariables(String ... names) {
        return this.hasVars(names);
    }

    public ProcessInstanceAssert hasNoVariables() {
        return this.hasVars(null);
    }

    private ProcessInstanceAssert hasVars(String[] names) {
        boolean shouldHaveVariables = names != null;
        boolean shouldHaveSpecificVariables = names != null && names.length > 0;
        Map<String, Object> vars = this.vars();
        StringBuffer message = new StringBuffer();
        message.append("Expecting %s to hold ");
        message.append(shouldHaveVariables ? "process variables" + (shouldHaveSpecificVariables ? " %s, " : ", ") : "no variables at all, ");
        message.append("instead we found it to hold " + (vars.isEmpty() ? "no variables at all." : "the variables %s."));
        if (vars.isEmpty() && this.getCurrent() == null) {
            message.append(" (Please make sure you have set the history service of the engine to at least 'audit' or a higher level before making use of this assertion for historic instances!)");
        }
        MapAssert assertion = (MapAssert)this.variables().overridingErrorMessage(message.toString(), new Object[]{this.toString((ProcessInstance)this.actual), shouldHaveSpecificVariables ? Arrays.asList(names) : vars.keySet(), vars.keySet()});
        if (shouldHaveVariables) {
            if (shouldHaveSpecificVariables) {
                assertion.containsKeys((Object[])names);
            } else {
                assertion.isNotEmpty();
            }
        } else {
            assertion.isEmpty();
        }
        return this;
    }

    public ProcessInstanceAssert hasProcessDefinitionKey(String processDefinitionKey) {
        this.isNotNull();
        String message = "Expecting %s to have process definition key '%s', but instead found it to have process definition key '%s'.";
        ProcessDefinition processDefinition = (ProcessDefinition)this.processDefinitionQuery().singleResult();
        ((AbstractStringAssert)Assertions.assertThat((String)processDefinitionKey).overridingErrorMessage("Expecting %s to have process definition key '%s', but instead found it to have process definition key '%s'.", new Object[]{this.toString((ProcessInstance)this.actual), processDefinitionKey, processDefinition.getKey()})).isEqualTo((Object)processDefinition.getKey());
        return this;
    }

    public ProcessInstanceAssert isEnded() {
        this.isNotNull();
        String message = "Expecting %s to be ended, but it is not!. (Please make sure you have set the history service of the engine to at least 'activity' or a higher level before making use of this assertion!)";
        ((ObjectAssert)Assertions.assertThat((Object)this.processInstanceQuery().singleResult()).overridingErrorMessage("Expecting %s to be ended, but it is not!. (Please make sure you have set the history service of the engine to at least 'activity' or a higher level before making use of this assertion!)", new Object[]{this.toString((ProcessInstance)this.actual)})).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.historicProcessInstanceQuery().singleResult()).overridingErrorMessage("Expecting %s to be ended, but it is not!. (Please make sure you have set the history service of the engine to at least 'activity' or a higher level before making use of this assertion!)", new Object[]{this.toString((ProcessInstance)this.actual)})).isNotNull();
        return this;
    }

    public ProcessInstanceAssert isSuspended() {
        ProcessInstance current = (ProcessInstance)this.getExistingCurrent();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)current.isSuspended()).overridingErrorMessage("Expecting %s to be suspended, but it is not!", new Object[]{this.toString((ProcessInstance)this.actual)})).isTrue();
        return this;
    }

    public ProcessInstanceAssert isNotEnded() {
        ProcessInstance current = (ProcessInstance)this.getExistingCurrent();
        ((ObjectAssert)Assertions.assertThat((Object)current).overridingErrorMessage("Expecting %s not to be ended, but it is!", new Object[]{this.toString(current)})).isNotNull();
        return this;
    }

    public ProcessInstanceAssert isActive() {
        ProcessInstance current = (ProcessInstance)this.getExistingCurrent();
        this.isStarted();
        this.isNotEnded();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)current.isSuspended()).overridingErrorMessage("Expecting %s not to be suspended, but it is!", new Object[]{this.toString(current)})).isFalse();
        return this;
    }

    public ProcessInstanceAssert isStarted() {
        Object pi = this.getCurrent();
        if (pi == null) {
            pi = this.historicProcessInstanceQuery().singleResult();
        }
        ((ObjectAssert)Assertions.assertThat((Object)pi).overridingErrorMessage("Expecting %s to be started, but it is not!", new Object[]{this.toString((ProcessInstance)this.actual)})).isNotNull();
        return this;
    }

    public TaskAssert task() {
        return this.task(this.taskQuery());
    }

    public TaskAssert task(String taskDefinitionKey) {
        if (taskDefinitionKey == null) {
            throw new IllegalArgumentException("Illegal call of task(taskDefinitionKey = 'null') - must not be null!");
        }
        this.isWaitingAt(taskDefinitionKey);
        return this.task(this.taskQuery().taskDefinitionKey(taskDefinitionKey));
    }

    public TaskAssert task(TaskQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Illegal call of task(query = 'null') - but must not be null!");
        }
        this.isNotNull();
        TaskQuery narrowed = query.processInstanceId(((ProcessInstance)this.actual).getId());
        return TaskAssert.assertThat(this.engine, (Task)narrowed.singleResult());
    }

    public ExternalTaskAssert externalTask() {
        return this.externalTask(this.externalTaskQuery());
    }

    public ExternalTaskAssert externalTask(String activityId) {
        if (activityId == null) {
            throw new IllegalArgumentException("Illegal call of externalTask(activityId = 'null') - must not be null!");
        }
        this.isWaitingAt(activityId);
        return this.externalTask(this.externalTaskQuery().activityId(activityId));
    }

    public ExternalTaskAssert externalTask(ExternalTaskQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Illegal call of externalTask(query = 'null') - but must not be null!");
        }
        this.isNotNull();
        ExternalTaskQuery narrowed = query.processInstanceId(((ProcessInstance)this.actual).getId());
        return ExternalTaskAssert.assertThat(this.engine, (ExternalTask)narrowed.singleResult());
    }

    public ProcessInstanceAssert calledProcessInstance() {
        return this.calledProcessInstance(super.processInstanceQuery());
    }

    public ProcessInstanceAssert calledProcessInstance(String processDefinitionKey) {
        return this.calledProcessInstance(super.processInstanceQuery().processDefinitionKey(processDefinitionKey));
    }

    public ProcessInstanceAssert calledProcessInstance(ProcessInstanceQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Illegal call of calledProcessInstance(query = 'null') - but must not be null!");
        }
        this.isNotNull();
        ProcessInstanceQuery narrowed = query.superProcessInstanceId(((ProcessInstance)this.actual).getId());
        return CalledProcessInstanceAssert.assertThat(this.engine, (ProcessInstance)narrowed.singleResult());
    }

    public JobAssert job() {
        return this.job(this.jobQuery());
    }

    public JobAssert job(String activityId) {
        Execution execution = (Execution)this.executionQuery().activityId(activityId).active().singleResult();
        return JobAssert.assertThat(this.engine, execution != null ? (Job)this.jobQuery().executionId(execution.getId()).singleResult() : null);
    }

    public JobAssert job(JobQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("Illegal call of job(query = 'null') - but must not be null!");
        }
        this.isNotNull();
        JobQuery narrowed = query.processInstanceId(((ProcessInstance)this.actual).getId());
        return JobAssert.assertThat(this.engine, (Job)narrowed.singleResult());
    }

    public MapAssert<String, Object> variables() {
        return Assertions.assertThat(this.vars());
    }

    protected Map<String, Object> vars() {
        ProcessInstance current = this.getCurrent();
        if (current != null) {
            return this.runtimeService().getVariables(current.getProcessInstanceId());
        }
        List instances = this.historicVariableInstanceQuery().list();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (HistoricVariableInstance instance : instances) {
            map.put(instance.getName(), instance.getValue());
        }
        return map;
    }

    @Override
    protected TaskQuery taskQuery() {
        return super.taskQuery().processInstanceId(((ProcessInstance)this.actual).getId());
    }

    @Override
    protected ExternalTaskQuery externalTaskQuery() {
        return super.externalTaskQuery().processInstanceId(((ProcessInstance)this.actual).getId());
    }

    @Override
    protected JobQuery jobQuery() {
        return super.jobQuery().processInstanceId(((ProcessInstance)this.actual).getId());
    }

    @Override
    protected ProcessInstanceQuery processInstanceQuery() {
        return super.processInstanceQuery().processInstanceId(((ProcessInstance)this.actual).getId());
    }

    @Override
    protected ExecutionQuery executionQuery() {
        return super.executionQuery().processInstanceId(((ProcessInstance)this.actual).getId());
    }

    @Override
    protected HistoricActivityInstanceQuery historicActivityInstanceQuery() {
        return super.historicActivityInstanceQuery().processInstanceId(((ProcessInstance)this.actual).getId());
    }

    @Override
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery() {
        return super.historicProcessInstanceQuery().processInstanceId(((ProcessInstance)this.actual).getId());
    }

    @Override
    protected HistoricVariableInstanceQuery historicVariableInstanceQuery() {
        return super.historicVariableInstanceQuery().processInstanceId(((ProcessInstance)this.actual).getId());
    }

    @Override
    protected ProcessDefinitionQuery processDefinitionQuery() {
        return super.processDefinitionQuery().processDefinitionId(((ProcessInstance)this.actual).getProcessDefinitionId());
    }
}

