/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.io.jam;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.TextMappingsWriter;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.Mapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;

public class JamWriter
extends TextMappingsWriter {
    private final List<String> classes = new ArrayList<String>();
    private final List<String> fields = new ArrayList<String>();
    private final List<String> methods = new ArrayList<String>();

    public JamWriter(Writer writer) {
        super(writer);
    }

    public void write(MappingSet mappings) {
        mappings.getTopLevelClassMappings().stream().filter(ClassMapping::hasMappings).sorted(this.getConfig().getClassMappingComparator()).forEach(this::writeClassMapping);
        this.classes.forEach(this.writer::println);
        this.fields.forEach(this.writer::println);
        this.methods.forEach(this.writer::println);
        this.classes.clear();
        this.fields.clear();
        this.methods.clear();
    }

    protected void writeClassMapping(ClassMapping<?, ?> mapping) {
        if (mapping.hasDeobfuscatedName()) {
            this.classes.add(String.format("CL %s %s", mapping.getFullObfuscatedName(), mapping.getFullDeobfuscatedName()));
        }
        mapping.getInnerClassMappings().stream().filter(ClassMapping::hasMappings).sorted(this.getConfig().getClassMappingComparator()).forEach(this::writeClassMapping);
        mapping.getFieldMappings().stream().filter(Mapping::hasDeobfuscatedName).sorted(this.getConfig().getFieldMappingComparator()).forEach(this::writeFieldMapping);
        mapping.getMethodMappings().stream().filter(MethodMapping::hasMappings).sorted(this.getConfig().getMethodMappingComparator()).forEach(this::writeMethodMapping);
    }

    protected void writeFieldMapping(FieldMapping mapping) {
        Optional fieldType = mapping.getType();
        fieldType.ifPresent(type -> this.fields.add(String.format("FD %s %s %s %s", ((ClassMapping)mapping.getParent()).getFullObfuscatedName(), mapping.getObfuscatedName(), mapping.getMappings().deobfuscate(type), mapping.getDeobfuscatedName())));
    }

    protected void writeMethodMapping(MethodMapping mapping) {
        if (mapping.hasDeobfuscatedName()) {
            this.methods.add(String.format("MD %s %s %s %s", ((ClassMapping)mapping.getParent()).getFullObfuscatedName(), mapping.getObfuscatedName(), mapping.getObfuscatedDescriptor(), mapping.getDeobfuscatedName()));
        }
        for (MethodParameterMapping parameterMapping : mapping.getParameterMappings()) {
            this.methods.add(String.format("MP %s %s %s %s %s", ((ClassMapping)((MethodMapping)parameterMapping.getParent()).getParent()).getFullObfuscatedName(), ((MethodMapping)parameterMapping.getParent()).getObfuscatedName(), ((MethodMapping)parameterMapping.getParent()).getObfuscatedDescriptor(), parameterMapping.getIndex(), parameterMapping.getDeobfuscatedName()));
        }
    }
}

