/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.extra.spring;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheManager;
import org.cache2k.config.Cache2kConfig;
import org.cache2k.extra.spring.SpringCache2kCache;
import org.cache2k.extra.spring.SpringLoadingCache2kCache;
import org.springframework.util.Assert;

public class SpringCache2kCacheManager
implements org.springframework.cache.CacheManager {
    public static final String DEFAULT_SPRING_CACHE_MANAGER_NAME = "springDefault";
    private final CacheManager manager;
    private final Map<String, SpringCache2kCache> name2cache = new ConcurrentHashMap<String, SpringCache2kCache>();
    private final Set<String> configuredCacheNames = new CopyOnWriteArraySet<String>();
    private boolean allowUnknownCache = true;
    private Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> defaultSetup = b -> b;

    public SpringCache2kCacheManager() {
        this(DEFAULT_SPRING_CACHE_MANAGER_NAME);
    }

    public SpringCache2kCacheManager(String name) {
        this(CacheManager.getInstance((String)name));
    }

    public SpringCache2kCacheManager(CacheManager manager) {
        this.manager = manager;
        manager.getConfiguredCacheNames().forEach(this.configuredCacheNames::add);
    }

    public SpringCache2kCache getCache(String name) {
        return this.name2cache.computeIfAbsent(name, n -> {
            if (!this.allowUnknownCache && !this.configuredCacheNames.contains(n)) {
                throw new IllegalArgumentException("Cache configuration missing for: " + n);
            }
            return this.buildAndWrap(this.defaultSetup.apply(this.getDefaultBuilder()).name(n));
        });
    }

    public SpringCache2kCacheManager defaultSetup(Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> f) {
        this.defaultSetup = f;
        return this;
    }

    @SafeVarargs
    public final SpringCache2kCacheManager addCaches(Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> ... fs) {
        for (Function<Cache2kBuilder<?, ?>, Cache2kBuilder<?, ?>> f : fs) {
            this.addCache(f.apply(this.defaultSetup.apply(this.getDefaultBuilder())));
        }
        return this;
    }

    private SpringCache2kCache addCache(Cache2kBuilder<?, ?> builder) {
        String name = builder.config().getName();
        Assert.notNull((Object)name, (String)"Name must be set via Cache2kBuilder.name()");
        Assert.isTrue((builder.getManager() == this.manager ? 1 : 0) != 0, (String)"Manager must be identical in builder.");
        this.configuredCacheNames.add(name);
        return this.name2cache.compute(name, (name2, existingCache) -> {
            Assert.isNull((Object)existingCache, (String)"Cache is not yet configured");
            return this.buildAndWrap(builder);
        });
    }

    public void setCaches(Collection<Cache2kConfig<?, ?>> cacheConfigurationList) {
        cacheConfigurationList.forEach(this::addCache);
    }

    private void addCache(Cache2kConfig<?, ?> cfg) {
        this.addCache(Cache2kBuilder.of(cfg).manager(this.manager));
    }

    public Collection<String> getCacheNames() {
        HashSet<String> cacheNames = new HashSet<String>();
        for (Cache cache : this.manager.getActiveCaches()) {
            cacheNames.add(cache.getName());
        }
        cacheNames.addAll(this.configuredCacheNames);
        return Collections.unmodifiableSet(cacheNames);
    }

    public Collection<String> getConfiguredCacheNames() {
        return Collections.unmodifiableSet(this.configuredCacheNames);
    }

    public CacheManager getNativeCacheManager() {
        return this.manager;
    }

    public Map<String, SpringCache2kCache> getCacheMap() {
        return Collections.unmodifiableMap(this.name2cache);
    }

    public boolean isAllowUnknownCache() {
        return this.allowUnknownCache;
    }

    public void setAllowUnknownCache(boolean v) {
        this.allowUnknownCache = v;
    }

    Cache2kBuilder getDefaultBuilder() {
        return Cache2kBuilder.forUnknownTypes().manager(this.manager).permitNullValues(true);
    }

    SpringCache2kCache buildAndWrap(Cache2kBuilder<?, ?> builder) {
        Cache nativeCache = builder.build();
        Cache2kConfig cfg = builder.config();
        boolean loaderPresent = cfg.getLoader() != null || cfg.getAdvancedLoader() != null;
        return loaderPresent ? new SpringLoadingCache2kCache((Cache<Object, Object>)nativeCache) : new SpringCache2kCache((Cache<Object, Object>)nativeCache);
    }
}

