/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.extra.spring;

import java.util.concurrent.Callable;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.annotation.Nullable;
import org.springframework.cache.Cache;
import org.springframework.util.Assert;

public class SpringCache2kCache
implements org.springframework.cache.Cache {
    protected final Cache<Object, Object> cache;

    public SpringCache2kCache(Cache<Object, Object> cache) {
        Assert.notNull(cache, (String)"Cache must not be null");
        this.cache = cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Cache<Object, Object> getNativeCache() {
        return this.cache;
    }

    @Nullable
    public Cache.ValueWrapper get(Object key) {
        CacheEntry entry = this.cache.getEntry(key);
        if (entry == null) {
            return null;
        }
        return this.returnWrappedValue((CacheEntry<Object, Object>)entry);
    }

    private Cache.ValueWrapper returnWrappedValue(CacheEntry<Object, Object> entry) {
        Object v = entry.getValue();
        return () -> v;
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.cache.get(key);
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        try {
            return (T)this.cache.computeIfAbsent(key, v -> {
                try {
                    return valueLoader.call();
                }
                catch (Throwable ex) {
                    throw new WrappedException(ex);
                }
            });
        }
        catch (WrappedException ex) {
            throw new Cache.ValueRetrievalException(key, valueLoader, ex.getCause());
        }
    }

    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        return (Cache.ValueWrapper)this.cache.invoke(key, e -> {
            if (e.exists()) {
                return this.returnWrappedValue((CacheEntry<Object, Object>)e);
            }
            e.setValue(value);
            return null;
        });
    }

    public void evict(Object key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean evictIfPresent(Object key) {
        return this.cache.containsAndRemove(key);
    }

    public boolean invalidate() {
        boolean notEmpty = !this.cache.asMap().isEmpty();
        this.cache.clear();
        return notEmpty;
    }

    public boolean isLoaderPresent() {
        return false;
    }

    private class WrappedException
    extends RuntimeException {
        public WrappedException(Throwable cause) {
            super(cause);
        }
    }
}

