/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.io;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.cache2k.DataAware;
import org.cache2k.io.AsyncCacheLoader;

@FunctionalInterface
public interface AsyncBulkCacheLoader<K, V>
extends AsyncCacheLoader<K, V> {
    public void loadAll(Set<K> var1, Set<AsyncCacheLoader.Context<K, V>> var2, BulkCallback<K, V> var3) throws Exception;

    @Override
    default public void load(K key, AsyncCacheLoader.Context<K, V> context, final AsyncCacheLoader.Callback<V> callback) throws Exception {
        this.loadAll(null, Collections.singleton(context), new BulkCallback<K, V>(){

            @Override
            public void onLoadSuccess(Map<? extends K, ? extends V> data) {
                Map.Entry entry = data.entrySet().iterator().next();
                this.onLoadSuccess(entry.getKey(), entry.getValue());
            }

            @Override
            public void onLoadSuccess(K key, V value) {
                Objects.requireNonNull(key);
                callback.onLoadSuccess(value);
            }

            @Override
            public void onLoadFailure(Throwable exception) {
                callback.onLoadFailure(exception);
            }
        });
    }

    public static interface BulkCallback<K, V>
    extends DataAware<K, V> {
        public void onLoadSuccess(Map<? extends K, ? extends V> var1);

        public void onLoadSuccess(K var1, V var2);

        public void onLoadFailure(Throwable var1);
    }
}

