/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.TimeReference;
import org.cache2k.Weigher;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.configuration.CacheType;
import org.cache2k.configuration.CacheTypeCapture;
import org.cache2k.configuration.ConfigurationSection;
import org.cache2k.configuration.ConfigurationSectionBuilder;
import org.cache2k.configuration.CustomizationReferenceSupplier;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.event.CacheClosedListener;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.integration.AsyncCacheLoader;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.integration.LoadDetail;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.CacheLoader;
import org.cache2k.io.CacheWriter;
import org.cache2k.io.ExceptionInformation;
import org.cache2k.io.ResiliencePolicy;

public class Cache2kBuilder<K, V> {
    private static final String MSG_NO_TYPES = "Use Cache2kBuilder.forUnknownTypes(), to construct a builder with no key and value types";
    private CacheType<K> keyType;
    private CacheType<V> valueType;
    private Cache2kConfiguration<K, V> config = null;
    private CacheManager manager = null;

    public static Cache2kBuilder forUnknownTypes() {
        return new Cache2kBuilder(null, null);
    }

    public static <K, V> Cache2kBuilder<K, V> of(Class<K> keyType, Class<V> valueType) {
        return new Cache2kBuilder<K, V>(CacheTypeCapture.of(keyType), CacheTypeCapture.of(valueType));
    }

    public static <K, V> Cache2kBuilder<K, V> of(Cache2kConfiguration<K, V> c) {
        Cache2kBuilder<K, V> cb = new Cache2kBuilder<K, V>(c);
        return cb;
    }

    private Cache2kBuilder(Cache2kConfiguration<K, V> cfg) {
        this.withConfig(cfg);
    }

    protected Cache2kBuilder() {
        Type t = this.getClass().getGenericSuperclass();
        if (!(t instanceof ParameterizedType)) {
            throw new IllegalArgumentException(MSG_NO_TYPES);
        }
        Type[] types = ((ParameterizedType)t).getActualTypeArguments();
        this.keyType = CacheTypeCapture.of(types[0]).getBeanRepresentation();
        this.valueType = CacheTypeCapture.of(types[1]).getBeanRepresentation();
        if (Object.class.equals(this.keyType.getType()) && Object.class.equals(this.valueType.getType())) {
            throw new IllegalArgumentException(MSG_NO_TYPES);
        }
    }

    private Cache2kBuilder(CacheType<K> keyType, CacheType<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    private void withConfig(Cache2kConfiguration<K, V> cfg) {
        this.config = cfg;
    }

    private Cache2kConfiguration<K, V> config() {
        if (this.config == null) {
            if (this.manager == null) {
                this.manager = CacheManager.getInstance();
            }
            this.config = CacheManager.PROVIDER.getDefaultConfiguration(this.manager);
            if (this.keyType != null) {
                this.config.setKeyType(this.keyType);
            }
            if (this.valueType != null) {
                this.config.setValueType(this.valueType);
            }
        }
        return this.config;
    }

    public final Cache2kBuilder<K, V> manager(CacheManager manager) {
        if (this.manager != null) {
            throw new IllegalStateException("manager() must be first operation on builder.");
        }
        this.manager = manager;
        return this;
    }

    public final <K2> Cache2kBuilder<K2, V> keyType(Class<K2> t) {
        Cache2kBuilder me = this;
        me.config().setKeyType(t);
        return me;
    }

    public final <V2> Cache2kBuilder<K, V2> valueType(Class<V2> t) {
        Cache2kBuilder me = this;
        me.config().setValueType(t);
        return me;
    }

    public final <K2> Cache2kBuilder<K2, V> keyType(CacheType<K2> t) {
        Cache2kBuilder me = this;
        me.config().setKeyType(t);
        return me;
    }

    public final <V2> Cache2kBuilder<K, V2> valueType(CacheType<V2> t) {
        Cache2kBuilder me = this;
        me.config().setValueType(t);
        return me;
    }

    public final Cache2kBuilder<K, V> name(String uniqueName, Class<?> clazz, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException();
        }
        if (uniqueName == null) {
            return this.name(clazz, fieldName);
        }
        this.config().setName(uniqueName + '~' + clazz.getName() + "." + fieldName);
        return this;
    }

    public final Cache2kBuilder<K, V> name(Class<?> clazz, String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException();
        }
        this.config().setName(clazz.getName() + "." + fieldName);
        return this;
    }

    public final Cache2kBuilder<K, V> name(Class<?> clazz) {
        this.config().setName(clazz.getName());
        return this;
    }

    public final Cache2kBuilder<K, V> name(String v) {
        this.config().setName(v);
        return this;
    }

    public final Cache2kBuilder<K, V> keepDataAfterExpired(boolean v) {
        this.config().setKeepDataAfterExpired(v);
        return this;
    }

    public final Cache2kBuilder<K, V> entryCapacity(long v) {
        this.config().setEntryCapacity(v);
        return this;
    }

    public final Cache2kBuilder<K, V> eternal(boolean v) {
        this.config().setEternal(v);
        return this;
    }

    public final Cache2kBuilder<K, V> suppressExceptions(boolean v) {
        this.config().setSuppressExceptions(v);
        return this;
    }

    public final Cache2kBuilder<K, V> expireAfterWrite(long v, TimeUnit u) {
        this.config().setExpireAfterWrite(Cache2kBuilder.toDuration(v, u));
        return this;
    }

    public final Cache2kBuilder<K, V> timerLag(long v, TimeUnit u) {
        this.config().setTimerLag(Cache2kBuilder.toDuration(v, u));
        return this;
    }

    private static Duration toDuration(long v, TimeUnit u) {
        return Duration.ofMillis(u.toMillis(v));
    }

    public final Cache2kBuilder<K, V> exceptionPropagator(final ExceptionPropagator<K> ep) {
        org.cache2k.io.ExceptionPropagator newPropagator = new org.cache2k.io.ExceptionPropagator<K>(){

            @Override
            public RuntimeException propagateException(K key, final ExceptionInformation newInfo) {
                org.cache2k.integration.ExceptionInformation oldInfo = new org.cache2k.integration.ExceptionInformation(){

                    @Override
                    public ExceptionPropagator getExceptionPropagator() {
                        return ep;
                    }

                    @Override
                    public Throwable getException() {
                        return newInfo.getException();
                    }

                    @Override
                    public int getRetryCount() {
                        return newInfo.getRetryCount();
                    }

                    @Override
                    public long getSinceTime() {
                        return newInfo.getSinceTime();
                    }

                    @Override
                    public long getLoadTime() {
                        return newInfo.getLoadTime();
                    }

                    @Override
                    public long getUntil() {
                        return newInfo.getUntil();
                    }
                };
                return ep.propagateException(key, oldInfo);
            }
        };
        this.exceptionPropagator(newPropagator);
        return this;
    }

    public final Cache2kBuilder<K, V> exceptionPropagator(org.cache2k.io.ExceptionPropagator<K> ep) {
        this.config().setExceptionPropagator(Cache2kBuilder.wrapCustomizationInstance(ep));
        return this;
    }

    private static <T> CustomizationReferenceSupplier<T> wrapCustomizationInstance(T obj) {
        if (obj == null) {
            return null;
        }
        return new CustomizationReferenceSupplier<T>(obj);
    }

    @Deprecated
    public final Cache2kBuilder<K, V> loader(final org.cache2k.integration.AsyncCacheLoader<K, V> oldLoader) {
        AsyncCacheLoader newLoader = new AsyncCacheLoader<K, V>(){

            @Override
            public void load(K key, final AsyncCacheLoader.Context<K, V> context, final AsyncCacheLoader.Callback<V> callback) throws Exception {
                AsyncCacheLoader.Context oldContext = new AsyncCacheLoader.Context<K, V>(){

                    @Override
                    public long getLoadStartTime() {
                        return context.getLoadStartTime();
                    }

                    @Override
                    public K getKey() {
                        return context.getKey();
                    }

                    @Override
                    public Executor getExecutor() {
                        return context.getExecutor();
                    }

                    @Override
                    public Executor getLoaderExecutor() {
                        return context.getLoaderExecutor();
                    }

                    @Override
                    public CacheEntry<K, V> getCurrentEntry() {
                        return context.getCurrentEntry();
                    }
                };
                AsyncCacheLoader.Callback oldCallback = new AsyncCacheLoader.Callback<V>(){

                    @Override
                    public void onLoadSuccess(V value) {
                        callback.onLoadSuccess(value);
                    }

                    @Override
                    public void onLoadFailure(Throwable t) {
                        callback.onLoadFailure(t);
                    }
                };
                oldLoader.load(key, oldContext, oldCallback);
            }
        };
        this.loader(newLoader);
        return this;
    }

    public final Cache2kBuilder<K, V> loader(CacheLoader<K, V> l) {
        this.config().setLoader(Cache2kBuilder.wrapCustomizationInstance(l));
        return this;
    }

    public final Cache2kBuilder<K, V> loader(AdvancedCacheLoader<K, V> l) {
        this.config().setAdvancedLoader(Cache2kBuilder.wrapCustomizationInstance(l));
        return this;
    }

    public final Cache2kBuilder<K, V> loader(AsyncCacheLoader<K, V> l) {
        this.config().setAsyncLoader(Cache2kBuilder.wrapCustomizationInstance(l));
        return this;
    }

    public final Cache2kBuilder<K, V> wrappingLoader(AdvancedCacheLoader<K, LoadDetail<V>> l) {
        this.config().setAdvancedLoader((CustomizationSupplier)Cache2kBuilder.wrapCustomizationInstance(l));
        return this;
    }

    public final Cache2kBuilder<K, V> wrappingLoader(CacheLoader<K, LoadDetail<V>> l) {
        this.config().setAdvancedLoader((CustomizationSupplier)Cache2kBuilder.wrapCustomizationInstance(l));
        return this;
    }

    public final Cache2kBuilder<K, V> writer(CacheWriter<K, V> w) {
        this.config().setWriter(Cache2kBuilder.wrapCustomizationInstance(w));
        return this;
    }

    public final Cache2kBuilder<K, V> addCacheClosedListener(CacheClosedListener listener) {
        this.config().getCacheClosedListeners().add((CustomizationSupplier<CacheClosedListener>)Cache2kBuilder.wrapCustomizationInstance(listener));
        return this;
    }

    public final Cache2kBuilder<K, V> addListener(CacheEntryOperationListener<K, V> listener) {
        this.config().getListeners().add((CustomizationSupplier<CacheEntryOperationListener<K, V>>)Cache2kBuilder.wrapCustomizationInstance(listener));
        return this;
    }

    public final Cache2kBuilder<K, V> addAsyncListener(CacheEntryOperationListener<K, V> listener) {
        this.config().getAsyncListeners().add((CustomizationSupplier<CacheEntryOperationListener<K, V>>)Cache2kBuilder.wrapCustomizationInstance(listener));
        return this;
    }

    public final Cache2kBuilder<K, V> expiryPolicy(ExpiryPolicy<K, V> c) {
        this.config().setExpiryPolicy(Cache2kBuilder.wrapCustomizationInstance(c));
        return this;
    }

    public final Cache2kBuilder<K, V> refreshAhead(boolean f) {
        this.config().setRefreshAhead(f);
        return this;
    }

    public final Cache2kBuilder<K, V> sharpExpiry(boolean f) {
        this.config().setSharpExpiry(f);
        return this;
    }

    public final Cache2kBuilder<K, V> loaderThreadCount(int v) {
        this.config().setLoaderThreadCount(v);
        return this;
    }

    public final Cache2kBuilder<K, V> storeByReference(boolean v) {
        this.config().setStoreByReference(v);
        return this;
    }

    public final Cache2kBuilder<K, V> retryInterval(long v, TimeUnit u) {
        this.config().setRetryInterval(Cache2kBuilder.toDuration(v, u));
        return this;
    }

    public final Cache2kBuilder<K, V> maxRetryInterval(long v, TimeUnit u) {
        this.config().setMaxRetryInterval(Cache2kBuilder.toDuration(v, u));
        return this;
    }

    public final Cache2kBuilder<K, V> resilienceDuration(long v, TimeUnit u) {
        this.config().setResilienceDuration(Cache2kBuilder.toDuration(v, u));
        return this;
    }

    public final Cache2kBuilder<K, V> resiliencePolicy(ResiliencePolicy<K, V> v) {
        this.config().setResiliencePolicy(Cache2kBuilder.wrapCustomizationInstance(v));
        return this;
    }

    public final Cache2kBuilder<K, V> with(ConfigurationSectionBuilder<? extends ConfigurationSection> ... sectionBuilders) {
        for (ConfigurationSectionBuilder<? extends ConfigurationSection> b : sectionBuilders) {
            this.config().getSections().add(b.buildConfigurationSection());
        }
        return this;
    }

    public final Cache2kBuilder<K, V> strictEviction(boolean flag) {
        this.config().setStrictEviction(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> permitNullValues(boolean flag) {
        this.config().setPermitNullValues(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> disableStatistics(boolean flag) {
        this.config().setDisableStatistics(flag);
        return this;
    }

    @Deprecated
    public final Cache2kBuilder<K, V> disableLastModificationTime(boolean flag) {
        return this;
    }

    public final Cache2kBuilder<K, V> recordRefreshedTime(boolean flag) {
        this.config().setRecordRefreshedTime(flag);
        return this;
    }

    public final Cache2kBuilder<K, V> boostConcurrency(boolean f) {
        this.config().setBoostConcurrency(f);
        return this;
    }

    public final Cache2kBuilder<K, V> enableJmx(boolean f) {
        this.config().setEnableJmx(f);
        return this;
    }

    public final Cache2kBuilder<K, V> disableMonitoring(boolean f) {
        this.config().setDisableMonitoring(f);
        return this;
    }

    public final Cache2kBuilder<K, V> loaderExecutor(Executor v) {
        this.config().setLoaderExecutor(new CustomizationReferenceSupplier<Executor>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> refreshExecutor(Executor v) {
        this.config().setRefreshExecutor(new CustomizationReferenceSupplier<Executor>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> executor(Executor v) {
        this.config().setExecutor(new CustomizationReferenceSupplier<Executor>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> asyncListenerExecutor(Executor v) {
        this.config().setAsyncListenerExecutor(new CustomizationReferenceSupplier<Executor>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> timeReference(TimeReference v) {
        this.config().setTimeReference(new CustomizationReferenceSupplier<TimeReference>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> weigher(Weigher<K, V> v) {
        this.config().setWeigher(new CustomizationReferenceSupplier<Weigher>(v));
        return this;
    }

    public final Cache2kBuilder<K, V> maximumWeight(long v) {
        this.config().setMaximumWeight(v);
        return this;
    }

    public final Cache2kConfiguration<K, V> toConfiguration() {
        return this.config();
    }

    public final CacheManager getManager() {
        return this.manager;
    }

    public final Cache<K, V> build() {
        return CacheManager.PROVIDER.createCache(this.manager, this.config());
    }
}

