/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class SingleProviderResolver {
    private static final Map<Class, Object> PROVIDERS = new HashMap<Class, Object>();

    public static <T> T resolveMandatory(Class<T> c) {
        T obj = SingleProviderResolver.resolve(c);
        if (obj == null) {
            LinkageError err = new LinkageError("No implementation found for: " + c.getName());
            throw err;
        }
        return obj;
    }

    public static <T> T resolve(Class<T> c) {
        return SingleProviderResolver.resolve(c, null);
    }

    public static synchronized <T> T resolve(Class<T> c, Class<? extends T> defaultImpl) {
        if (PROVIDERS.containsKey(c)) {
            return (T)PROVIDERS.get(c);
        }
        try {
            String className = SingleProviderResolver.readFile("org/cache2k/services/" + c.getName());
            T obj = null;
            if (className == null) {
                ServiceLoader<T> sl = ServiceLoader.load(c);
                Iterator<T> it = sl.iterator();
                if (it.hasNext()) {
                    obj = it.next();
                }
            } else {
                obj = (T)SingleProviderResolver.class.getClassLoader().loadClass(className).newInstance();
            }
            if (obj == null && defaultImpl != null) {
                obj = defaultImpl.newInstance();
            }
            PROVIDERS.put(c, obj);
            return obj;
        }
        catch (Exception ex) {
            LinkageError err = new LinkageError("Error instantiating " + c.getName(), ex);
            err.printStackTrace();
            throw err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String name) throws IOException {
        InputStream in = SingleProviderResolver.class.getClassLoader().getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        try {
            LineNumberReader r = new LineNumberReader(new InputStreamReader(in));
            String l = r.readLine();
            while (l != null) {
                if (!l.startsWith("#")) {
                    String string = l;
                    return string;
                }
                l = r.readLine();
            }
        }
        finally {
            in.close();
        }
        return null;
    }
}

