/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.configuration;

import org.cache2k.CacheManager;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.configuration.ValidatingConfigurationBean;

public final class CustomizationSupplierByClassName<T>
implements CustomizationSupplier<T>,
ValidatingConfigurationBean {
    private String className;

    public CustomizationSupplierByClassName() {
    }

    public CustomizationSupplierByClassName(String className) {
        if (className == null) {
            throw new NullPointerException("className");
        }
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String v) {
        this.className = v;
    }

    @Override
    public void validate() {
        if (this.className == null) {
            throw new IllegalArgumentException("className not set");
        }
    }

    @Override
    public T supply(CacheManager manager) throws Exception {
        return (T)manager.getClassLoader().loadClass(this.className).newInstance();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CustomizationSupplierByClassName)) {
            return false;
        }
        CustomizationSupplierByClassName that = (CustomizationSupplierByClassName)other;
        return this.className.equals(that.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }
}

