/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.util.concurrent.TimeUnit;
import org.cache2k.AnyBuilder;
import org.cache2k.BaseAnyBuilder;
import org.cache2k.spi.SingleProviderResolver;
import org.cache2k.spi.StorageImplementation;
import org.cache2k.storage.SimpleSingleFileStorage;

public class StorageConfiguration<EX> {
    boolean reliable;
    boolean purgeOnStartup;
    boolean ignoreModifications;
    Class<? extends StorageImplementation> implementation = SimpleSingleFileStorage.class;
    boolean passivation = false;
    boolean readOnly = false;
    String location;
    String storageName;
    int entryCapacity = -1;
    int bytesCapacity;
    long syncInterval = 7000L;
    EX extraConfiguration;
    boolean flushOnClose = false;

    public boolean isReliable() {
        return this.reliable;
    }

    public void setReliable(boolean reliable) {
        this.reliable = reliable;
    }

    public void setPurgeOnStartup(boolean purgeOnStartup) {
        this.purgeOnStartup = purgeOnStartup;
    }

    public boolean isPurgeOnStartup() {
        return this.purgeOnStartup;
    }

    public void setIgnoreModifications(boolean ignoreModifications) {
        this.ignoreModifications = ignoreModifications;
    }

    public void setImplementation(Class<? extends StorageImplementation> c) {
        this.implementation = c;
    }

    public void setPassivation(boolean passivation) {
        this.passivation = passivation;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setEntryCapacity(int entryCapacity) {
        this.entryCapacity = entryCapacity;
    }

    public void setBytesCapacity(int bytesCapacity) {
        this.bytesCapacity = bytesCapacity;
    }

    public void setSyncInterval(long v, TimeUnit u) {
        this.syncInterval = u.toMillis(v);
    }

    public boolean isIgnoreModifications() {
        return this.ignoreModifications;
    }

    public Class<?> getImplementation() {
        return this.implementation;
    }

    public boolean isPassivation() {
        return this.passivation;
    }

    public String getLocation() {
        return this.location;
    }

    public int getEntryCapacity() {
        return this.entryCapacity;
    }

    public int getBytesCapacity() {
        return this.bytesCapacity;
    }

    public long getFlushIntervalMillis() {
        return this.syncInterval;
    }

    public EX getExtraConfiguration() {
        return this.extraConfiguration;
    }

    public void setExtraConfiguration(EX extraConfiguration) {
        this.extraConfiguration = extraConfiguration;
    }

    public boolean isFlushOnClose() {
        return this.flushOnClose;
    }

    public void setFlushOnClose(boolean f) {
        this.flushOnClose = f;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String v) {
        this.storageName = v;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public static class Builder<K, T, OPT_EXTRA_CONFIG>
    extends BaseAnyBuilder<K, T, StorageConfiguration> {
        private StorageConfiguration<Object> config = new StorageConfiguration();
        private AnyBuilder<K, T, ?> extraConfigurationBuilder = null;

        public Builder<K, T, OPT_EXTRA_CONFIG> passivation(boolean f) {
            this.config.passivation = f;
            return this;
        }

        public Builder<K, T, OPT_EXTRA_CONFIG> reliable(boolean f) {
            this.config.reliable = f;
            return this;
        }

        public Builder<K, T, OPT_EXTRA_CONFIG> purgeOnStartup(boolean f) {
            this.config.purgeOnStartup = f;
            return this;
        }

        public Builder<K, T, OPT_EXTRA_CONFIG> flushOnClose(boolean f) {
            this.config.flushOnClose = f;
            return this;
        }

        public Builder<K, T, OPT_EXTRA_CONFIG> readOnly(boolean f) {
            this.config.readOnly = f;
            return this;
        }

        public Builder<K, T, OPT_EXTRA_CONFIG> location(String s) {
            this.config.location = s;
            return this;
        }

        public Builder<K, T, OPT_EXTRA_CONFIG> entryCapacity(int v) {
            this.config.entryCapacity = v;
            return this;
        }

        public Builder<K, T, OPT_EXTRA_CONFIG> bytesCapacity(int v) {
            this.config.bytesCapacity = v;
            return this;
        }

        public Builder<K, T, OPT_EXTRA_CONFIG> syncInterval(int v, TimeUnit u) {
            this.config.syncInterval = (int)u.toMillis(v);
            return this;
        }

        public Builder<K, T, OPT_EXTRA_CONFIG> storageName(String s) {
            this.config.storageName = s;
            return this;
        }

        public <EXTRA_CONFIG_BUILDER extends AnyBuilder<K, T, ?>> Builder<K, T, EXTRA_CONFIG_BUILDER> implementation(Class<? extends StorageImplementation<EXTRA_CONFIG_BUILDER>> c) {
            StorageImplementation<EXTRA_CONFIG_BUILDER> imp = SingleProviderResolver.getInstance().resolve(c);
            this.config.setImplementation(c);
            this.extraConfigurationBuilder = imp.createConfigurationBuilder(this.root());
            return this;
        }

        public <EXTRA_CONFIG_BUILDER extends AnyBuilder<K, T, ?>> EXTRA_CONFIG_BUILDER extra(Class<? extends StorageImplementation<EXTRA_CONFIG_BUILDER>> c) {
            StorageImplementation<EXTRA_CONFIG_BUILDER> imp = SingleProviderResolver.getInstance().resolve(c);
            this.config.setImplementation(c);
            this.extraConfigurationBuilder = imp.createConfigurationBuilder(this.root());
            return (EXTRA_CONFIG_BUILDER)this.extraConfigurationBuilder;
        }

        public OPT_EXTRA_CONFIG extra() {
            if (this.extraConfigurationBuilder == null) {
                throw new IllegalArgumentException("storage implementation has no extra configuration");
            }
            return (OPT_EXTRA_CONFIG)this.extraConfigurationBuilder;
        }

        @Override
        public StorageConfiguration createConfiguration() {
            if (this.extraConfigurationBuilder != null) {
                this.config.setExtraConfiguration(this.extraConfigurationBuilder.createConfiguration());
            }
            return this.config;
        }
    }
}

