/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.util.Collection;
import javax.annotation.Nullable;
import org.cache2k.Cache;
import org.cache2k.CacheConfig;
import org.cache2k.CacheSource;
import org.cache2k.CacheSourceWithMetaInfo;
import org.cache2k.ExperimentalBulkCacheSource;
import org.cache2k.RefreshController;

public abstract class CacheBuilder<K, T>
implements Cloneable {
    private static CacheBuilder PROTO;
    protected CacheConfig config;
    protected CacheSource cacheSource;
    protected CacheSourceWithMetaInfo cacheSourceWithMetaInfo;
    protected RefreshController refreshController;
    protected ExperimentalBulkCacheSource experimentalBulkCacheSource;

    public static <K, T> CacheBuilder<K, T> newCache(Class<K> _keyType, Class<T> _valueType) {
        CacheBuilder cb = null;
        try {
            cb = (CacheBuilder)PROTO.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        cb.ctor(_keyType, _valueType, null);
        return cb;
    }

    public static <K, C extends Collection<T>, T> CacheBuilder<K, C> newCache(Class<K> _keyType, Class<C> _collectionType, Class<T> _entryType) {
        CacheBuilder cb = null;
        try {
            cb = (CacheBuilder)PROTO.clone();
        }
        catch (CloneNotSupportedException ignored) {
            // empty catch block
        }
        cb.ctor(_keyType, _collectionType, _entryType);
        return cb;
    }

    protected void ctor(Class<K> _keyType, Class<T> _valueType, @Nullable Class<?> _entryType) {
        this.config = new CacheConfig();
        this.config.setValueType(_valueType);
        this.config.setKeyType(_keyType);
        this.config.setEntryType(_entryType);
    }

    public CacheBuilder<K, T> name(Class<?> _class, String _fieldName) {
        this.config.setName(_class.getSimpleName() + "." + _fieldName);
        return this;
    }

    public CacheBuilder<K, T> name(Class<?> _class) {
        this.config.setName(_class.getSimpleName());
        return this;
    }

    public CacheBuilder<K, T> name(Object _containingObject, String _fieldName) {
        return this.name(_containingObject.getClass(), _fieldName);
    }

    public CacheBuilder<K, T> name(String v) {
        this.config.setName(v);
        return this;
    }

    public CacheBuilder<K, T> maxSize(int v) {
        this.config.setMaxSize(v);
        return this;
    }

    public CacheBuilder<K, T> maxSizeBound(int v) {
        this.config.setMaxSizeHighBound(v);
        return this;
    }

    public CacheBuilder<K, T> backgroundRefresh(boolean f) {
        this.config.setBackgroundRefresh(f);
        return this;
    }

    public CacheBuilder<K, T> expirySecs(int v) {
        this.config.setExpirySeconds(v);
        return this;
    }

    public CacheBuilder<K, T> source(CacheSource<K, T> g) {
        this.cacheSource = g;
        return this;
    }

    public CacheBuilder<K, T> source(CacheSourceWithMetaInfo<K, T> g) {
        this.cacheSourceWithMetaInfo = g;
        return this;
    }

    public CacheBuilder<K, T> source(ExperimentalBulkCacheSource<K, T> g) {
        this.experimentalBulkCacheSource = g;
        return this;
    }

    public CacheBuilder<K, T> refreshController(RefreshController c) {
        this.refreshController = c;
        return this;
    }

    public CacheBuilder<K, T> implementation(Class<?> c) {
        this.config.setImplementation(c);
        return this;
    }

    public CacheConfig getConfig() {
        return this.config;
    }

    public abstract Cache<K, T> build();

    static {
        try {
            PROTO = (CacheBuilder)Class.forName("org.cache2k.impl.CacheBuilderImpl").newInstance();
        }
        catch (Exception ex) {
            throw new LinkageError("cache2k-core implementation missing", ex);
        }
    }
}

