/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.cache2k.core.AbstractEviction;
import org.cache2k.core.Entry;
import org.cache2k.core.Eviction;
import org.cache2k.core.EvictionMetrics;
import org.cache2k.core.EvictionThread;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.concurrency.Job;

public class QueuedEviction
implements Eviction,
EvictionThread.Job {
    private static final int MAX_POLLS = 23;
    private static final AtomicInteger runnerIndex = new AtomicInteger();
    private static final EvictionThread[] threadRunners = new EvictionThread[Runtime.getRuntime().availableProcessors()];
    private Queue<Entry> queue = new ArrayBlockingQueue<Entry>(127);
    private AbstractEviction forward;
    private EvictionThread threadRunner = threadRunners[runnerIndex.getAndIncrement() % threadRunners.length];

    public QueuedEviction(AbstractEviction _forward) {
        this.forward = _forward;
        this.threadRunner.addJob(this);
    }

    @Override
    public void submit(Entry e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean submitWithoutEviction(Entry e) {
        if (this.queue.offer(e)) {
            this.threadRunner.ensureRunning();
            return false;
        }
        return this.forward.submitWithoutEviction(e);
    }

    @Override
    public void evictEventually(int hc) {
        this.forward.evictEventually(hc);
    }

    @Override
    public void evictEventually() {
        this.forward.evictEventually();
    }

    @Override
    public long removeAll() {
        long _removedCount = this.forward.removeAll();
        return _removedCount;
    }

    @Override
    public void close() {
        runnerIndex.decrementAndGet();
        this.stop();
    }

    @Override
    public boolean runEvictionJob() {
        Entry e = this.queue.poll();
        if (e == null) {
            return false;
        }
        int _pollCount = 23;
        do {
            this.forward.submit(e);
        } while (--_pollCount != 0 && (e = this.queue.poll()) != null);
        return true;
    }

    @Override
    public boolean drain() {
        Entry e = this.queue.poll();
        if (e == null) {
            return false;
        }
        do {
            this.forward.submitWithoutEviction(e);
        } while ((e = this.queue.poll()) != null);
        return true;
    }

    @Override
    public void checkIntegrity(IntegrityState _integrityState) {
        this.forward.checkIntegrity(_integrityState);
    }

    @Override
    public void stop() {
        this.threadRunner.removeJob(this);
    }

    @Override
    public void start() {
        this.threadRunner.addJob(this);
    }

    @Override
    public <T> T runLocked(Job<T> j) {
        return this.forward.runLocked(j);
    }

    @Override
    public EvictionMetrics getMetrics() {
        return this.forward.getMetrics();
    }

    static {
        for (int i = 0; i < threadRunners.length; ++i) {
            QueuedEviction.threadRunners[i] = new EvictionThread();
        }
    }
}

