/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.concurrent.ThreadFactory;
import org.cache2k.core.HeapCache;

public class EvictionThread {
    private static final ThreadFactory THREAD_FACTORY = HeapCache.TUNABLE.threadFactoryProvider.newThreadFactory("cache2k-evict");
    private static final int YIELD_SPINS = 33;
    private static final int YIELD_TIMEOUT = 5432;
    private final Object lock = new Object();
    private Thread thread;
    private Job[] jobs = new Job[0];
    private volatile boolean stopped = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureRunning() {
        if (this.stopped) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.stopped) {
                    return;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        EvictionThread.this.runJobs();
                    }
                };
                this.thread = THREAD_FACTORY.newThread(r);
                this.thread.start();
                this.stopped = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Job j) {
        Object object = this.lock;
        synchronized (object) {
            Job[] ja = new Job[this.jobs.length + 1];
            System.arraycopy(this.jobs, 0, ja, 0, this.jobs.length);
            ja[this.jobs.length] = j;
            this.jobs = ja;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(Job j) {
        Object object = this.lock;
        synchronized (object) {
            Job[] ja = new Job[this.jobs.length - 1];
            int idx = 0;
            try {
                for (Job j2 : this.jobs) {
                    if (j == j2) continue;
                    ja[idx++] = j2;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return;
            }
            this.jobs = ja;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJobs() {
        boolean _hadWork = false;
        long t0 = System.currentTimeMillis();
        int _spinCounter = 33;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                for (Job j : this.jobs) {
                    _hadWork |= j.runEvictionJob();
                }
            }
            if (_hadWork) {
                _spinCounter = 33;
                continue;
            }
            if (_spinCounter-- >= 0) {
                try {
                    Thread.sleep(27L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            if (t0 == 0L) {
                t0 = System.currentTimeMillis() + 5432L;
                _spinCounter = 33;
                continue;
            }
            if (System.currentTimeMillis() >= t0) break;
            _spinCounter = 33;
        }
        this.stopped = true;
    }

    static interface Job {
        public boolean runEvictionJob();
    }
}

