/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.text.DecimalFormat;
import java.util.concurrent.ThreadPoolExecutor;
import org.cache2k.core.CollisionInfo;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.EvictionMetrics;
import org.cache2k.core.HeapCache;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.core.StorageMetrics;
import org.cache2k.core.util.Util;

class CacheBaseInfo
implements InternalCacheInfo {
    private CommonMetrics metrics;
    private StorageMetrics storageMetrics = StorageMetrics.DUMMY;
    private HeapCache heapCache;
    private InternalCache cache;
    private long size;
    private long infoCreatedTime;
    private int infoCreationDeltaMs;
    private long missCnt;
    private long storageMissCnt;
    private long hitCnt;
    private long correctedPutCnt;
    private CollisionInfo collisionInfo;
    private String extraStatistics;
    private IntegrityState integrityState;
    private long asyncLoadsStarted = 0L;
    private long asyncLoadsInFlight = 0L;
    private int loaderThreadsLimit = 0;
    private int loaderThreadsMaxActive = 0;
    private long totalLoadCnt;
    private long clearedTime;
    private long newEntryCnt;
    private long keyMutationCnt;
    private long removedCnt;
    private long clearRemovedCnt;
    private long clearCnt;
    private long expiredRemoveCnt;
    private long evictedCnt;
    private long maxSize;
    private int evictionRunningCnt;

    public CacheBaseInfo(HeapCache _heapCache, InternalCache _userCache, long now) {
        this.infoCreatedTime = now;
        this.cache = _userCache;
        this.heapCache = _heapCache;
        this.metrics = _heapCache.metrics;
        EvictionMetrics em = _heapCache.eviction.getMetrics();
        this.newEntryCnt = em.getNewEntryCount();
        this.expiredRemoveCnt = em.getExpiredRemovedCount();
        this.evictedCnt = em.getEvictedCount();
        this.maxSize = em.getMaxSize();
        this.clearedTime = _heapCache.clearedTime;
        this.keyMutationCnt = _heapCache.keyMutationCnt;
        this.removedCnt = em.getRemovedCount();
        this.clearRemovedCnt = _heapCache.clearRemovedCnt;
        this.clearCnt = _heapCache.clearCnt;
        this.evictionRunningCnt = em.getEvictionRunningCount();
        this.integrityState = _heapCache.getIntegrityState();
        this.storageMetrics = _userCache.getStorageMetrics();
        this.collisionInfo = new CollisionInfo();
        _heapCache.hash.calcHashCollisionInfo(this.collisionInfo);
        this.extraStatistics = em.getExtraStatistics();
        if (this.extraStatistics.startsWith(", ")) {
            this.extraStatistics = this.extraStatistics.substring(2);
        }
        this.size = this.heapCache.getLocalSize();
        this.missCnt = this.metrics.getLoadCount() + this.metrics.getReloadCount() + this.metrics.getPeekHitNotFreshCount() + this.metrics.getPeekMissCount();
        this.storageMissCnt = this.storageMetrics.getReadMissCount() + this.storageMetrics.getReadNonFreshCount();
        this.hitCnt = em.getHitCount();
        this.correctedPutCnt = this.metrics.getPutNewEntryCount() + this.metrics.getPutHitCount() + this.metrics.getPutNoReadHitCount();
        if (_heapCache.loaderExecutor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor ex = (ThreadPoolExecutor)_heapCache.loaderExecutor;
            this.asyncLoadsInFlight = ex.getActiveCount();
            this.asyncLoadsStarted = ex.getTaskCount();
            this.loaderThreadsLimit = ex.getCorePoolSize();
            this.loaderThreadsMaxActive = ex.getLargestPoolSize();
        }
        this.totalLoadCnt = this.metrics.getLoadCount() + this.metrics.getReloadCount() + this.metrics.getRefreshCount();
    }

    String percentString(double d) {
        String s = Double.toString(d);
        return (s.length() > 5 ? s.substring(0, 5) : s) + "%";
    }

    public void setInfoCreationDeltaMs(int _millis) {
        this.infoCreationDeltaMs = _millis;
    }

    @Override
    public String getName() {
        return this.heapCache.name;
    }

    @Override
    public String getImplementation() {
        return this.cache.getClass().getSimpleName();
    }

    @Override
    public long getReloadCount() {
        return this.metrics.getReloadCount();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getHeapCapacity() {
        return this.maxSize;
    }

    @Override
    public long getStorageHitCnt() {
        return this.storageMetrics.getReadHitCount();
    }

    @Override
    public long getStorageMissCnt() {
        return this.storageMissCnt;
    }

    @Override
    public long getGetCount() {
        long _putHit = this.metrics.getPutNoReadHitCount();
        long _heapHitButNoRead = this.metrics.getHeapHitButNoReadCount();
        return this.hitCnt + this.metrics.getPeekMissCount() + this.metrics.getLoadCount() - _putHit - _heapHitButNoRead;
    }

    @Override
    public long getMissCount() {
        return this.missCnt;
    }

    @Override
    public long getNewEntryCount() {
        return this.newEntryCnt;
    }

    @Override
    public long getHeapHitCount() {
        return this.hitCnt;
    }

    @Override
    public long getLoadCount() {
        return this.totalLoadCnt;
    }

    @Override
    public long getRefreshCount() {
        return this.metrics.getRefreshCount();
    }

    @Override
    public long getInternalExceptionCount() {
        return this.metrics.getInternalExceptionCount();
    }

    @Override
    public long getRefreshFailedCount() {
        return this.metrics.getRefreshFailedCount();
    }

    @Override
    public long getSuppressedExceptionCount() {
        return this.metrics.getSuppressedExceptionCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.metrics.getLoadExceptionCount() + this.metrics.getSuppressedExceptionCount();
    }

    @Override
    public long getRefreshedHitCount() {
        return this.metrics.getRefreshedHitCount();
    }

    @Override
    public long getExpiredCount() {
        return this.expiredRemoveCnt + this.metrics.getExpiredKeptCount();
    }

    @Override
    public long getEvictedCount() {
        return this.evictedCnt;
    }

    @Override
    public int getEvictionRunningCount() {
        return this.evictionRunningCnt;
    }

    @Override
    public long getRemovedCount() {
        return this.removedCnt;
    }

    @Override
    public long getPutCount() {
        return this.correctedPutCnt;
    }

    @Override
    public long getGoneSpinCount() {
        return this.metrics.getGoneSpinCount();
    }

    @Override
    public long getKeyMutationCount() {
        return this.keyMutationCnt;
    }

    @Override
    public long getTimerEventCount() {
        return this.metrics.getTimerEventCount();
    }

    @Override
    public double getHitRate() {
        long cnt = this.getGetCount();
        return cnt == 0L ? 0.0 : (double)(cnt - this.missCnt) * 100.0 / (double)cnt;
    }

    @Override
    public String getHitRateString() {
        return this.percentString(this.getHitRate());
    }

    @Override
    public int getNoCollisionPercent() {
        if (this.size == 0L) {
            return 100;
        }
        return (int)((this.size - (long)this.collisionInfo.collisionCnt) * 100L / this.size);
    }

    @Override
    public int getHashQuality() {
        return CacheBaseInfo.hashQuality(this.getNoCollisionPercent(), this.getHashLongestSlotSize());
    }

    @Override
    public double getMillisPerLoad() {
        return this.getLoadCount() == 0L ? 0.0 : (double)this.metrics.getLoadMillis() * 1.0 / (double)this.getLoadCount();
    }

    @Override
    public long getLoadMillis() {
        return this.metrics.getLoadMillis();
    }

    @Override
    public int getHashCollisionCount() {
        return this.collisionInfo.collisionCnt;
    }

    @Override
    public int getHashCollisionSlotCount() {
        return this.collisionInfo.collisionSlotCnt;
    }

    @Override
    public int getHashLongestSlotSize() {
        return this.collisionInfo.longestCollisionSize;
    }

    @Override
    public String getIntegrityDescriptor() {
        return this.integrityState.getStateDescriptor();
    }

    @Override
    public long getStartedTime() {
        return this.heapCache.startedTime;
    }

    @Override
    public long getClearedTime() {
        return this.clearedTime;
    }

    @Override
    public long getInfoCreatedTime() {
        return this.infoCreatedTime;
    }

    @Override
    public int getInfoCreationDeltaMs() {
        return this.infoCreationDeltaMs;
    }

    @Override
    public int getHealth() {
        if (this.getHashQuality() < 30 || this.getKeyMutationCount() > 0L || this.getInternalExceptionCount() > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getAsyncLoadsStarted() {
        return this.asyncLoadsStarted;
    }

    @Override
    public long getAsyncLoadsInFlight() {
        return this.asyncLoadsInFlight;
    }

    @Override
    public int getLoaderThreadsLimit() {
        return this.loaderThreadsLimit;
    }

    @Override
    public int getLoaderThreadsMaxActive() {
        return this.loaderThreadsMaxActive;
    }

    @Override
    public String getExtraStatistics() {
        return this.extraStatistics;
    }

    private static String timestampToString(long t) {
        if (t == 0L) {
            return "-";
        }
        return Util.formatMillis(t);
    }

    @Override
    public long getClearCount() {
        return this.clearCnt;
    }

    @Override
    public long getRemoveByClearCount() {
        return this.clearRemovedCnt;
    }

    public String toString() {
        return "Cache{" + this.heapCache.name + "}(size=" + this.getSize() + ", capacity=" + (this.getHeapCapacity() != Long.MAX_VALUE ? Long.valueOf(this.getHeapCapacity()) : "unlimited") + ", get=" + this.getGetCount() + ", miss=" + this.getMissCount() + ", put=" + this.getPutCount() + ", load=" + this.getLoadCount() + ", reload=" + this.getReloadCount() + ", heapHit=" + this.getHeapHitCount() + ", refresh=" + this.getRefreshCount() + ", refreshFailed=" + this.getRefreshFailedCount() + ", refreshedHit=" + this.getRefreshedHitCount() + ", loadException=" + this.getLoadExceptionCount() + ", suppressedException=" + this.getSuppressedExceptionCount() + ", new=" + this.getNewEntryCount() + ", expire=" + this.getExpiredCount() + ", remove=" + this.getRemovedCount() + ", clear=" + this.getClearCount() + ", removeByClear=" + this.getRemoveByClearCount() + ", evict=" + this.getEvictedCount() + ", timer=" + this.getTimerEventCount() + ", goneSpin=" + this.getGoneSpinCount() + ", hitRate=" + this.getHitRateString() + ", msecs/load=" + CacheBaseInfo.formatMillisPerLoad(this.getMillisPerLoad()) + ", asyncLoadsStarted=" + this.asyncLoadsStarted + ", asyncLoadsInFlight=" + this.asyncLoadsInFlight + ", loaderThreadsLimit=" + this.loaderThreadsLimit + ", loaderThreadsMaxActive=" + this.loaderThreadsMaxActive + ", created=" + CacheBaseInfo.timestampToString(this.getStartedTime()) + ", cleared=" + CacheBaseInfo.timestampToString(this.getClearedTime()) + ", infoCreated=" + CacheBaseInfo.timestampToString(this.getInfoCreatedTime()) + ", infoCreationDeltaMs=" + this.getInfoCreationDeltaMs() + ", collisions=" + this.getHashCollisionCount() + ", collisionSlots=" + this.getHashCollisionSlotCount() + ", longestSlot=" + this.getHashLongestSlotSize() + ", hashQuality=" + this.getHashQuality() + ", noCollisionPercent=" + this.getNoCollisionPercent() + ", impl=" + this.getImplementation() + ", " + this.getExtraStatistics() + ", evictionRunning=" + this.getEvictionRunningCount() + ", keyMutation=" + this.getKeyMutationCount() + ", internalException=" + this.getInternalExceptionCount() + ", integrityState=" + this.getIntegrityDescriptor() + ")";
    }

    static String formatMillisPerLoad(double val) {
        if (val < 0.0) {
            return "-";
        }
        DecimalFormat f = new DecimalFormat("#.###");
        return f.format(val);
    }

    static int hashQuality(int _noCollisionPercent, int _longestSlot) {
        if (_longestSlot == 0) {
            return 100;
        }
        double _EXPONENT_CONSTANT = -0.011;
        int _SLOT_SIZE_MINIMUM = 5;
        int _correctionForOversizeSlot = (int)((1.0 - Math.exp(-0.011 * (double)Math.max(0, _longestSlot - 5))) * 100.0);
        int _quality = _noCollisionPercent - _correctionForOversizeSlot;
        return Math.max(0, Math.min(100, _quality));
    }
}

