/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.cache2k.CacheManager;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.spi.Cache2kManagerProvider;

public class Cache2kManagerProviderImpl
implements Cache2kManagerProvider {
    static final String DEFAULT_MANAGER_NAME = "default";
    private CacheManager defaultManager;
    private String defaultName = "default";
    private Map<ClassLoader, Map<String, CacheManager>> loader2name2manager = new WeakHashMap<ClassLoader, Map<String, CacheManager>>();

    public Object getLockObject() {
        return this.loader2name2manager;
    }

    @Override
    public void setDefaultName(String s) {
        if (this.defaultManager != null) {
            throw new IllegalStateException("default CacheManager already created");
        }
        this.defaultName = s;
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheManager getManager(ClassLoader cl, String _name, Properties p) {
        Object object = this.getLockObject();
        synchronized (object) {
            CacheManager cm;
            Map<String, CacheManager> map;
            if (cl == null) {
                cl = this.getDefaultClassLoader();
            }
            if ((map = this.loader2name2manager.get(cl)) == null) {
                map = new HashMap<String, CacheManager>();
                this.loader2name2manager.put(cl, map);
            }
            if ((cm = map.get(_name)) == null) {
                cm = new CacheManagerImpl(cl, _name, p);
                map.put(_name, cm);
            }
            return cm;
        }
    }

    @Override
    public CacheManager getDefaultManager(Properties p) {
        if (this.defaultManager != null) {
            return this.defaultManager;
        }
        this.defaultManager = this.getManager(this.getDefaultClassLoader(), this.getDefaultName(), p);
        return this.defaultManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeManager(CacheManager cm) {
        Object object = this.getLockObject();
        synchronized (object) {
            for (Map<String, CacheManager> m : this.loader2name2manager.values()) {
                Iterator<CacheManager> it = m.values().iterator();
                while (it.hasNext()) {
                    CacheManager cm2 = it.next();
                    if (cm != cm2) continue;
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(ClassLoader l) {
        HashSet<CacheManager> _managers = new HashSet<CacheManager>();
        Iterator iterator = this.getLockObject();
        synchronized (iterator) {
            Map<String, CacheManager> map = this.loader2name2manager.get(l);
            if (map == null) {
                return;
            }
            _managers.addAll(map.values());
        }
        for (CacheManager cm : _managers) {
            cm.close();
        }
    }

    @Override
    public void close() {
        for (ClassLoader cl : this.loader2name2manager.keySet()) {
            this.close(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(ClassLoader l, String _name) {
        CacheManager cm;
        Object object = this.getLockObject();
        synchronized (object) {
            Map<String, CacheManager> map = this.loader2name2manager.get(l);
            if (map == null) {
                return;
            }
            cm = map.get(_name);
            if (cm == null) {
                return;
            }
        }
        cm.close();
    }
}

