/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.core.Entry;
import org.cache2k.core.Eviction;
import org.cache2k.core.EvictionMetrics;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.concurrency.Job;

public abstract class AbstractEviction
implements Eviction,
EvictionMetrics {
    private static final int MINIMAL_CHUNK_SIZE = 4;
    private static final int MAXIMAL_CHUNK_SIZE = 64;
    private static final long MINIMUM_CAPACITY_FOR_CHUNKING = 1000L;
    protected final long maxSize;
    protected final long correctedMaxSize;
    protected final HeapCache heapCache;
    private final Object lock = new Object();
    private long newEntryCounter;
    private long removedCnt;
    private long expiredRemovedCnt;
    private long virginRemovedCnt;
    private long evictedCount;
    private final HeapCacheListener listener;
    private final boolean noListenerCall;
    private Entry[] evictChunkReuse;
    private int chunkSize;
    private int evictionRunningCount = 0;
    private int noEvictionContentionCount = 0;

    public AbstractEviction(HeapCache _heapCache, HeapCacheListener _listener, long _maxSize) {
        this.heapCache = _heapCache;
        this.listener = _listener;
        this.maxSize = _maxSize;
        if (_maxSize < 1000L) {
            this.chunkSize = 1;
        } else {
            this.chunkSize = 4 + Runtime.getRuntime().availableProcessors() - 1;
            this.chunkSize = Math.min(64, this.chunkSize);
        }
        this.noListenerCall = _listener instanceof HeapCacheListener.NoOperation;
        this.correctedMaxSize = this.maxSize == Long.MAX_VALUE ? 0x3FFFFFFFFFFFFFFFL : this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Entry e) {
        Entry[] _evictionChunk = null;
        Object object = this.lock;
        synchronized (object) {
            if (e.isNotYetInsertedInReplacementList()) {
                this.insertIntoReplacementList(e);
                ++this.newEntryCounter;
                _evictionChunk = this.fillEvictionChunk();
            } else {
                this.removeEventually(e);
            }
        }
        this.evictChunk(_evictionChunk);
    }

    Entry[] reuseChunkArray() {
        Entry[] ea = this.evictChunkReuse;
        if (ea != null) {
            this.evictChunkReuse = null;
        } else {
            ea = new Entry[this.chunkSize];
        }
        return ea;
    }

    private void removeEventually(Entry e) {
        if (!e.isRemovedFromReplacementList()) {
            this.removeFromReplacementList(e);
            long nrt = e.getNextRefreshTime();
            if (nrt == 12L) {
                ++this.expiredRemovedCnt;
            } else if (nrt == 8L) {
                ++this.virginRemovedCnt;
            } else {
                ++this.removedCnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submitWithoutEviction(Entry e) {
        Object object = this.lock;
        synchronized (object) {
            if (e.isNotYetInsertedInReplacementList()) {
                this.insertIntoReplacementList(e);
                ++this.newEntryCounter;
            } else {
                this.removeEventually(e);
            }
            return this.evictionNeeded();
        }
    }

    boolean evictionNeeded() {
        return this.getSize() > this.correctedMaxSize + (long)this.evictionRunningCount + (long)(this.chunkSize / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictEventually() {
        Entry[] _chunk;
        Object object = this.lock;
        synchronized (object) {
            _chunk = this.fillEvictionChunk();
        }
        this.evictChunk(_chunk);
    }

    @Override
    public void evictEventually(int hc) {
        this.evictEventually();
    }

    private Entry[] fillEvictionChunk() {
        if (!this.evictionNeeded()) {
            return null;
        }
        Entry[] _chunk = this.reuseChunkArray();
        return this.refillChunk(_chunk);
    }

    private Entry[] refillChunk(Entry[] _chunk) {
        if (_chunk == null) {
            _chunk = new Entry[this.chunkSize];
        }
        this.evictionRunningCount += _chunk.length;
        for (int i = 0; i < _chunk.length; ++i) {
            _chunk[i] = this.findEvictionCandidate(null);
        }
        return _chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictChunk(Entry[] _chunk) {
        if (_chunk == null) {
            return;
        }
        this.removeFromHash(_chunk);
        Object object = this.lock;
        synchronized (object) {
            this.removeAllFromReplacementListOnEvict(_chunk);
            this.evictionRunningCount -= _chunk.length;
            this.evictChunkReuse = _chunk;
        }
    }

    private void removeFromHash(Entry[] _chunk) {
        if (this.noListenerCall) {
            this.removeFromHashWithoutListener(_chunk);
        } else {
            this.removeFromHashWithListener(_chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromHashWithoutListener(Entry[] _chunk) {
        for (int i = 0; i < _chunk.length; ++i) {
            Entry e;
            Entry entry = e = _chunk[i];
            synchronized (entry) {
                if (e.isGone() || e.isProcessing()) {
                    _chunk[i] = null;
                    continue;
                }
                boolean bl = this.heapCache.removeEntryForEviction(e);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromHashWithListener(Entry[] _chunk) {
        for (int i = 0; i < _chunk.length; ++i) {
            Entry e;
            Entry entry = e = _chunk[i];
            synchronized (entry) {
                if (e.isGone() || e.isProcessing()) {
                    _chunk[i] = null;
                    continue;
                }
                e.startProcessing(16);
            }
            this.listener.onEvictionFromHeap(e);
            entry = e;
            synchronized (entry) {
                e.processingDone();
                boolean bl = this.heapCache.removeEntryForEviction(e);
                continue;
            }
        }
    }

    private void removeAllFromReplacementListOnEvict(Entry[] _chunk) {
        for (int i = 0; i < _chunk.length; ++i) {
            Entry e = _chunk[i];
            if (e == null) continue;
            if (!e.isRemovedFromReplacementList()) {
                this.removeFromReplacementListOnEvict(e);
                ++this.evictedCount;
            }
            _chunk[i] = null;
        }
    }

    @Override
    public long getNewEntryCount() {
        return this.newEntryCounter;
    }

    @Override
    public long getRemovedCount() {
        return this.removedCnt;
    }

    @Override
    public long getVirginRemovedCount() {
        return this.virginRemovedCnt;
    }

    @Override
    public long getExpiredRemovedCount() {
        return this.expiredRemovedCnt;
    }

    @Override
    public long getEvictedCount() {
        return this.evictedCount;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getEvictionRunningCount() {
        return this.evictionRunningCount;
    }

    @Override
    public EvictionMetrics getMetrics() {
        return this;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean drain() {
        return false;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T runLocked(Job<T> j) {
        Object object = this.lock;
        synchronized (object) {
            return j.call();
        }
    }

    protected void removeFromReplacementListOnEvict(Entry e) {
        this.removeFromReplacementList(e);
    }

    protected abstract Entry findEvictionCandidate(Entry var1);

    protected abstract void removeFromReplacementList(Entry var1);

    protected abstract void insertIntoReplacementList(Entry var1);

    @Override
    public String getExtraStatistics() {
        return "impl=" + this.getClass().getSimpleName() + ", chunkSize=" + this.chunkSize;
    }
}

