/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.cache2k.CacheEntry;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.core.CacheInternalError;
import org.cache2k.core.ConcurrentMapWrapper;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.InternalCache;
import org.cache2k.core.StorageMetrics;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.storageApi.StorageAdapter;
import org.cache2k.processor.EntryProcessingException;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;

public abstract class AbstractCache<K, V>
implements InternalCache<K, V> {
    @Override
    public Iterable<K> keys() {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator it = AbstractCache.this.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((CacheEntry)it.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<CacheEntry<K, V>> entries() {
        return new Iterable<CacheEntry<K, V>>(){

            @Override
            public Iterator<CacheEntry<K, V>> iterator() {
                return AbstractCache.this.iterator();
            }
        };
    }

    @Override
    public void removeAllAtOnce(Set<K> _keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll() {
        for (CacheEntry e : this) {
            this.remove(e.getKey());
        }
    }

    @Override
    public void removeAll(Iterable<? extends K> _keys) {
        for (K k : _keys) {
            this.remove(k);
        }
    }

    @Override
    public <X> X requestInterface(Class<X> _type) {
        if (_type.equals(ConcurrentMap.class) || _type.equals(Map.class)) {
            return (X)new ConcurrentMapWrapper(this);
        }
        if (_type.isAssignableFrom(this.getClass())) {
            return (X)this;
        }
        return null;
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMapWrapper(this);
    }

    @Override
    public StorageAdapter getStorage() {
        return null;
    }

    @Override
    public void flush() {
    }

    @Override
    public void purge() {
    }

    @Override
    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> keys, EntryProcessor<K, V, R> entryProcessor) {
        HashMap m = new HashMap();
        for (K k : keys) {
            try {
                final R _result = this.invoke(k, entryProcessor);
                if (_result == null) continue;
                m.put(k, new EntryProcessingResult<R>(){

                    @Override
                    public R getResult() {
                        return _result;
                    }

                    @Override
                    public Throwable getException() {
                        return null;
                    }
                });
            }
            catch (EntryProcessingException t) {
                final Throwable _cause = t.getCause();
                m.put(k, new EntryProcessingResult<R>(){

                    @Override
                    public R getResult() {
                        throw new EntryProcessingException(_cause);
                    }

                    @Override
                    public Throwable getException() {
                        return _cause;
                    }
                });
            }
        }
        return m;
    }

    protected <R> R execute(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        EntryAction<K, V, R> _action = this.createEntryAction(key, e, op);
        return this.execute(op, _action);
    }

    protected abstract <R> EntryAction<K, V, R> createEntryAction(K var1, Entry<K, V> var2, Semantic<K, V, R> var3);

    protected <R> R execute(Semantic<K, V, R> op, EntryAction<K, V, R> _action) {
        op.start(_action);
        if (_action.entryLocked) {
            throw new CacheInternalError("entry not unlocked?");
        }
        RuntimeException t = _action.exceptionToPropagate;
        if (t != null) {
            t.fillInStackTrace();
            throw t;
        }
        return _action.result;
    }

    protected <R> R execute(K key, Semantic<K, V, R> op) {
        return this.execute(key, null, op);
    }

    @Override
    public void prefetch(List<? extends K> keys, int _startIndex, int _endIndexExclusive) {
        this.prefetch((Iterable<? extends K>)keys.subList(_startIndex, _endIndexExclusive));
    }

    @Override
    public void prefetch(Iterable<? extends K> keys) {
        this.prefetchAll(keys);
    }

    @Override
    public StorageMetrics getStorageMetrics() {
        return StorageMetrics.DUMMY;
    }

    @Override
    public boolean contains(K key) {
        return this.containsKey(key);
    }

    @Override
    public void prefetchAll(CacheOperationCompletionListener _listener, K ... _keys) {
        this.prefetchAll(_listener, Arrays.asList(_keys));
    }
}

