/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cache2k.configuration.ConfigurationSection;
import org.cache2k.configuration.SingletonConfigurationSection;

public class ConfigurationSectionContainer
implements Iterable<ConfigurationSection> {
    private List<ConfigurationSection> sections = new ArrayList<ConfigurationSection>();

    public void add(ConfigurationSection section) {
        if (section instanceof SingletonConfigurationSection && this.getSection(section.getClass()) != null) {
            throw new IllegalArgumentException("Section of same type already inserted: " + section.getClass().getName());
        }
        this.sections.add(section);
    }

    public <T> T getSection(Class<T> sectionType) {
        for (ConfigurationSection s : this.sections) {
            if (!sectionType.isAssignableFrom(s.getClass())) continue;
            return (T)s;
        }
        return null;
    }

    @Override
    public Iterator<ConfigurationSection> iterator() {
        return this.sections.iterator();
    }
}

