/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.cache2k.Cache;
import org.cache2k.spi.Cache2kCoreProvider;
import org.cache2k.spi.Cache2kExtensionProvider;
import org.cache2k.spi.Cache2kManagerProvider;
import org.cache2k.spi.SingleProviderResolver;

public abstract class CacheManager
implements Iterable<Cache>,
Closeable {
    protected static final Cache2kManagerProvider provider = SingleProviderResolver.getInstance().resolve(Cache2kCoreProvider.class).getManagerProvider();

    public static String getDefaultName() {
        return provider.getDefaultName();
    }

    public static void setDefaultName(String s) {
        provider.setDefaultName(s);
    }

    public static CacheManager getInstance() {
        return provider.getDefaultManager(null);
    }

    public static CacheManager getInstance(String _name) {
        return provider.getManager(null, _name, null);
    }

    public abstract String getName();

    @Override
    public abstract Iterator<Cache> iterator();

    public abstract <K, V> Cache<K, V> getCache(String var1);

    public abstract void clear();

    public abstract void destroy();

    @Override
    public abstract void close();

    public abstract boolean isDestroyed();

    public abstract boolean isClosed();

    public abstract Properties getProperties();

    public abstract ClassLoader getClassLoader();

    static {
        ServiceLoader<Cache2kExtensionProvider> _loader = ServiceLoader.load(Cache2kExtensionProvider.class, CacheManager.class.getClassLoader());
        for (Cache2kExtensionProvider p : _loader) {
            p.register();
        }
    }
}

