/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cache2k.core.util.LogFactory;

public abstract class Log {
    private static Map<String, Log> loggers = new HashMap<String, Log>();
    private static LogFactory logFactory;

    public static Log getLog(Class<?> _class) {
        return Log.getLog(_class.getName());
    }

    public static synchronized Log getLog(String s) {
        Log l = loggers.get(s);
        if (l != null) {
            return l;
        }
        if (logFactory == null) {
            Log.initializeLogFactory();
        }
        l = logFactory.getLog(s);
        loggers.put(s, l);
        return l;
    }

    private static void log(String s) {
        Log.getLog(Log.class.getName()).debug(s);
    }

    private static void initializeLogFactory() {
        ServiceLoader<LogFactory> loader = ServiceLoader.load(LogFactory.class);
        Iterator<LogFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            LogFactory lf;
            logFactory = lf = iterator.next();
            Log.log("New instance, using: " + logFactory);
            return;
        }
        try {
            final org.apache.commons.logging.LogFactory cl = org.apache.commons.logging.LogFactory.getFactory();
            logFactory = new LogFactory(){

                @Override
                public Log getLog(String s) {
                    return new CommonsLogger(cl.getInstance(s));
                }
            };
            Log.log("New instance, using commons logging");
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logFactory = new LogFactory(){

                @Override
                public Log getLog(String s) {
                    return new JdkLogger(Logger.getLogger(s));
                }
            };
            Log.log("New instance, using JDK logging");
            return;
        }
    }

    public static synchronized void registerSuppression(String s, Log l) {
        loggers.put(s, l);
    }

    public static synchronized void unregisterSuppression(String s) {
        loggers.remove(s);
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public static class SuppressionCounter
    extends Log {
        AtomicInteger debugCount = new AtomicInteger();
        AtomicInteger infoCount = new AtomicInteger();
        AtomicInteger warnCount = new AtomicInteger();

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public void debug(String s) {
            this.debugCount.incrementAndGet();
        }

        @Override
        public void debug(String s, Throwable ex) {
            this.debugCount.incrementAndGet();
        }

        @Override
        public void info(String s, Throwable ex) {
            this.infoCount.incrementAndGet();
        }

        @Override
        public void info(String s) {
            this.infoCount.incrementAndGet();
        }

        @Override
        public void warn(String s) {
            this.warnCount.incrementAndGet();
        }

        @Override
        public void warn(String s, Throwable ex) {
            this.warnCount.incrementAndGet();
        }

        public int getDebugCount() {
            return this.debugCount.get();
        }

        public int getInfoCount() {
            return this.infoCount.get();
        }

        public int getWarnCount() {
            return this.warnCount.get();
        }
    }

    private static class JdkLogger
    extends Log {
        Logger logger;

        private JdkLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        @Override
        public void debug(String s) {
            this.logger.logp(Level.FINE, null, null, s);
        }

        @Override
        public void debug(String s, Throwable ex) {
            this.logger.logp(Level.FINE, s, null, null, ex);
        }

        @Override
        public void info(String s) {
            this.logger.logp(Level.INFO, null, null, s);
        }

        @Override
        public void info(String s, Throwable ex) {
            this.logger.logp(Level.INFO, null, null, s, ex);
        }

        @Override
        public void warn(String s) {
            this.logger.logp(Level.WARNING, null, null, s);
        }

        @Override
        public void warn(String s, Throwable ex) {
            this.logger.logp(Level.WARNING, null, null, s, ex);
        }
    }

    private static class CommonsLogger
    extends Log {
        org.apache.commons.logging.Log cLog;

        private CommonsLogger(org.apache.commons.logging.Log cLog) {
            this.cLog = cLog;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.cLog.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.cLog.isInfoEnabled();
        }

        @Override
        public void debug(String s) {
            this.cLog.debug((Object)s);
        }

        @Override
        public void debug(String s, Throwable ex) {
            this.cLog.debug((Object)s, ex);
        }

        @Override
        public void info(String s, Throwable ex) {
            this.cLog.info((Object)s);
        }

        @Override
        public void info(String s) {
            this.cLog.info((Object)s);
        }

        @Override
        public void warn(String s) {
            this.cLog.warn((Object)s);
        }

        @Override
        public void warn(String s, Throwable ex) {
            this.cLog.warn((Object)s, ex);
        }
    }
}

