/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.threading;

import java.util.concurrent.locks.StampedLock;
import org.cache2k.core.threading.NonOptimisticLock;
import org.cache2k.core.threading.OptimisticLock;
import org.cache2k.core.threading.OptimisticLockStamped;

public class Locks {
    private static Class<? extends OptimisticLock> optimisticLockImplementation;

    public static OptimisticLock newOptimistic() {
        if (optimisticLockImplementation == null) {
            Locks.initializeOptimisticLock();
        }
        try {
            return optimisticLockImplementation.newInstance();
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private static void initializeOptimisticLock() {
        try {
            if (StampedLock.class != null) {
                optimisticLockImplementation = OptimisticLockStamped.class;
            }
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            optimisticLockImplementation = NonOptimisticLock.class;
            return;
        }
    }
}

