/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.operation;

import org.cache2k.CacheEntry;
import org.cache2k.core.Entry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.operation.ResultEntry;

public class ReadOnlyCacheEntry<K, V>
implements ResultEntry<K, V> {
    K key;
    V valueOrException;
    long lastModification;

    public static <K, V> ReadOnlyCacheEntry<K, V> of(CacheEntry<K, V> entry) {
        if (entry instanceof ReadOnlyCacheEntry) {
            return (ReadOnlyCacheEntry)entry;
        }
        return new ReadOnlyCacheEntry<K, V>((Entry)entry);
    }

    public ReadOnlyCacheEntry(Entry<K, V> entry) {
        this.setValues(entry);
    }

    private void setValues(Entry<K, V> entry) {
        this.setValues(entry.getKey(), entry.getValueOrException(), entry.getLastModification());
    }

    public ReadOnlyCacheEntry(K _key, V _valueOrException, long _lastModification) {
        this.setValues(_key, _valueOrException, _lastModification);
    }

    private void setValues(K _key, V _valueOrException, long _lastModification) {
        this.key = _key;
        this.lastModification = _lastModification;
        this.valueOrException = _valueOrException;
    }

    @Override
    public Throwable getException() {
        if (this.valueOrException instanceof ExceptionWrapper) {
            return ((ExceptionWrapper)this.valueOrException).getException();
        }
        return null;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public long getLastModification() {
        return this.lastModification;
    }

    @Override
    public V getValue() {
        if (this.valueOrException instanceof ExceptionWrapper) {
            return null;
        }
        return this.valueOrException;
    }

    @Override
    public V getValueOrException() {
        return this.valueOrException;
    }
}

