/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.operation;

import org.cache2k.CacheEntry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Progress;
import org.cache2k.core.operation.ResultEntry;
import org.cache2k.core.operation.Semantic;
import org.cache2k.processor.EntryProcessingException;
import org.cache2k.processor.EntryProcessor;
import org.cache2k.processor.MutableCacheEntry;
import org.cache2k.processor.RestartException;

public class Operations<K, V> {
    public static final Operations SINGLETON = new Operations();
    static final Semantic PEEK = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(e.getValueOrException());
            }
        }
    };
    static final Semantic GET = new Semantic.MightUpdateExisting(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(e.getValueOrException());
            } else {
                c.wantMutation();
            }
        }

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.load();
        }
    };
    public static final Semantic UNCONDITIONAL_LOAD = new Semantic.Update(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.load();
        }
    };
    public static final Semantic REFRESH = new Semantic.Update(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.refresh();
        }
    };
    static final Semantic GET_ENTRY = new Semantic.MightUpdateExisting(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.entryResult(e);
            } else {
                c.wantMutation();
            }
        }

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.load();
        }

        @Override
        public void loaded(Progress c, ExaminationEntry e) {
            c.entryResult(e);
        }
    };
    static final Semantic PEEK_ENTRY = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.entryResult(e);
            }
        }
    };
    static final Semantic REMOVE = new Semantic.Update(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.remove();
        }
    };
    static final Semantic CONTAINS_REMOVE = new Semantic.UpdateExisting(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            if (c.isPresent()) {
                c.result(true);
                c.remove();
                return;
            }
            c.result(false);
            c.remove();
        }
    };
    static final Semantic CONTAINS = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresent()) {
                c.result(true);
                return;
            }
            c.result(false);
        }
    };
    static final Semantic PEEK_REMOVE = new Semantic.UpdateExisting(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(e.getValueOrException());
            }
            c.remove();
        }
    };

    public Semantic<K, V, V> peek(K key) {
        return PEEK;
    }

    public Semantic<K, V, V> get(K key) {
        return GET;
    }

    public Semantic<K, V, ResultEntry<K, V>> getEntry(K key) {
        return GET_ENTRY;
    }

    public Semantic<K, V, ResultEntry<K, V>> peekEntry(K key) {
        return PEEK_ENTRY;
    }

    public Semantic<K, V, V> remove(K key) {
        return REMOVE;
    }

    public Semantic<K, V, Boolean> containsAndRemove(K key) {
        return CONTAINS_REMOVE;
    }

    public Semantic<K, V, Boolean> contains(K key) {
        return CONTAINS;
    }

    public Semantic<K, V, V> peekAndRemove(K key) {
        return PEEK_REMOVE;
    }

    public Semantic<K, V, V> peekAndReplace(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, V>(){

            @Override
            public void update(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(e.getValueOrException());
                    c.put(value);
                }
            }
        };
    }

    public Semantic<K, V, V> peekAndPut(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, V>(){

            @Override
            public void update(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(e.getValueOrException());
                }
                c.put(value);
            }
        };
    }

    public Semantic<K, V, V> put(K key, final V value) {
        return new Semantic.Update<K, V, V>(){

            @Override
            public void update(Progress<K, V, V> c, ExaminationEntry<K, V> e) {
                c.put(value);
            }
        };
    }

    public Semantic<K, V, Boolean> putIfAbsent(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (!c.isPresentOrMiss()) {
                    c.result(true);
                    c.put(value);
                    return;
                }
                c.result(false);
            }
        };
    }

    public Semantic<K, V, Boolean> replace(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(true);
                    c.put(value);
                    return;
                }
                c.result(false);
            }
        };
    }

    public Semantic<K, V, Boolean> replace(K key, final V value, final V newValue) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss() && (value == null && e.getValueOrException() == null || value.equals(e.getValueOrException()))) {
                    c.result(true);
                    c.put(newValue);
                    return;
                }
                c.result(false);
            }
        };
    }

    public Semantic<K, V, CacheEntry<K, V>> replaceOrGet(K key, final V value, final V newValue, final CacheEntry<K, V> dummyEntry) {
        return new Semantic.UpdateExisting<K, V, CacheEntry<K, V>>(){

            @Override
            public void update(Progress<K, V, CacheEntry<K, V>> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    if (e.getValueOrException().equals(value)) {
                        c.result(null);
                        c.put(newValue);
                        return;
                    }
                    c.entryResult(e);
                    return;
                }
                c.result(dummyEntry);
            }
        };
    }

    public Semantic<K, V, Boolean> remove(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<K, V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss() && (value == null && e.getValueOrException() == null || value.equals(e.getValueOrException()))) {
                    c.result(true);
                    c.remove();
                    return;
                }
                c.result(false);
            }
        };
    }

    public <R> Semantic<K, V, R> invoke(K key, final boolean _readThrough, final EntryProcessor<K, V, R> _processor) {
        return new Semantic.UpdateExisting<K, V, R>(){

            @Override
            public void update(Progress<K, V, R> c, ExaminationEntry<K, V> e) {
                MutableEntryOnProgress _mutableEntryOnProgress = new MutableEntryOnProgress(c, e, _readThrough);
                try {
                    Object _result = _processor.process(_mutableEntryOnProgress);
                    c.result(_result);
                }
                catch (NeedsLoadRestartException rs) {
                    c.loadAndMutation();
                    return;
                }
                catch (Throwable t) {
                    c.failure(new EntryProcessingException(t));
                    return;
                }
                _mutableEntryOnProgress.sendMutationCommandIfNeeded();
            }

            @Override
            public void loaded(Progress<K, V, R> c, ExaminationEntry<K, V> e) {
            }
        };
    }

    public Semantic<K, V, Void> expire(K key, final long t) {
        return new Semantic.UpdateExisting<K, V, Void>(){

            @Override
            public void update(Progress c, ExaminationEntry e) {
                if (t == 0L || t == 1L) {
                    if (c.isPresentOrInRefreshProbation()) {
                        c.expire(t);
                    }
                    return;
                }
                if (c.isPresent()) {
                    c.expire(t);
                }
            }
        };
    }

    public static class NeedsLoadRestartException
    extends RestartException {
    }

    static class MutableEntryOnProgress<K, V>
    implements MutableCacheEntry<K, V> {
        ExaminationEntry<K, V> entry;
        Progress<K, V, ?> progress;
        boolean originalExists = false;
        boolean mutate = false;
        boolean remove = false;
        boolean exists = false;
        V value = null;
        boolean readThrough = false;
        boolean customExpiry = false;
        long expiry;

        public MutableEntryOnProgress(Progress<K, V, ?> _progress, ExaminationEntry<K, V> _entry, boolean _readThrough) {
            this.readThrough = _readThrough;
            this.entry = _entry;
            this.progress = _progress;
            if (_progress.isPresentOrMiss()) {
                this.value = this.entry.getValueOrException();
                this.exists = true;
                this.originalExists = true;
            }
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public void setValue(V v) {
            this.mutate = true;
            this.exists = true;
            this.remove = false;
            this.value = v;
        }

        @Override
        public void setException(Throwable ex) {
            this.mutate = true;
            this.exists = true;
            this.remove = false;
            this.value = new ExceptionWrapper(ex);
        }

        @Override
        public void setExpiry(long t) {
            this.customExpiry = true;
            this.expiry = t;
        }

        @Override
        public void remove() {
            if (this.mutate && !this.originalExists) {
                this.mutate = false;
            } else {
                this.remove = true;
                this.mutate = true;
            }
            this.exists = false;
            this.value = null;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            if (!this.exists && !this.mutate && this.readThrough) {
                throw new NeedsLoadRestartException();
            }
            if (this.value instanceof ExceptionWrapper) {
                throw this.progress.propagateException(this.entry.getKey(), (ExceptionWrapper)this.value);
            }
            return this.value;
        }

        @Override
        public Throwable getException() {
            if (!this.exists && !this.mutate && this.readThrough) {
                throw new NeedsLoadRestartException();
            }
            if (this.value instanceof ExceptionWrapper) {
                return ((ExceptionWrapper)this.value).getException();
            }
            return null;
        }

        @Override
        public long getLastModification() {
            return this.entry.getLastModification();
        }

        public void sendMutationCommandIfNeeded() {
            if (this.mutate) {
                if (this.remove) {
                    this.progress.remove();
                    return;
                }
                if (this.customExpiry) {
                    this.progress.putAndSetExpiry(this.value, this.expiry);
                    return;
                }
                this.progress.put(this.value);
                return;
            }
            if (this.customExpiry) {
                this.progress.expire(this.expiry);
            }
        }
    }
}

