/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.core.Entry;
import org.cache2k.core.Eviction;
import org.cache2k.core.EvictionMetrics;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.threading.Job;

public class SegmentedEviction
implements Eviction,
EvictionMetrics {
    private Eviction[] segments;

    public SegmentedEviction(Eviction[] _segments) {
        this.segments = _segments;
    }

    @Override
    public void submit(Entry e) {
        int hc = e.hashCode;
        Eviction[] sgs = this.segments;
        int _mask = sgs.length - 1;
        int idx = hc & _mask;
        sgs[idx].submit(e);
    }

    @Override
    public boolean submitWithoutEviction(Entry e) {
        int hc = e.hashCode;
        Eviction[] sgs = this.segments;
        int _mask = sgs.length - 1;
        int idx = hc & _mask;
        return sgs[idx].submitWithoutEviction(e);
    }

    @Override
    public void evictEventually(int hc) {
        Eviction[] sgs = this.segments;
        int _mask = sgs.length - 1;
        int idx = hc & _mask;
        sgs[idx].evictEventually(hc);
    }

    @Override
    public void evictEventually() {
        for (Eviction ev : this.segments) {
            ev.evictEventually();
        }
    }

    @Override
    public long removeAll() {
        long _count = 0L;
        for (Eviction ev : this.segments) {
            _count += ev.removeAll();
        }
        return _count;
    }

    @Override
    public void start() {
        for (Eviction ev : this.segments) {
            ev.start();
        }
    }

    @Override
    public void stop() {
        for (Eviction ev : this.segments) {
            ev.stop();
        }
    }

    @Override
    public void close() {
        for (Eviction ev : this.segments) {
            ev.close();
        }
    }

    @Override
    public boolean drain() {
        boolean f = false;
        for (Eviction ev : this.segments) {
            f |= ev.drain();
        }
        return f;
    }

    @Override
    public <T> T runLocked(Job<T> j) {
        return this.runLocked(0, j);
    }

    private <T> T runLocked(final int idx, final Job<T> j) {
        if (idx == this.segments.length) {
            return j.call();
        }
        return this.segments[idx].runLocked(new Job<T>(){

            @Override
            public T call() {
                return SegmentedEviction.this.runLocked(idx + 1, j);
            }
        });
    }

    @Override
    public void checkIntegrity(IntegrityState _integrityState) {
        for (int i = 0; i < this.segments.length; ++i) {
            _integrityState.group("eviction" + i);
            this.segments[i].checkIntegrity(_integrityState);
        }
    }

    @Override
    public EvictionMetrics getMetrics() {
        return this;
    }

    @Override
    public String getExtraStatistics() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.segments.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("eviction").append(i).append('(');
            sb.append(this.segments[i].getMetrics().getExtraStatistics());
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public long getHitCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getHitCount();
        }
        return sum;
    }

    @Override
    public long getNewEntryCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getNewEntryCount();
        }
        return sum;
    }

    @Override
    public long getRemovedCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getRemovedCount();
        }
        return sum;
    }

    @Override
    public long getExpiredRemovedCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getExpiredRemovedCount();
        }
        return sum;
    }

    @Override
    public long getVirginRemovedCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getVirginRemovedCount();
        }
        return sum;
    }

    @Override
    public long getEvictedCount() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getEvictedCount();
        }
        return sum;
    }

    @Override
    public long getSize() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getSize();
        }
        return sum;
    }

    @Override
    public long getMaxSize() {
        long sum = 0L;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getMaxSize();
        }
        return sum;
    }

    @Override
    public int getEvictionRunningCount() {
        int sum = 0;
        for (Eviction ev : this.segments) {
            sum += ev.getMetrics().getEvictionRunningCount();
        }
        return sum;
    }
}

