/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.CacheBuilder;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.configuration.Cache2kConfiguration;
import org.cache2k.core.AbstractEviction;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.ClockProPlusEviction;
import org.cache2k.core.Eviction;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.InternalCache;
import org.cache2k.core.QueuedEviction;
import org.cache2k.core.SegmentedEviction;
import org.cache2k.core.TimingHandler;
import org.cache2k.core.WiredCache;
import org.cache2k.core.event.AsyncDispatcher;
import org.cache2k.core.event.AsyncEvent;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;

public class InternalCache2kBuilder<K, T> {
    static final AtomicLong DERIVED_NAME_COUNTER = new AtomicLong(System.currentTimeMillis() % 1234L);
    static final ThreadPoolExecutor ASYNC_EXECUTOR = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 21L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), HeapCache.TUNABLE.threadFactoryProvider.newThreadFactory("cache2k-async"), new ThreadPoolExecutor.AbortPolicy());
    CacheManager manager;
    Cache2kConfiguration<K, T> config;

    public InternalCache2kBuilder(Cache2kConfiguration<K, T> _config, CacheManager _manager) {
        this.config = _config;
        this.manager = _manager;
    }

    boolean isBuilderClass(String _className) {
        return CacheBuilder.class.getName().equals(_className) || Cache2kBuilder.class.getName().equals(_className);
    }

    String deriveNameFromStackTrace() {
        boolean _builderSeen = false;
        Exception ex = new Exception();
        for (StackTraceElement e : ex.getStackTrace()) {
            if (_builderSeen && !this.isBuilderClass(e.getClassName())) {
                String _methodName = e.getMethodName();
                if (_methodName.equals("<init>")) {
                    _methodName = "INIT";
                }
                if (_methodName.equals("<clinit>")) {
                    _methodName = "CLINIT";
                }
                return "_" + e.getClassName() + "." + _methodName + "-" + e.getLineNumber() + "-" + Long.toString(DERIVED_NAME_COUNTER.incrementAndGet(), 36);
            }
            _builderSeen = this.isBuilderClass(e.getClassName());
        }
        return null;
    }

    Object getConstructorParameter(Class<?> c) {
        if (Cache2kConfiguration.class.isAssignableFrom(c)) {
            return this.config;
        }
        return null;
    }

    Constructor<?> findConstructor(Class<?> c) {
        for (Constructor<?> ctr : c.getConstructors()) {
            Class<?>[] pt = ctr.getParameterTypes();
            if (pt == null || pt.length <= 0 || !Cache2kConfiguration.class.isAssignableFrom(pt[0])) continue;
            return ctr;
        }
        return null;
    }

    void confiugreViaSettersDirect(HeapCache c) {
        if (this.config.getLoader() != null) {
            c.setLoader(this.config.getLoader());
        }
        if (this.config.getAdvancedLoader() != null) {
            c.setAdvancedLoader(this.config.getAdvancedLoader());
        }
        if (this.config.getExceptionPropagator() != null) {
            c.setExceptionPropagator(this.config.getExceptionPropagator());
        }
        if (this.config != null) {
            c.setCacheConfig(this.config);
        }
    }

    void configureViaSetters(Object o) {
        if (o instanceof InternalCache) {
            this.confiugreViaSettersDirect((HeapCache)o);
            return;
        }
        try {
            for (Method m : o.getClass().getMethods()) {
                Object p;
                Class<?>[] ps = m.getParameterTypes();
                if (ps == null || ps.length != 1 || !m.getName().startsWith("set") || (p = this.getConstructorParameter(ps[0])) == null) continue;
                m.invoke(o, p);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to configure cache", ex);
        }
    }

    protected InternalCache<K, T> constructImplementationAndFillParameters(Class<?> cls) {
        if (!InternalCache.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Specified impl not a cache" + cls.getName());
        }
        try {
            InternalCache _cache;
            Constructor<?> ctr = this.findConstructor(cls);
            if (ctr != null) {
                Class<?>[] pt = ctr.getParameterTypes();
                Object[] _args = new Object[pt.length];
                for (int i = 0; i < _args.length; ++i) {
                    _args[i] = this.getConstructorParameter(pt[i]);
                }
                _cache = (InternalCache)ctr.newInstance(_args);
            } else {
                _cache = (InternalCache)cls.newInstance();
            }
            return _cache;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not able to instantiate cache implementation", e);
        }
    }

    public Cache<K, T> build() {
        if (this.config.getValueType() == null) {
            this.config.setValueType(Object.class);
        }
        if (this.config.getKeyType() == null) {
            this.config.setKeyType(Object.class);
        }
        if (this.config.getName() == null) {
            this.config.setName(this.deriveNameFromStackTrace());
            if (this.config.getName() == null) {
                throw new IllegalArgumentException("name missing and automatic generation failed");
            }
        }
        this.checkConfiguration();
        Class<? extends InternalCache> _implClass = HeapCache.TUNABLE.defaultImplementation;
        InternalCache<K, T> _cache = this.constructImplementationAndFillParameters(_implClass);
        HeapCache bc = (HeapCache)_cache;
        CacheManagerImpl cm = (CacheManagerImpl)(this.manager == null ? CacheManager.getInstance() : this.manager);
        bc.setCacheManager(cm);
        this.configureViaSetters(bc);
        boolean _wrap = false;
        if (this.config.hasListeners()) {
            _wrap = true;
        }
        if (this.config.hasAsyncListeners()) {
            _wrap = true;
        }
        if (this.config.getWriter() != null) {
            _wrap = true;
        }
        WiredCache<K, T> wc = null;
        if (_wrap) {
            wc = new WiredCache<K, T>();
            wc.heapCache = bc;
            _cache = wc;
        }
        String _name = cm.newCache(_cache, bc.getName());
        bc.setName(_name);
        if (_wrap) {
            wc.loader = bc.loader;
            if (this.config.getWriter() != null) {
                wc.writer = this.config.getWriter();
            }
            ArrayList<CacheEntryCreatedListener> _syncCreatedListeners = new ArrayList<CacheEntryCreatedListener>();
            ArrayList<CacheEntryUpdatedListener> _syncUpdatedListeners = new ArrayList<CacheEntryUpdatedListener>();
            ArrayList<CacheEntryRemovedListener> _syncRemovedListeners = new ArrayList<CacheEntryRemovedListener>();
            ArrayList _syncExpiredListeners = new ArrayList();
            if (this.config.hasListeners()) {
                for (CacheEntryOperationListener<K, T> el : this.config.getListeners()) {
                    if (el instanceof CacheEntryCreatedListener) {
                        _syncCreatedListeners.add((CacheEntryCreatedListener)el);
                    }
                    if (el instanceof CacheEntryUpdatedListener) {
                        _syncUpdatedListeners.add((CacheEntryUpdatedListener)el);
                    }
                    if (el instanceof CacheEntryRemovedListener) {
                        _syncRemovedListeners.add((CacheEntryRemovedListener)el);
                    }
                    if (!(el instanceof CacheEntryExpiredListener)) continue;
                    this.config.getAsyncListeners().add(el);
                }
            }
            if (this.config.hasAsyncListeners()) {
                AsyncDispatcher _asyncDispatcher = new AsyncDispatcher(wc, ASYNC_EXECUTOR);
                ArrayList<CacheEntryCreatedListener> cll = new ArrayList<CacheEntryCreatedListener>();
                ArrayList<CacheEntryUpdatedListener> ull = new ArrayList<CacheEntryUpdatedListener>();
                ArrayList<CacheEntryRemovedListener> rll = new ArrayList<CacheEntryRemovedListener>();
                ArrayList<CacheEntryExpiredListener> ell = new ArrayList<CacheEntryExpiredListener>();
                for (CacheEntryOperationListener<K, T> cacheEntryOperationListener : this.config.getAsyncListeners()) {
                    if (cacheEntryOperationListener instanceof CacheEntryCreatedListener) {
                        cll.add((CacheEntryCreatedListener)cacheEntryOperationListener);
                    }
                    if (cacheEntryOperationListener instanceof CacheEntryUpdatedListener) {
                        ull.add((CacheEntryUpdatedListener)cacheEntryOperationListener);
                    }
                    if (cacheEntryOperationListener instanceof CacheEntryRemovedListener) {
                        rll.add((CacheEntryRemovedListener)cacheEntryOperationListener);
                    }
                    if (!(cacheEntryOperationListener instanceof CacheEntryExpiredListener)) continue;
                    ell.add((CacheEntryExpiredListener)cacheEntryOperationListener);
                }
                for (CacheEntryCreatedListener cacheEntryCreatedListener : cll) {
                    _syncCreatedListeners.add(new AsyncCreatedListener(_asyncDispatcher, cacheEntryCreatedListener));
                }
                for (CacheEntryUpdatedListener cacheEntryUpdatedListener : ull) {
                    _syncUpdatedListeners.add(new AsyncUpdatedListener(_asyncDispatcher, cacheEntryUpdatedListener));
                }
                for (CacheEntryRemovedListener cacheEntryRemovedListener : rll) {
                    _syncRemovedListeners.add(new AsyncRemovedListener(_asyncDispatcher, cacheEntryRemovedListener));
                }
                for (CacheEntryExpiredListener cacheEntryExpiredListener : ell) {
                    _syncExpiredListeners.add(new AsyncExpiredListener(_asyncDispatcher, cacheEntryExpiredListener));
                }
            }
            if (!_syncCreatedListeners.isEmpty()) {
                wc.syncEntryCreatedListeners = _syncCreatedListeners.toArray(new CacheEntryCreatedListener[_syncCreatedListeners.size()]);
            }
            if (!_syncUpdatedListeners.isEmpty()) {
                wc.syncEntryUpdatedListeners = _syncUpdatedListeners.toArray(new CacheEntryUpdatedListener[_syncUpdatedListeners.size()]);
            }
            if (!_syncRemovedListeners.isEmpty()) {
                wc.syncEntryRemovedListeners = _syncRemovedListeners.toArray(new CacheEntryRemovedListener[_syncRemovedListeners.size()]);
            }
            if (!_syncExpiredListeners.isEmpty()) {
                wc.syncEntryExpiredListeners = _syncExpiredListeners.toArray(new CacheEntryExpiredListener[_syncExpiredListeners.size()]);
            }
            bc.eviction = this.constructEviction(bc, wc, this.config);
            TimingHandler<K, T> rh = TimingHandler.of(this.config);
            bc.setTiming(rh);
            wc.init();
        } else {
            TimingHandler<K, T> rh = TimingHandler.of(this.config);
            bc.setTiming(rh);
            bc.eviction = this.constructEviction(bc, new HeapCacheListener.NoOperation(), this.config);
            bc.init();
        }
        cm.sendCreatedEvent(_cache);
        return _cache;
    }

    Eviction constructEviction(HeapCache hc, HeapCacheListener l, Cache2kConfiguration config) {
        boolean _queue = false;
        int _segmentCount = 1;
        if (Runtime.getRuntime().availableProcessors() > 1) {
            _segmentCount = 2;
        }
        if (config.getEvictionSegmentCount() > 0) {
            _segmentCount = config.getEvictionSegmentCount();
        }
        if (config.getEntryCapacity() < 1000L) {
            _segmentCount = 1;
        }
        int _maxSegments = Runtime.getRuntime().availableProcessors() * 2;
        _segmentCount = Math.min(_segmentCount, _maxSegments);
        Eviction[] _segments = new Eviction[_segmentCount];
        long _maxSize = config.getEntryCapacity() / (long)_segmentCount;
        if (config.getEntryCapacity() % (long)_segmentCount > 0L) {
            ++_maxSize;
        }
        for (int i = 0; i < _segments.length; ++i) {
            Eviction ev = new ClockProPlusEviction(hc, l, _maxSize);
            if (_queue) {
                ev = new QueuedEviction((AbstractEviction)ev);
            }
            _segments[i] = ev;
        }
        if (_segmentCount == 1) {
            return _segments[0];
        }
        return new SegmentedEviction(_segments);
    }

    void checkConfiguration() {
    }

    static class AsyncExpiredListener<K, V>
    implements CacheEntryExpiredListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryExpiredListener<K, V> listener;

        public AsyncExpiredListener(AsyncDispatcher<K> _dispatcher, CacheEntryExpiredListener<K, V> _listener) {
            this.dispatcher = _dispatcher;
            this.listener = _listener;
        }

        @Override
        public void onEntryExpired(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncExpiredListener.this.listener.onEntryExpired(c, e);
                }
            });
        }
    }

    static class AsyncRemovedListener<K, V>
    implements CacheEntryRemovedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryRemovedListener<K, V> listener;

        public AsyncRemovedListener(AsyncDispatcher<K> _dispatcher, CacheEntryRemovedListener<K, V> _listener) {
            this.dispatcher = _dispatcher;
            this.listener = _listener;
        }

        @Override
        public void onEntryRemoved(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncRemovedListener.this.listener.onEntryRemoved(c, e);
                }
            });
        }
    }

    static class AsyncUpdatedListener<K, V>
    implements CacheEntryUpdatedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryUpdatedListener<K, V> listener;

        public AsyncUpdatedListener(AsyncDispatcher<K> _dispatcher, CacheEntryUpdatedListener<K, V> _listener) {
            this.dispatcher = _dispatcher;
            this.listener = _listener;
        }

        @Override
        public void onEntryUpdated(final Cache<K, V> cache, final CacheEntry<K, V> currentEntry, final CacheEntry<K, V> entryWithNewData) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return currentEntry.getKey();
                }

                @Override
                public void execute() {
                    AsyncUpdatedListener.this.listener.onEntryUpdated(cache, currentEntry, entryWithNewData);
                }
            });
        }
    }

    static class AsyncCreatedListener<K, V>
    implements CacheEntryCreatedListener<K, V> {
        AsyncDispatcher<K> dispatcher;
        CacheEntryCreatedListener<K, V> listener;

        public AsyncCreatedListener(AsyncDispatcher<K> _dispatcher, CacheEntryCreatedListener<K, V> _listener) {
            this.dispatcher = _dispatcher;
            this.listener = _listener;
        }

        @Override
        public void onEntryCreated(final Cache<K, V> c, final CacheEntry<K, V> e) {
            this.dispatcher.queue(new AsyncEvent<K>(){

                @Override
                public K getKey() {
                    return e.getKey();
                }

                @Override
                public void execute() {
                    AsyncCreatedListener.this.listener.onEntryCreated(c, e);
                }
            });
        }
    }
}

