/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.CacheEntry;
import org.cache2k.CustomizationException;
import org.cache2k.core.CacheLockSpinsExceededError;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.Entry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.ExpiryPolicyException;
import org.cache2k.core.HeapCache;
import org.cache2k.core.InternalCache;
import org.cache2k.core.ResiliencePolicyException;
import org.cache2k.core.StorageMetrics;
import org.cache2k.core.TimingHandler;
import org.cache2k.core.experimentalApi.AsyncCacheLoader;
import org.cache2k.core.experimentalApi.AsyncCacheWriter;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Progress;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.storageApi.StorageAdapter;
import org.cache2k.core.storageApi.StorageCallback;
import org.cache2k.core.storageApi.StorageEntry;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.CacheWriterException;
import org.cache2k.integration.ExceptionInformation;

public abstract class EntryAction<K, V, R>
implements StorageCallback,
AsyncCacheLoader.Callback<V>,
AsyncCacheWriter.Callback,
Progress<K, V, R> {
    static final Entry NON_FRESH_DUMMY = new Entry();
    InternalCache<K, V> userCache;
    HeapCache<K, V> heapCache;
    K key;
    Semantic<K, V, R> operation;
    Entry<K, V> entry;
    V newValueOrException;
    V oldValueOrException;
    long previousModificationTime;
    R result;
    long lastModificationTime;
    long loadStartedTime;
    long loadCompletedTime;
    RuntimeException exceptionToPropagate;
    boolean remove;
    boolean expiredImmediately;
    long expiry = 0L;
    boolean entryLocked = false;
    boolean heapDataValid = false;
    boolean storageDataValid = false;
    boolean needsFinish = true;
    boolean storageRead = false;
    boolean storageMiss = false;
    boolean heapMiss = false;
    boolean wantData = false;
    boolean countMiss = false;
    boolean heapHit = false;
    boolean doNotCountAccess = false;
    boolean loadAndMutate = false;
    boolean load = false;
    boolean refresh = false;
    boolean successfulLoad = false;
    boolean suppressException = false;

    public EntryAction(HeapCache<K, V> _heapCache, InternalCache<K, V> _userCache, Semantic<K, V, R> op, K k, Entry<K, V> e) {
        this.heapCache = _heapCache;
        this.userCache = _userCache;
        this.operation = op;
        this.key = k;
        this.entry = e != null ? e : NON_FRESH_DUMMY;
    }

    protected AdvancedCacheLoader<K, V> loader() {
        return this.heapCache.loader;
    }

    protected CommonMetrics.Updater metrics() {
        return this.heapCache.metrics;
    }

    protected StorageAdapter storage() {
        return null;
    }

    protected CacheWriter<K, V> writer() {
        return null;
    }

    protected boolean mightHaveListeners() {
        return false;
    }

    protected CacheEntryCreatedListener<K, V>[] entryCreatedListeners() {
        return null;
    }

    protected CacheEntryUpdatedListener<K, V>[] entryUpdatedListeners() {
        return null;
    }

    protected CacheEntryRemovedListener<K, V>[] entryRemovedListeners() {
        return null;
    }

    protected CacheEntryExpiredListener<K, V>[] entryExpiredListeners() {
        return null;
    }

    protected StorageMetrics.Updater storageMetrics() {
        return null;
    }

    protected abstract TimingHandler<K, V> timing();

    @Override
    public boolean isPresent() {
        this.doNotCountAccess = true;
        return this.successfulLoad || this.entry.hasFreshData();
    }

    @Override
    public boolean isPresentOrInRefreshProbation() {
        this.doNotCountAccess = true;
        return this.successfulLoad || this.entry.getNextRefreshTime() == 6L || this.entry.hasFreshData();
    }

    @Override
    public boolean isPresentOrMiss() {
        if (this.successfulLoad || this.entry.hasFreshData()) {
            return true;
        }
        this.countMiss = true;
        return false;
    }

    @Override
    public void wantData() {
        this.wantData = true;
        if (this.storage() == null) {
            this.retrieveDataFromHeap();
            return;
        }
        this.lockEntryForStorageRead();
    }

    public void retrieveDataFromHeap() {
        Entry<K, V> e = this.entry;
        if (e == NON_FRESH_DUMMY && (e = this.heapCache.lookupEntry(this.key)) == null) {
            this.heapMiss();
            return;
        }
        this.heapHit(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockEntryForStorageRead() {
        int _spinCount = HeapCache.TUNABLE.maximumEntryLockSpins;
        Entry<K, V> e = this.entry;
        boolean _needStorageRead = false;
        if (e == NON_FRESH_DUMMY) {
            e = this.heapCache.lookupOrNewEntry(this.key);
        }
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) {
                    if (e.isVirgin()) {
                        _needStorageRead = true;
                        this.storageRead = true;
                        e.startProcessing(1);
                        this.entryLocked = true;
                        this.heapDataValid = e.isDataValid();
                    }
                    break;
                }
            }
            e = this.heapCache.lookupOrNewEntry(this.key);
        }
        if (_needStorageRead) {
            this.entry = e;
            this.storageRead();
            return;
        }
        this.heapHit(e);
    }

    public void storageRead() {
        StorageEntry se;
        try {
            se = this.storage().get(this.entry.key);
        }
        catch (Throwable ex) {
            this.onReadFailure(ex);
            return;
        }
        this.onReadSuccess(se);
    }

    @Override
    public void onReadFailure(Throwable t) {
        this.examinationAbort(new StorageReadException(t));
    }

    @Override
    public void onReadSuccess(StorageEntry se) {
        if (se == null) {
            this.storageReadMiss();
            return;
        }
        this.storageReadHit(se);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storageReadMiss() {
        Entry<K, V> e;
        Entry<K, V> entry = e = this.entry;
        synchronized (entry) {
            e.setNextRefreshTime(1L);
            this.storageMiss = true;
        }
        this.examine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storageReadHit(StorageEntry se) {
        Entry<K, V> e;
        Entry<K, V> entry = e = this.entry;
        synchronized (entry) {
            boolean _expired;
            e.setLastModificationFromStorage(se.getCreatedOrUpdated());
            long now = System.currentTimeMillis();
            Object v = se.getValueOrException();
            e.setValueOrException(v);
            long _expiryTimeFromStorage = se.getValueExpiryTime();
            boolean bl = _expired = _expiryTimeFromStorage != 0L && _expiryTimeFromStorage <= now;
            if (!_expired) {
                long _nextRefreshTime;
                this.expiry = _nextRefreshTime = this.timing().calculateNextRefreshTime(e, v, now);
                if (_nextRefreshTime == Long.MAX_VALUE) {
                    e.setNextRefreshTime(16L);
                    this.storageDataValid = true;
                } else if (_nextRefreshTime == 0L) {
                    e.setNextRefreshTime(1L);
                } else {
                    if (_nextRefreshTime < 0L) {
                        e.setNextRefreshTime(_nextRefreshTime);
                        this.storageDataValid = true;
                    }
                    if (_nextRefreshTime <= now) {
                        e.setNextRefreshTime(1L);
                    } else {
                        e.setNextRefreshTime(-_nextRefreshTime);
                        this.storageDataValid = true;
                    }
                }
            } else {
                e.setNextRefreshTime(1L);
            }
            e.nextProcessingStep(2);
        }
        this.examine();
    }

    public void heapMiss() {
        this.heapMiss = true;
        this.examine();
    }

    public void heapHit(Entry<K, V> e) {
        this.heapHit = true;
        this.entry = e;
        this.examine();
    }

    public void examine() {
        this.operation.examine(this, this.entry);
        if (this.needsFinish) {
            this.finish();
        }
    }

    @Override
    public void wantMutation() {
        if (!this.entryLocked && this.wantData) {
            this.lockFor(3);
            this.countMiss = false;
            this.operation.examine(this, this.entry);
            if (this.needsFinish) {
                this.finish();
            }
            return;
        }
        this.operation.update(this, this.entry);
        if (this.needsFinish) {
            this.finish();
        }
    }

    public void finish() {
        this.needsFinish = false;
        this.noMutationRequested();
    }

    @Override
    public void loadAndMutation() {
        this.loadAndMutate = true;
        this.load();
    }

    @Override
    public void refresh() {
        this.refresh = true;
        this.load();
    }

    @Override
    public void load() {
        V v;
        long nrt;
        AdvancedCacheLoader<Object, V> _loader = this.loader();
        if (_loader == null) {
            this.mutationAbort(null);
            return;
        }
        if (!this.entryLocked) {
            this.lockFor(4);
        } else {
            this.entry.nextProcessingStep(4);
        }
        this.needsFinish = false;
        this.load = true;
        Entry<K, V> e = this.entry;
        this.lastModificationTime = this.loadStartedTime = System.currentTimeMillis();
        long t0 = this.loadStartedTime;
        if (e.getNextRefreshTime() == 6L && (nrt = e.getRefreshProbationNextRefreshTime()) > t0) {
            this.reviveRefreshedEntry(nrt);
            return;
        }
        try {
            v = e.isVirgin() ? _loader.load(e.key, t0, null) : _loader.load(e.key, t0, e);
        }
        catch (Throwable _ouch) {
            this.onLoadFailure(_ouch);
            return;
        }
        this.onLoadSuccess(v);
    }

    public void reviveRefreshedEntry(long nrt) {
        this.metrics().refreshHit();
        Entry<K, V> e = this.entry;
        this.newValueOrException = e.getValue();
        this.lastModificationTime = e.getLastModification();
        this.expiry = nrt;
        this.expiryCalculated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockFor(int ps) {
        if (this.entryLocked) {
            this.entry.nextProcessingStep(ps);
            return;
        }
        Entry<K, V> e = this.entry;
        if (e == NON_FRESH_DUMMY) {
            e = this.heapCache.lookupOrNewEntry(this.key);
        }
        int _spinCount = HeapCache.TUNABLE.maximumEntryLockSpins;
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) {
                    e.startProcessing(ps);
                    this.entryLocked = true;
                    this.heapDataValid = e.isDataValid();
                    this.heapHit = !e.isVirgin();
                    this.entry = e;
                    return;
                }
            }
            e = this.heapCache.lookupOrNewEntry(this.key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockForNoHit(int ps) {
        if (this.entryLocked) {
            this.entry.nextProcessingStep(ps);
            return;
        }
        Entry<K, V> e = this.entry;
        if (e == NON_FRESH_DUMMY) {
            e = this.heapCache.lookupOrNewEntryNoHitRecord(this.key);
        }
        int _spinCount = HeapCache.TUNABLE.maximumEntryLockSpins;
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) {
                    e.startProcessing(ps);
                    this.entryLocked = true;
                    this.heapDataValid = e.isDataValid();
                    this.heapHit = !e.isVirgin();
                    this.entry = e;
                    return;
                }
            }
            e = this.heapCache.lookupOrNewEntryNoHitRecord(this.key);
        }
    }

    @Override
    public void onLoadSuccess(V value) {
        this.newValueOrException = value;
        this.loadCompleted();
    }

    @Override
    public void onLoadFailure(Throwable t) {
        this.newValueOrException = new ExceptionWrapper<K>(this.key, t, this.loadStartedTime, this.entry);
        this.loadCompleted();
    }

    public void loadCompleted() {
        this.entry.nextProcessingStep(5);
        this.loadCompletedTime = System.currentTimeMillis();
        long _delta = this.loadCompletedTime - this.loadStartedTime;
        if (this.refresh) {
            this.metrics().refresh(_delta);
        } else if (this.entry.isVirgin() || !this.storageRead) {
            this.metrics().load(_delta);
        } else {
            this.metrics().reload(_delta);
        }
        this.mutationCalculateExpiry();
    }

    @Override
    public void result(R r) {
        this.result = r;
    }

    @Override
    public void entryResult(ExaminationEntry e) {
        this.result = this.heapCache.returnEntry(e);
    }

    @Override
    public RuntimeException propagateException(K key, ExceptionInformation inf) {
        return this.heapCache.exceptionPropagator.propagateException(key, inf);
    }

    @Override
    public void put(V value) {
        this.lockFor(3);
        this.needsFinish = false;
        this.newValueOrException = value;
        this.lastModificationTime = System.currentTimeMillis();
        this.mutationCalculateExpiry();
    }

    @Override
    public void remove() {
        this.lockForNoHit(3);
        this.needsFinish = false;
        this.remove = true;
        this.lastModificationTime = System.currentTimeMillis();
        this.mutationMayCallWriter();
    }

    @Override
    public void expire(long t) {
        this.lockForNoHit(3);
        this.needsFinish = false;
        this.newValueOrException = this.entry.getValue();
        this.lastModificationTime = this.entry.getLastModification();
        this.expiry = t;
        if (this.newValueOrException instanceof ExceptionWrapper) {
            this.setUntil((ExceptionWrapper)ExceptionWrapper.class.cast(this.newValueOrException));
        }
        this.checkKeepOrRemove();
    }

    @Override
    public void putAndSetExpiry(V value, long t) {
        this.lockFor(3);
        this.needsFinish = false;
        this.newValueOrException = value;
        this.lastModificationTime = System.currentTimeMillis();
        this.expiry = t;
        if (this.newValueOrException instanceof ExceptionWrapper) {
            this.setUntil((ExceptionWrapper)ExceptionWrapper.class.cast(this.newValueOrException));
        }
        this.expiryCalculated();
    }

    public void mutationCalculateExpiry() {
        this.entry.nextProcessingStep(8);
        if (this.newValueOrException instanceof ExceptionWrapper) {
            try {
                this.expiry = 0L;
                ExceptionWrapper ew = (ExceptionWrapper)this.newValueOrException;
                if ((this.entry.isDataValid() || this.entry.isExpired()) && this.entry.getException() == null) {
                    this.expiry = this.timing().suppressExceptionUntil(this.entry, ew);
                }
                if (this.expiry > this.loadStartedTime) {
                    this.suppressException = true;
                    this.newValueOrException = this.entry.getValue();
                    this.lastModificationTime = this.entry.getLastModification();
                    this.metrics().suppressedException();
                    this.entry.setSuppressedLoadExceptionInformation(ew);
                } else {
                    if (this.load) {
                        this.metrics().loadException();
                    }
                    this.expiry = this.timing().cacheExceptionUntil(this.entry, ew);
                }
                this.setUntil(ew);
            }
            catch (Throwable ex) {
                if (this.load) {
                    this.resiliencePolicyException(new ResiliencePolicyException(ex));
                    return;
                }
                this.expiryCalculationException(ex);
                return;
            }
        }
        try {
            this.expiry = this.timing().calculateNextRefreshTime(this.entry, this.newValueOrException, this.lastModificationTime);
            if (this.newValueOrException == null && this.heapCache.hasRejectNullValues() && this.expiry != 0L) {
                RuntimeException _ouch = this.heapCache.returnNullValueDetectedException();
                if (this.load) {
                    this.decideForLoaderExceptionAfterExpiryCalculation(new ResiliencePolicyException(_ouch));
                    return;
                }
                this.mutationAbort(_ouch);
                return;
            }
            this.entry.resetSuppressedLoadExceptionInformation();
        }
        catch (Throwable ex) {
            if (this.load) {
                this.decideForLoaderExceptionAfterExpiryCalculation(new ExpiryPolicyException(ex));
                return;
            }
            this.expiryCalculationException(ex);
            return;
        }
        this.expiryCalculated();
    }

    private void decideForLoaderExceptionAfterExpiryCalculation(RuntimeException _ouch) {
        this.newValueOrException = new ExceptionWrapper<K>(this.key, (Throwable)_ouch, this.loadStartedTime, this.entry);
        this.expiry = 0L;
        this.mutationCalculateExpiry();
    }

    private void resiliencePolicyException(RuntimeException _ouch) {
        this.newValueOrException = new ExceptionWrapper<K>(this.key, (Throwable)_ouch, this.loadStartedTime, this.entry);
        this.expiry = 0L;
        this.expiryCalculated();
    }

    private void setUntil(ExceptionWrapper _ew) {
        if (this.expiry < 0L) {
            _ew.until = -this.expiry;
        } else if (this.expiry >= 32L) {
            _ew.until = this.expiry;
        }
    }

    public void expiryCalculationException(Throwable t) {
        this.mutationAbort(new ExpiryPolicyException(t));
    }

    public void expiryCalculated() {
        this.entry.nextProcessingStep(9);
        if (this.load) {
            if (this.loadAndMutate) {
                this.loadAndExpiryCalculatedMutateAgain();
                return;
            }
            this.checkKeepOrRemove();
            return;
        }
        if (this.expiry > 0L || this.expiry == -1L) {
            if (this.entry.isVirgin()) {
                this.metrics().putNewEntry();
            } else if (!this.wantData) {
                this.metrics().putNoReadHit();
            } else {
                this.metrics().putHit();
            }
        }
        this.mutationMayCallWriter();
    }

    public void loadAndExpiryCalculatedMutateAgain() {
        this.loadAndMutate = false;
        this.load = false;
        this.successfulLoad = true;
        this.needsFinish = true;
        ExaminationEntry ee = new ExaminationEntry(){

            public Object getKey() {
                return EntryAction.this.entry.getKey();
            }

            public Object getValueOrException() {
                return EntryAction.this.newValueOrException;
            }

            @Override
            public long getLastModification() {
                return EntryAction.this.lastModificationTime;
            }
        };
        this.operation.update(this, ee);
        if (this.needsFinish) {
            this.updateDidNotTriggerDifferentMutationStoreLoadedValue();
        }
    }

    public void updateDidNotTriggerDifferentMutationStoreLoadedValue() {
        this.checkKeepOrRemove();
    }

    public void mutationMayCallWriter() {
        CacheWriter<K, V> _writer = this.writer();
        if (_writer == null) {
            this.skipWritingNoWriter();
            return;
        }
        if (this.remove) {
            try {
                this.entry.nextProcessingStep(10);
                _writer.delete(this.key);
            }
            catch (Throwable t) {
                this.onWriteFailure(t);
                return;
            }
            this.onWriteSuccess();
            return;
        }
        if (this.newValueOrException instanceof ExceptionWrapper) {
            this.skipWritingForException();
            return;
        }
        this.entry.nextProcessingStep(10);
        try {
            _writer.write(this.key, this.newValueOrException);
        }
        catch (Throwable t) {
            this.onWriteFailure(t);
            return;
        }
        this.onWriteSuccess();
    }

    @Override
    public void onWriteSuccess() {
        this.entry.nextProcessingStep(11);
        this.checkKeepOrRemove();
    }

    @Override
    public void onWriteFailure(Throwable t) {
        this.mutationAbort(new CacheWriterException(t));
    }

    public void skipWritingForException() {
        this.checkKeepOrRemove();
    }

    public void skipWritingNoWriter() {
        this.checkKeepOrRemove();
    }

    public void checkKeepOrRemove() {
        boolean _hasKeepAfterExpired = this.heapCache.hasKeepAfterExpired();
        if (this.expiry != 0L || this.remove || _hasKeepAfterExpired) {
            this.mutationUpdateHeap();
            return;
        }
        if (_hasKeepAfterExpired) {
            this.expiredImmediatelyKeepData();
            return;
        }
        this.expiredImmediatelyAndRemove();
    }

    public void expiredImmediatelyKeepData() {
        this.expiredImmediately = true;
        this.mutationUpdateHeap();
    }

    public void expiredImmediatelyAndRemove() {
        this.remove = true;
        this.expiredImmediately = true;
        this.mutationUpdateHeap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationUpdateHeap() {
        Entry<K, V> entry = this.entry;
        synchronized (entry) {
            this.entry.setLastModification(this.lastModificationTime);
            if (this.remove) {
                if (this.expiredImmediately) {
                    this.entry.setNextRefreshTime(4L);
                    this.entry.setValueOrException((Object)this.newValueOrException);
                } else {
                    this.entry.setNextRefreshTime(2L);
                }
            } else {
                this.oldValueOrException = this.entry.getValueOrException();
                this.previousModificationTime = this.entry.getLastModification();
                this.entry.setValueOrException((Object)this.newValueOrException);
            }
        }
        this.mutationMayStore();
    }

    public void mutationMayStore() {
        if (this.storage() == null) {
            this.skipStore();
            return;
        }
        this.mutationStore();
    }

    public void mutationStore() {
        this.entry.nextProcessingStep(12);
        boolean _entryRemoved = false;
        try {
            if (this.remove) {
                _entryRemoved = this.storage().remove(this.key);
            } else {
                this.storage().put(this.entry, this.expiry);
            }
        }
        catch (Throwable t) {
            this.onStoreFailure(t);
            return;
        }
        this.onStoreSuccess(_entryRemoved);
    }

    @Override
    public void onStoreSuccess(boolean _entryRemoved) {
        this.entry.nextProcessingStep(13);
        this.callListeners();
    }

    @Override
    public void onStoreFailure(Throwable t) {
        this.mutationAbort(new StorageWriteException(t));
    }

    public void skipStore() {
        this.callListeners();
    }

    public void callListeners() {
        if (!this.mightHaveListeners()) {
            this.mutationReleaseLockAndStartTimer();
            return;
        }
        CacheEntry<K, V> _currentEntry = this.heapCache.returnEntry(this.entry);
        if (this.expiredImmediately) {
            if ((this.storageDataValid || this.heapDataValid) && this.entryExpiredListeners() != null) {
                for (CacheEntryExpiredListener<K, V> l : this.entryExpiredListeners()) {
                    try {
                        l.onEntryExpired(this.userCache, _currentEntry);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new ListenerException(t);
                    }
                }
            }
        } else if (this.remove) {
            if ((this.storageDataValid || this.heapDataValid) && this.entryRemovedListeners() != null) {
                for (CacheEntryRemovedListener<K, V> l : this.entryRemovedListeners()) {
                    try {
                        l.onEntryRemoved(this.userCache, _currentEntry);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new ListenerException(t);
                    }
                }
            }
        } else if (this.storageDataValid || this.heapDataValid) {
            if (this.entryUpdatedListeners() != null) {
                CacheEntry<K, V> _previousEntry = this.heapCache.returnCacheEntry(this.entry.getKey(), this.oldValueOrException, this.previousModificationTime);
                for (CacheEntryUpdatedListener<K, V> l : this.entryUpdatedListeners()) {
                    try {
                        l.onEntryUpdated(this.userCache, _previousEntry, _currentEntry);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new ListenerException(t);
                    }
                }
            }
        } else if (this.entryCreatedListeners() != null) {
            for (CacheEntryCreatedListener<K, V> l : this.entryCreatedListeners()) {
                try {
                    l.onEntryCreated(this.userCache, _currentEntry);
                }
                catch (Throwable t) {
                    this.exceptionToPropagate = new ListenerException(t);
                }
            }
        }
        this.mutationReleaseLockAndStartTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationReleaseLockAndStartTimer() {
        if (!(!this.load || this.remove && this.entry.getValueOrException() == null && this.heapCache.hasRejectNullValues())) {
            this.operation.loaded(this, this.entry);
        }
        Entry<K, V> entry = this.entry;
        synchronized (entry) {
            this.entry.processingDone();
            if (this.refresh) {
                this.heapCache.startRefreshProbationTimer(this.entry, this.expiry);
                this.entryLocked = false;
                this.updateMutationStatistics();
                this.mutationDone();
                return;
            }
            this.entryLocked = false;
            if (this.remove) {
                this.heapCache.removeEntry(this.entry);
            } else {
                this.entry.setNextRefreshTime(this.timing().stopStartTimer(this.expiry, this.entry));
                if (this.entry.isExpired()) {
                    this.entry.setNextRefreshTime(32L);
                    this.userCache.expireOrScheduleFinalExpireEvent(this.entry);
                }
            }
        }
        this.updateMutationStatistics();
        this.mutationDone();
    }

    public void updateMutationStatistics() {
        if (this.loadCompletedTime > 0L) {
            if (this.storageRead && this.storageMiss) {
                this.storageMetrics().readMiss();
            }
        } else {
            this.updateOnlyReadStatistics();
            if (this.remove) {
                if (this.heapDataValid) {
                    this.metrics().remove();
                } else if (this.heapHit) {
                    // empty if block
                }
            }
        }
    }

    public void updateOnlyReadStatistics() {
        if (this.countMiss) {
            if (this.heapHit) {
                this.metrics().peekHitNotFresh();
            }
            if (this.heapMiss) {
                this.metrics().peekMiss();
            }
            if (this.storageRead && this.storageMiss) {
                this.storageMetrics().readNonFresh();
                this.metrics().peekHitNotFresh();
            }
        } else if (this.doNotCountAccess && this.heapHit) {
            this.metrics().containsButHit();
        }
        if (this.storageRead && !this.storageMiss) {
            this.storageMetrics().readHit();
        }
    }

    @Override
    public void failure(RuntimeException t) {
        this.mutationAbort(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void examinationAbort(CustomizationException t) {
        this.exceptionToPropagate = t;
        if (this.entryLocked) {
            Entry<K, V> entry = this.entry;
            synchronized (entry) {
                this.entry.processingDone();
                this.entryLocked = false;
            }
        }
        this.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationAbort(RuntimeException t) {
        this.exceptionToPropagate = t;
        Entry<K, V> entry = this.entry;
        synchronized (entry) {
            this.entry.processingDone();
            this.entryLocked = false;
            this.needsFinish = false;
        }
        this.ready();
    }

    public void mutationDone() {
        this.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noMutationRequested() {
        Object object;
        if (this.entryLocked) {
            object = this.entry;
            synchronized (object) {
                this.entry.processingDone();
                if (this.entry.isVirgin()) {
                    this.heapCache.removeEntry(this.entry);
                }
            }
            this.entryLocked = false;
        }
        object = this.heapCache.lock;
        synchronized (object) {
            this.updateOnlyReadStatistics();
        }
        this.ready();
    }

    public void ready() {
    }

    public static class ListenerException
    extends CustomizationException {
        public ListenerException(Throwable cause) {
            super(cause);
        }
    }

    public static class ProcessingFailureException
    extends CustomizationException {
        public ProcessingFailureException(Throwable cause) {
            super(cause);
        }
    }

    public static class StorageWriteException
    extends CustomizationException {
        public StorageWriteException(Throwable cause) {
            super(cause);
        }
    }

    public static class StorageReadException
    extends CustomizationException {
        public StorageReadException(Throwable cause) {
            super(cause);
        }
    }
}

