/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.lang.reflect.Field;
import java.util.TimerTask;
import org.cache2k.CacheEntry;
import org.cache2k.core.CompactEntry;
import org.cache2k.core.HeapCache;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.storageApi.StorageEntry;
import org.cache2k.core.util.Util;
import org.cache2k.integration.ExceptionInformation;

public class Entry<K, T>
extends CompactEntry<K, T>
implements CacheEntry<K, T>,
StorageEntry,
ExaminationEntry<K, T> {
    public static final int EXPIRY_TIME_MIN = 32;
    static final int DATA_VALID = 16;
    static final int VIRGIN = 0;
    static final int READ_NON_VALID = 1;
    static final int REMOVE_PENDING = 2;
    static final int ABORTED = 3;
    static final int EXPIRED = 4;
    static final int EXPIRED_REFRESH_PENDING = 5;
    static final int EXPIRED_REFRESHED = 6;
    static final int GONE = 8;
    static final int GONE_OTHER = 15;
    private Object misc;
    private volatile long fetchedTime;
    public Entry next;
    public Entry prev;
    private boolean hot;
    private static final int MODIFICATION_TIME_BITS = 44;
    private static final long MODIFICATION_TIME_BASE = 0L;
    private static final int MODIFICATION_TIME_SHIFT = 1;
    private static final long MODIFICATION_TIME_MASK = 0xFFFFFFFFFFFL;
    private static final int DIRTY = 0;
    private static final int CLEAN = 1;
    private static final int PS_BITS = 5;
    private static final int PS_MASK = 31;
    private static final int PS_POS = 44;
    private static final Entry LIST_REMOVED_MARKER = new Entry();

    public Entry(K _key, int _hashCode) {
        super(_key, _hashCode);
    }

    public Entry() {
        this(null, 0);
    }

    void setLastModification(long t, int _clean) {
        this.fetchedTime = this.fetchedTime & 0xFFFFF00000000000L | (t - 0L << 1) + (long)_clean & 0xFFFFFFFFFFFL;
    }

    public void setLastModification(long t) {
        this.setLastModification(t, 0);
    }

    public boolean isDirty() {
        return (this.fetchedTime & 1L) == 0L;
    }

    public void setLastModificationFromStorage(long t) {
        this.setLastModification(t, 1);
    }

    public void resetDirty() {
        this.fetchedTime |= 1L;
    }

    @Override
    public long getLastModification() {
        return (this.fetchedTime & 0xFFFFFFFFFFFL) >> 1;
    }

    String num2processingStateText(int ps) {
        switch (ps) {
            case 0: {
                return "DONE";
            }
            case 1: {
                return "READ";
            }
            case 2: {
                return "READ_COMPLETE";
            }
            case 3: {
                return "MUTATE";
            }
            case 4: {
                return "LOAD";
            }
            case 5: {
                return "LOAD_COMPLETE";
            }
            case 6: {
                return "FETCH";
            }
            case 7: {
                return "REFRESH";
            }
            case 8: {
                return "EXPIRY";
            }
            case 9: {
                return "EXPIRY_COMPLETE";
            }
            case 10: {
                return "WRITE";
            }
            case 11: {
                return "WRITE_COMPLETE";
            }
            case 12: {
                return "STORE";
            }
            case 13: {
                return "STORE_COMPLETE";
            }
            case 14: {
                return "NOTIFY";
            }
            case 15: {
                return "PINNED";
            }
            case 16: {
                return "EVICT";
            }
            case 17: {
                return "LAST";
            }
        }
        return "UNKNOWN";
    }

    public int getProcessingState() {
        return (int)(this.fetchedTime >> 44 & 0x1FL);
    }

    private void setProcessingState(int v) {
        this.fetchedTime = this.fetchedTime & 0xFFFE0FFFFFFFFFFFL | (long)v << 44;
    }

    public void startProcessing() {
        this.setProcessingState(6);
    }

    public void startProcessing(int ps) {
        this.setProcessingState(ps);
    }

    public void nextProcessingStep(int ps) {
        this.setProcessingState(ps);
    }

    public void processingDone() {
        this.notifyAll();
        this.setProcessingState(0);
    }

    public long getNextRefreshTime() {
        return this.nextRefreshTime;
    }

    public void setNextRefreshTime(long _nextRefreshTime) {
        this.nextRefreshTime = _nextRefreshTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureAbort(boolean _finished) {
        if (_finished) {
            return;
        }
        Entry entry = this;
        synchronized (entry) {
            if (this.isVirgin()) {
                this.nextRefreshTime = 3L;
            }
            if (this.isProcessing()) {
                this.processingDone();
            }
        }
    }

    public boolean isProcessing() {
        return this.getProcessingState() != 0;
    }

    public void waitForProcessing() {
        if (!this.isProcessing()) {
            return;
        }
        boolean _interrupt = false;
        do {
            try {
                this.wait();
            }
            catch (InterruptedException ignore) {
                _interrupt = true;
            }
        } while (this.isProcessing());
        if (_interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isGettingRefresh() {
        return this.getProcessingState() == 7;
    }

    public final void removedFromList() {
        this.next = LIST_REMOVED_MARKER;
        this.prev = null;
    }

    public boolean isRemovedFromReplacementList() {
        return this.next == LIST_REMOVED_MARKER;
    }

    public boolean isNotYetInsertedInReplacementList() {
        return this.next == null;
    }

    public Entry shortCircuit() {
        this.next = this.prev = this;
        return this.prev;
    }

    public final boolean isVirgin() {
        return this.nextRefreshTime == 0L;
    }

    public final boolean isDataValid() {
        return this.nextRefreshTime >= 16L || this.nextRefreshTime < 0L;
    }

    public final boolean hasFreshData() {
        if (this.nextRefreshTime >= 16L) {
            return true;
        }
        if (this.needsTimeCheck()) {
            return System.currentTimeMillis() < -this.nextRefreshTime;
        }
        return false;
    }

    public final boolean hasFreshData(long now, long _nextRefreshTime) {
        if (_nextRefreshTime >= 16L) {
            return true;
        }
        if (_nextRefreshTime < 0L) {
            return now < -_nextRefreshTime;
        }
        return false;
    }

    public boolean isReadNonValid() {
        return this.nextRefreshTime == 1L;
    }

    public void setExpiredState() {
        this.nextRefreshTime = 4L;
    }

    public boolean isExpired() {
        return this.nextRefreshTime == 4L;
    }

    public void setGone() {
        long nrt = this.nextRefreshTime;
        if (nrt >= 0L && nrt < 8L) {
            this.nextRefreshTime = 8L + nrt;
            return;
        }
        this.nextRefreshTime = 15L;
    }

    public boolean isGone() {
        long nrt = this.nextRefreshTime;
        return nrt >= 8L && nrt <= 15L;
    }

    public boolean needsTimeCheck() {
        return this.nextRefreshTime < 0L;
    }

    public boolean isHot() {
        return this.hot;
    }

    public void setHot(boolean f) {
        this.hot = f;
    }

    @Override
    public K getKey() {
        return (K)this.key;
    }

    @Override
    public long getValueExpiryTime() {
        if (this.nextRefreshTime < 0L) {
            return -this.nextRefreshTime;
        }
        if (this.nextRefreshTime > 32L) {
            return this.nextRefreshTime;
        }
        return 0L;
    }

    @Override
    public long getCreatedOrUpdated() {
        return this.getLastModification();
    }

    @Override
    public long getEntryExpiryTime() {
        return 0L;
    }

    public String toString(HeapCache c) {
        StringBuilder sb = new StringBuilder();
        sb.append("Entry{");
        sb.append("id=").append(System.identityHashCode(this));
        sb.append(", lock=").append(this.num2processingStateText(this.getProcessingState()));
        sb.append(", key=");
        if (this.key == null) {
            sb.append("null");
        } else {
            sb.append(this.key);
            if (c != null && c.modifiedHash(this.key.hashCode()) != this.hashCode) {
                sb.append(", keyMutation=true");
            }
        }
        Object _valueOrException = this.getValueOrException();
        if (_valueOrException != null) {
            sb.append(", valueId=").append(System.identityHashCode(_valueOrException));
        } else {
            sb.append(", value=null");
        }
        sb.append(", modified=").append(Util.formatMillis(this.getLastModification()));
        long nrt = this.nextRefreshTime;
        if (nrt < 0L) {
            sb.append(", nextRefreshTime(sharp)=").append(Util.formatMillis(-nrt));
        } else if (nrt == Long.MAX_VALUE) {
            sb.append(", nextRefreshTime=ETERNAL");
        } else if (nrt >= 32L) {
            sb.append(", nextRefreshTime(timer)=").append(Util.formatMillis(nrt));
        } else {
            sb.append(", state=").append(nrt);
        }
        if (Thread.holdsLock(this)) {
            if (this.getTask() != null) {
                String _timerState = "<unavailable>";
                try {
                    Field f = TimerTask.class.getDeclaredField("state");
                    f.setAccessible(true);
                    int _state = f.getInt(this.getTask());
                    _timerState = String.valueOf(_state);
                }
                catch (Exception x) {
                    _timerState = x.toString();
                }
                sb.append(", timerState=").append(_timerState);
            }
        } else {
            sb.append(", timerState=skipped/notLocked");
        }
        sb.append(", dirty=").append(this.isDirty());
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public TimerTask getTask() {
        if (this.misc instanceof TimerTask) {
            return (TimerTask)this.misc;
        }
        TimerTaskPiggyBack pb = this.getPiggyBack(TimerTaskPiggyBack.class);
        if (pb != null) {
            return pb.task;
        }
        return null;
    }

    public boolean cancelTimerTask() {
        TimerTask tt;
        Object o = this.misc;
        if (o instanceof TimerTask) {
            this.misc = null;
            return ((TimerTask)o).cancel();
        }
        TimerTaskPiggyBack pb = this.getPiggyBack(TimerTaskPiggyBack.class);
        if (pb != null && (tt = pb.task) != null) {
            pb.task = null;
            return tt.cancel();
        }
        return false;
    }

    public <X> X getPiggyBack(Class<X> _class) {
        Object obj = this.misc;
        if (!(obj instanceof PiggyBack)) {
            return null;
        }
        PiggyBack pb = (PiggyBack)obj;
        do {
            if (pb.getClass() != _class) continue;
            return (X)pb;
        } while ((pb = pb.next) != null);
        return null;
    }

    public void setTask(TimerTask v) {
        if (this.misc == null || this.misc instanceof TimerTask) {
            this.misc = v;
            return;
        }
        TimerTaskPiggyBack pb = this.getPiggyBack(TimerTaskPiggyBack.class);
        if (pb != null) {
            pb.task = v;
            return;
        }
        this.misc = new TimerTaskPiggyBack(v, (PiggyBack)this.misc);
    }

    private PiggyBack existingPiggyBackForInserting() {
        Object _misc = this.misc;
        if (_misc instanceof TimerTask) {
            return new TimerTaskPiggyBack((TimerTask)_misc, null);
        }
        return (PiggyBack)_misc;
    }

    public void setSuppressedLoadExceptionInformation(ExceptionInformation w) {
        LoadExceptionPiggyBack inf = this.getPiggyBack(LoadExceptionPiggyBack.class);
        if (inf != null) {
            inf.info = w;
            return;
        }
        this.misc = new LoadExceptionPiggyBack(w, this.existingPiggyBackForInserting());
    }

    public void resetSuppressedLoadExceptionInformation() {
        LoadExceptionPiggyBack inf = this.getPiggyBack(LoadExceptionPiggyBack.class);
        if (inf != null) {
            inf.info = null;
        }
    }

    public ExceptionInformation getSuppressedLoadExceptionInformation() {
        LoadExceptionPiggyBack inf = this.getPiggyBack(LoadExceptionPiggyBack.class);
        return inf != null ? inf.info : null;
    }

    public void setRefreshProbationNextRefreshTime(long nrt) {
        RefreshProbationPiggyBack inf = this.getPiggyBack(RefreshProbationPiggyBack.class);
        if (inf != null) {
            inf.nextRefreshTime = nrt;
            return;
        }
        this.misc = new RefreshProbationPiggyBack(nrt, this.existingPiggyBackForInserting());
    }

    public long getRefreshProbationNextRefreshTime() {
        RefreshProbationPiggyBack inf = this.getPiggyBack(RefreshProbationPiggyBack.class);
        return inf != null ? inf.nextRefreshTime : 0L;
    }

    public static void removeFromList(Entry e) {
        e.prev.next = e.next;
        e.next.prev = e.prev;
        e.removedFromList();
    }

    public static void insertInList(Entry _head, Entry e) {
        e.prev = _head;
        e.next = _head.next;
        e.next.prev = e;
        _head.next = e;
    }

    public static final int getListEntryCount(Entry _head) {
        Entry e = _head.next;
        int cnt = 0;
        while (e != _head) {
            ++cnt;
            if (e == null) {
                return -cnt;
            }
            e = e.next;
        }
        return cnt;
    }

    public static final <E extends Entry> void moveToFront(E _head, E e) {
        Entry.removeFromList(e);
        Entry.insertInList(_head, e);
    }

    public static final <E extends Entry> E insertIntoTailCyclicList(E _head, E e) {
        if (_head == null) {
            return (E)e.shortCircuit();
        }
        e.next = _head;
        e.prev = _head.prev;
        _head.prev = e;
        e.prev.next = e;
        return _head;
    }

    public static final <E extends Entry> E insertAfterHeadCyclicList(E _head, E e) {
        if (_head == null) {
            return (E)e.shortCircuit();
        }
        e.prev = _head;
        e.next = _head.next;
        _head.next.prev = e;
        _head.next = e;
        return _head;
    }

    public static final <E extends Entry> E insertIntoHeadCyclicList(E _head, E e) {
        if (_head == null) {
            return (E)e.shortCircuit();
        }
        e.next = _head;
        e.prev = _head.prev;
        _head.prev.next = e;
        _head.prev = e;
        return e;
    }

    public static <E extends Entry> E removeFromCyclicList(E _head, E e) {
        Entry _eNext;
        if (e.next == e) {
            e.removedFromList();
            return null;
        }
        e.prev.next = _eNext = e.next;
        e.next.prev = e.prev;
        e.removedFromList();
        return (E)(e == _head ? _eNext : _head);
    }

    public static Entry removeFromCyclicList(Entry e) {
        Entry _eNext;
        e.prev.next = _eNext = e.next;
        e.next.prev = e.prev;
        e.removedFromList();
        return _eNext == e ? null : _eNext;
    }

    public static int getCyclicListEntryCount(Entry e) {
        if (e == null) {
            return 0;
        }
        Entry _head = e;
        int cnt = 0;
        do {
            ++cnt;
            e = e.next;
            if (e != null) continue;
            return -cnt;
        } while (e != _head);
        return cnt;
    }

    public static boolean checkCyclicListIntegrity(Entry e) {
        if (e == null) {
            return true;
        }
        Entry _head = e;
        do {
            if (e.next == null) {
                return false;
            }
            if (e.next.prev == null) {
                return false;
            }
            if (e.next.prev == e) continue;
            return false;
        } while ((e = e.next) != _head);
        return true;
    }

    static class RefreshProbationPiggyBack
    extends PiggyBack {
        long nextRefreshTime;

        public RefreshProbationPiggyBack(long _nextRefreshTime, PiggyBack _next) {
            super(_next);
            this.nextRefreshTime = _nextRefreshTime;
        }
    }

    static class LoadExceptionPiggyBack
    extends PiggyBack {
        ExceptionInformation info;

        public LoadExceptionPiggyBack(ExceptionInformation _info, PiggyBack _next) {
            super(_next);
            this.info = _info;
        }
    }

    static class TimerTaskPiggyBack
    extends PiggyBack {
        TimerTask task;

        public TimerTaskPiggyBack(TimerTask _task, PiggyBack _next) {
            super(_next);
            this.task = _task;
        }
    }

    static class PiggyBack {
        final PiggyBack next;

        public PiggyBack(PiggyBack _next) {
            this.next = _next;
        }
    }

    static class ProcessingState {
        static final int DONE = 0;
        static final int READ = 1;
        static final int READ_COMPLETE = 2;
        static final int MUTATE = 3;
        static final int LOAD = 4;
        static final int LOAD_COMPLETE = 5;
        static final int FETCH = 6;
        static final int REFRESH = 7;
        static final int EXPIRY = 8;
        static final int EXPIRY_COMPLETE = 9;
        static final int WRITE = 10;
        static final int WRITE_COMPLETE = 11;
        static final int STORE = 12;
        static final int STORE_COMPLETE = 13;
        static final int NOTIFY = 14;
        static final int PINNED = 15;
        static final int EVICT = 16;
        static final int LAST = 17;

        ProcessingState() {
        }
    }
}

