/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.concurrent.ThreadPoolExecutor;
import org.cache2k.core.CollisionInfo;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.EvictionMetrics;
import org.cache2k.core.HeapCache;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.core.StorageMetrics;
import org.cache2k.core.util.Util;

class CacheBaseInfo
implements InternalCacheInfo {
    private CommonMetrics metrics;
    private StorageMetrics storageMetrics = StorageMetrics.DUMMY;
    private HeapCache heapCache;
    private long size;
    private long infoCreatedTime;
    private int infoCreationDeltaMs;
    private long missCnt;
    private long storageMissCnt;
    private long hitCnt;
    private long correctedPutCnt;
    private long usageCnt;
    private CollisionInfo collisionInfo;
    private String extraStatistics;
    private IntegrityState integrityState;
    private long asyncLoadsStarted = 0L;
    private long asyncLoadsInFlight = 0L;
    private int loaderThreadsLimit = 0;
    private int loaderThreadsMaxActive = 0;
    private long totalLoadCnt;
    private long clearedTime;
    private long newEntryCnt;
    private long keyMutationCnt;
    private long removedCnt;
    private long clearRemovedCnt;
    private long clearCnt;
    private long expiredRemoveCnt;
    private long evictedCnt;
    private long maxSize;
    private long evictionRunningCnt;

    public CacheBaseInfo(HeapCache _heapCache, InternalCache _userCache, long now) {
        this.infoCreatedTime = now;
        this.heapCache = _heapCache;
        this.metrics = _heapCache.metrics;
        EvictionMetrics em = _heapCache.eviction.getMetrics();
        this.newEntryCnt = em.getNewEntryCount();
        this.clearedTime = _heapCache.clearedTime;
        this.keyMutationCnt = _heapCache.keyMutationCnt;
        this.removedCnt = em.getRemovedCount();
        this.clearRemovedCnt = _heapCache.clearRemovedCnt;
        this.clearCnt = _heapCache.clearCnt;
        this.expiredRemoveCnt = em.getExpiredRemovedCount();
        this.evictedCnt = em.getEvictedCount();
        this.maxSize = em.getMaxSize();
        this.evictionRunningCnt = em.getEvictionRunningCount();
        this.integrityState = _heapCache.getIntegrityState();
        this.storageMetrics = _userCache.getStorageMetrics();
        this.collisionInfo = new CollisionInfo();
        _heapCache.hash.calcHashCollisionInfo(this.collisionInfo);
        this.extraStatistics = em.getExtraStatistics();
        if (this.extraStatistics.startsWith(", ")) {
            this.extraStatistics = this.extraStatistics.substring(2);
        }
        this.size = this.heapCache.getLocalSize();
        this.missCnt = this.metrics.getLoadCount() + this.metrics.getReloadCount() + this.metrics.getPeekHitNotFreshCount() + this.metrics.getPeekMissCount();
        this.storageMissCnt = this.storageMetrics.getReadMissCount() + this.storageMetrics.getReadNonFreshCount();
        this.hitCnt = em.getHitCount();
        this.correctedPutCnt = this.metrics.getPutNewEntryCount() + this.metrics.getPutHitCount() + this.metrics.getPutNoReadHitCount();
        this.usageCnt = this.hitCnt + this.newEntryCnt + this.metrics.getPeekMissCount() + this.metrics.getPutHitCount() + this.metrics.getRemoveCount() - this.metrics.getGoneSpinCount();
        if (_heapCache.loaderExecutor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor ex = (ThreadPoolExecutor)_heapCache.loaderExecutor;
            this.asyncLoadsInFlight = ex.getActiveCount();
            this.asyncLoadsStarted = ex.getTaskCount();
            this.loaderThreadsLimit = ex.getCorePoolSize();
            this.loaderThreadsMaxActive = ex.getLargestPoolSize();
        }
        this.totalLoadCnt = this.metrics.getLoadCount() + this.metrics.getReloadCount() + this.metrics.getRefreshCount();
    }

    String percentString(double d) {
        String s = Double.toString(d);
        return (s.length() > 5 ? s.substring(0, 5) : s) + "%";
    }

    public void setInfoCreationDeltaMs(int _millis) {
        this.infoCreationDeltaMs = _millis;
    }

    @Override
    public String getName() {
        return this.heapCache.name;
    }

    @Override
    public String getImplementation() {
        return this.heapCache.getClass().getSimpleName();
    }

    @Override
    public long getLoadButHitCnt() {
        return this.metrics.getReloadCount();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public long getStorageHitCnt() {
        return this.storageMetrics.getReadHitCount();
    }

    @Override
    public long getStorageMissCnt() {
        return this.storageMissCnt;
    }

    @Override
    public long getReadUsageCnt() {
        long _putHit = this.metrics.getPutNoReadHitCount();
        long _containsBitHit = this.metrics.getContainsButHitCount();
        long _heapHitButNoRead = this.metrics.getHeapHitButNoReadCount();
        long _goneSpin = this.metrics.getGoneSpinCount();
        return this.hitCnt + this.metrics.getPeekMissCount() + this.metrics.getLoadCount() - _putHit - _containsBitHit - _heapHitButNoRead - _goneSpin;
    }

    @Override
    public long getUsageCnt() {
        return this.usageCnt;
    }

    @Override
    public long getMissCnt() {
        return this.missCnt;
    }

    @Override
    public long getNewEntryCnt() {
        return this.newEntryCnt;
    }

    @Override
    public long getLoadCnt() {
        return this.totalLoadCnt;
    }

    @Override
    public long getRefreshCnt() {
        return this.metrics.getRefreshCount();
    }

    @Override
    public long getInternalExceptionCnt() {
        return this.metrics.getInternalExceptionCount();
    }

    @Override
    public long getRefreshSubmitFailedCnt() {
        return this.metrics.getRefreshSubmitFailedCount();
    }

    @Override
    public long getSuppressedExceptionCnt() {
        return this.metrics.getSuppressedExceptionCount();
    }

    @Override
    public long getLoadExceptionCnt() {
        return this.metrics.getLoadExceptionCount() + this.metrics.getSuppressedExceptionCount();
    }

    @Override
    public long getRefreshHitCnt() {
        return this.metrics.getRefreshHitCount();
    }

    @Override
    public long getExpiredCnt() {
        return this.expiredRemoveCnt + this.metrics.getExpiredKeptCount();
    }

    @Override
    public long getEvictedCnt() {
        return this.evictedCnt;
    }

    @Override
    public long getEvictionRunningCnt() {
        return this.evictionRunningCnt;
    }

    @Override
    public long getRemovedCnt() {
        return this.metrics.getRemoveCount();
    }

    @Override
    public long getPutCnt() {
        return this.correctedPutCnt;
    }

    @Override
    public long getGoneSpinCnt() {
        return this.metrics.getGoneSpinCount();
    }

    @Override
    public long getKeyMutationCnt() {
        return this.keyMutationCnt;
    }

    @Override
    public long getTimerEventCnt() {
        return this.metrics.getTimerEventCount();
    }

    @Override
    public double getDataHitRate() {
        long cnt = this.getReadUsageCnt();
        return cnt == 0L ? 0.0 : (double)(cnt - this.missCnt) * 100.0 / (double)cnt;
    }

    @Override
    public String getDataHitString() {
        return this.percentString(this.getDataHitRate());
    }

    @Override
    public double getEntryHitRate() {
        return this.usageCnt == 0L ? 100.0 : (double)(this.usageCnt - this.newEntryCnt + this.metrics.getPutNewEntryCount()) * 100.0 / (double)this.usageCnt;
    }

    @Override
    public String getEntryHitString() {
        return this.percentString(this.getEntryHitRate());
    }

    @Override
    public int getCollisionPercentage() {
        return (int)((this.size - (long)this.collisionInfo.collisionCnt) * 100L / this.size);
    }

    @Override
    public int getSlotsPercentage() {
        return this.collisionInfo.collisionSlotCnt * 100 / this.collisionInfo.collisionCnt;
    }

    @Override
    public int getHq0() {
        return Math.max(0, 105 - this.collisionInfo.longestCollisionSize * 5);
    }

    @Override
    public int getHq1() {
        int _metricPercentageBase = 60;
        int m = this.getCollisionPercentage() * 40 / 100 + 60;
        m = Math.min(100, m);
        m = Math.max(0, m);
        return m;
    }

    @Override
    public int getHq2() {
        int _metricPercentageBase = 80;
        int m = this.getSlotsPercentage() * 20 / 100 + 80;
        m = Math.min(100, m);
        m = Math.max(0, m);
        return m;
    }

    @Override
    public int getHashQualityInteger() {
        int v;
        if (this.size == 0L || this.collisionInfo.collisionSlotCnt == 0) {
            return 100;
        }
        int _metric0 = this.getHq0();
        int _metric1 = this.getHq1();
        int _metric2 = this.getHq2();
        if (_metric1 < _metric0) {
            v = _metric0;
            _metric0 = _metric1;
            _metric1 = v;
        }
        if (_metric2 < _metric0) {
            v = _metric0;
            _metric0 = _metric2;
            _metric2 = v;
        }
        if (_metric2 < _metric1) {
            v = _metric1;
            _metric1 = _metric2;
            _metric2 = v;
        }
        if (_metric0 <= 0) {
            return 0;
        }
        _metric0 += (_metric1 - 50) * 5 / _metric0;
        _metric0 += (_metric2 - 50) * 2 / _metric0;
        _metric0 = Math.max(0, _metric0);
        _metric0 = Math.min(100, _metric0);
        return _metric0;
    }

    @Override
    public double getMillisPerLoad() {
        return this.getLoadCnt() == 0L ? 0.0 : (double)this.metrics.getLoadMillis() * 1.0 / (double)this.getLoadCnt();
    }

    @Override
    public long getLoadMillis() {
        return this.metrics.getLoadMillis();
    }

    @Override
    public int getCollisionCnt() {
        return this.collisionInfo.collisionCnt;
    }

    @Override
    public int getCollisionSlotCnt() {
        return this.collisionInfo.collisionSlotCnt;
    }

    @Override
    public int getLongestCollisionSize() {
        return this.collisionInfo.longestCollisionSize;
    }

    @Override
    public String getIntegrityDescriptor() {
        return this.integrityState.getStateDescriptor();
    }

    @Override
    public long getStartedTime() {
        return this.heapCache.startedTime;
    }

    @Override
    public long getClearedTime() {
        return this.clearedTime;
    }

    @Override
    public long getInfoCreatedTime() {
        return this.infoCreatedTime;
    }

    @Override
    public int getInfoCreationDeltaMs() {
        return this.infoCreationDeltaMs;
    }

    @Override
    public int getHealth() {
        if (this.getHashQualityInteger() < 30 || this.getKeyMutationCnt() > 0L || this.getInternalExceptionCnt() > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getAsyncLoadsStarted() {
        return this.asyncLoadsStarted;
    }

    @Override
    public long getAsyncLoadsInFlight() {
        return this.asyncLoadsInFlight;
    }

    @Override
    public int getLoaderThreadsLimit() {
        return this.loaderThreadsLimit;
    }

    @Override
    public int getLoaderThreadsMaxActive() {
        return this.loaderThreadsMaxActive;
    }

    @Override
    public String getExtraStatistics() {
        return this.extraStatistics;
    }

    static String timestampToString(long t) {
        if (t == 0L) {
            return "-";
        }
        return Util.formatMillis(t);
    }

    @Override
    public long getClearCnt() {
        return this.clearCnt;
    }

    @Override
    public long getClearRemovedCnt() {
        return this.clearRemovedCnt;
    }

    public String toString() {
        return "Cache{" + this.heapCache.name + "}(" + "size=" + this.getSize() + ", " + "maxSize=" + this.getMaxSize() + ", " + "usageCnt=" + this.getUsageCnt() + ", " + "missCnt=" + this.getMissCnt() + ", " + "peekMissCnt=" + this.metrics.getPeekMissCount() + ", " + "peekHitNotFresh=" + this.metrics.getPeekHitNotFreshCount() + ", " + "loadCnt=" + this.getLoadCnt() + ", " + "loadButHitCnt=" + this.getLoadButHitCnt() + ", " + "heapHitCnt=" + this.hitCnt + ", " + "newEntryCnt=" + this.getNewEntryCnt() + ", " + "refreshCnt=" + this.getRefreshCnt() + ", " + "refreshSubmitFailedCnt=" + this.getRefreshSubmitFailedCnt() + ", " + "refreshHitCnt=" + this.getRefreshHitCnt() + ", " + "putCnt=" + this.getPutCnt() + ", " + "expiredCnt=" + this.getExpiredCnt() + ", " + "evictedCnt=" + this.getEvictedCnt() + ", " + "evictionRunningCnt=" + this.getEvictionRunningCnt() + ", " + "removedCnt=" + this.getRemovedCnt() + ", " + "clearRemovedCnt=" + this.getClearRemovedCnt() + ", " + "timerEventCnt=" + this.getTimerEventCnt() + ", " + "goneSpinCnt=" + this.getGoneSpinCnt() + ", " + "hitRate=" + this.getDataHitString() + ", " + "collisionCnt=" + this.getCollisionCnt() + ", " + "collisionSlotCnt=" + this.getCollisionSlotCnt() + ", " + "longestCollisionSize=" + this.getLongestCollisionSize() + ", " + "hashQuality=" + this.getHashQualityInteger() + ", " + "msecs/load=" + (this.getMillisPerLoad() >= 0.0 ? Double.valueOf(this.getMillisPerLoad()) : "-") + ", " + "asyncLoadsStarted=" + this.asyncLoadsStarted + ", " + "asyncLoadsInFlight=" + this.asyncLoadsInFlight + ", " + "loaderThreadsLimit=" + this.loaderThreadsLimit + ", " + "loaderThreadsMaxActive=" + this.loaderThreadsMaxActive + ", " + "created=" + CacheBaseInfo.timestampToString(this.getStartedTime()) + ", " + "cleared=" + CacheBaseInfo.timestampToString(this.getClearedTime()) + ", " + "clearCnt=" + this.getClearCnt() + ", " + "loadExceptionCnt=" + this.getLoadExceptionCnt() + ", " + "suppressedExceptionCnt=" + this.getSuppressedExceptionCnt() + ", " + "internalExceptionCnt=" + this.getInternalExceptionCnt() + ", " + "keyMutationCnt=" + this.getKeyMutationCnt() + ", " + "infoCreated=" + CacheBaseInfo.timestampToString(this.getInfoCreatedTime()) + ", " + "infoCreationDeltaMs=" + this.getInfoCreationDeltaMs() + ", " + "impl=" + this.getImplementation() + ", " + this.getExtraStatistics() + ", " + "integrityState=" + this.getIntegrityDescriptor() + ")";
    }
}

