/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.threading;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;

public class GlobalThreadFactory
implements ThreadFactory {
    static final ConcurrentMap<String, String> NAMES_RUNNING = new ConcurrentHashMap<String, String>();
    String prefix;

    public GlobalThreadFactory(String _threadNamePrefix) {
        if (_threadNamePrefix == null) {
            throw new NullPointerException("Missing thread name prefix");
        }
        this.prefix = _threadNamePrefix;
    }

    protected String generateName(int id) {
        return this.prefix + '-' + id;
    }

    @Override
    public Thread newThread(final Runnable r) {
        String _name;
        int id = 1;
        while (NAMES_RUNNING.putIfAbsent(_name = this.generateName(id), _name) != null) {
            ++id;
        }
        final String _finalName = _name;
        Runnable _myRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    NAMES_RUNNING.remove(_finalName);
                }
            }
        };
        Thread thr = new Thread(_myRunnable);
        thr.setName(_name);
        thr.setDaemon(true);
        return thr;
    }
}

