/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.operation;

import org.cache2k.CacheEntry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Progress;
import org.cache2k.core.operation.ReadOnlyCacheEntry;
import org.cache2k.core.operation.ResultEntry;
import org.cache2k.core.operation.Semantic;
import org.cache2k.processor.CacheEntryProcessor;
import org.cache2k.processor.MutableCacheEntry;
import org.cache2k.processor.RestartException;

public class Specification<K, V> {
    public static final Specification SINGLETON = new Specification();
    static final Semantic PEEK = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(e.getValueOrException());
            }
        }
    };
    static final Semantic GET = new Semantic.MightUpdateExisting(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(e.getValueOrException());
            } else {
                c.wantMutation();
            }
        }

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.load();
        }
    };
    public static final Semantic UNCONDITIONAL_LOAD = new Semantic.Update(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.load();
        }
    };
    static final Semantic GET_ENTRY = new Semantic.MightUpdateExisting(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(Specification.returnStableEntry(e));
            } else {
                c.wantMutation();
            }
        }

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.load();
        }

        @Override
        public void loaded(Progress c, ExaminationEntry e) {
            c.result(Specification.returnStableEntry(e));
        }
    };
    static final Semantic PEEK_ENTRY = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(Specification.returnStableEntry(e));
            }
        }
    };
    static final Semantic REMOVE = new Semantic.Update(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            c.remove();
        }
    };
    static final Semantic CONTAINS_REMOVE = new Semantic.UpdateExisting(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            if (c.isPresent()) {
                c.result(true);
                c.remove();
                return;
            }
            c.result(false);
            c.remove();
        }
    };
    static final Semantic CONTAINS = new Semantic.Read(){

        @Override
        public void examine(Progress c, ExaminationEntry e) {
            if (c.isPresent()) {
                c.result(true);
                return;
            }
            c.result(false);
        }
    };
    static final Semantic PEEK_REMOVE = new Semantic.UpdateExisting(){

        @Override
        public void update(Progress c, ExaminationEntry e) {
            if (c.isPresentOrMiss()) {
                c.result(e.getValueOrException());
            }
            c.remove();
        }
    };

    public Semantic<K, V, V> peek(K key) {
        return PEEK;
    }

    public Semantic<K, V, V> get(K key) {
        return GET;
    }

    public Semantic<K, V, ResultEntry<K, V>> getEntry(K key) {
        return GET_ENTRY;
    }

    public static CacheEntry returnStableEntry(ExaminationEntry e) {
        return new ReadOnlyCacheEntry(e.getKey(), e.getValueOrException(), e.getLastModification());
    }

    public Semantic<K, V, ResultEntry<K, V>> peekEntry(K key) {
        return PEEK_ENTRY;
    }

    public Semantic<K, V, V> remove(K key) {
        return REMOVE;
    }

    public Semantic<K, V, Boolean> containsAndRemove(K key) {
        return CONTAINS_REMOVE;
    }

    public Semantic<K, V, Boolean> contains(K key) {
        return CONTAINS;
    }

    public Semantic<K, V, V> peekAndRemove(K key) {
        return PEEK_REMOVE;
    }

    public Semantic<K, V, V> peekAndReplace(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, V>(){

            @Override
            public void update(Progress<V, V> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(e.getValueOrException());
                    c.put(value);
                }
            }
        };
    }

    public Semantic<K, V, V> peekAndPut(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, V>(){

            @Override
            public void update(Progress<V, V> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(e.getValueOrException());
                }
                c.put(value);
            }
        };
    }

    public Semantic<K, V, V> put(K key, final V value) {
        return new Semantic.Update<K, V, V>(){

            @Override
            public void update(Progress<V, V> c, ExaminationEntry<K, V> e) {
                c.put(value);
            }
        };
    }

    public Semantic<K, V, Boolean> putIfAbsent(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<V, Boolean> c, ExaminationEntry<K, V> e) {
                if (!c.isPresentOrMiss()) {
                    c.result(true);
                    c.put(value);
                    return;
                }
                c.result(false);
            }
        };
    }

    public Semantic<K, V, Boolean> replace(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    c.result(true);
                    c.put(value);
                    return;
                }
                c.result(false);
            }
        };
    }

    public Semantic<K, V, Boolean> replace(K key, final V value, final V newValue) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss() && (value == null && e.getValueOrException() == null || value.equals(e.getValueOrException()))) {
                    c.result(true);
                    c.put(newValue);
                    return;
                }
                c.result(false);
            }
        };
    }

    public Semantic<K, V, CacheEntry<K, V>> replaceOrGet(K key, final V value, final V newValue, final CacheEntry<K, V> dummyEntry) {
        return new Semantic.UpdateExisting<K, V, CacheEntry<K, V>>(){

            @Override
            public void update(Progress<V, CacheEntry<K, V>> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss()) {
                    if (e.getValueOrException().equals(value)) {
                        c.result(null);
                        c.put(newValue);
                        return;
                    }
                    c.result(Specification.returnStableEntry(e));
                    return;
                }
                c.result(dummyEntry);
            }
        };
    }

    public Semantic<K, V, Boolean> remove(K key, final V value) {
        return new Semantic.UpdateExisting<K, V, Boolean>(){

            @Override
            public void update(Progress<V, Boolean> c, ExaminationEntry<K, V> e) {
                if (c.isPresentOrMiss() && (value == null && e.getValueOrException() == null || value.equals(e.getValueOrException()))) {
                    c.result(true);
                    c.remove();
                    return;
                }
                c.result(false);
            }
        };
    }

    public <R> Semantic<K, V, R> invoke(K key, final boolean _readThrough, final CacheEntryProcessor<K, V, R> _processor, final Object ... _arguments) {
        return new Semantic.UpdateExisting<K, V, R>(){

            @Override
            public void update(Progress<V, R> c, ExaminationEntry<K, V> e) {
                MutableEntryOnProgress _mutableEntryOnProgress = new MutableEntryOnProgress(c, e, _readThrough);
                try {
                    Object _result = _processor.process(_mutableEntryOnProgress, _arguments);
                    c.result(_result);
                }
                catch (NeedsLoadRestartException rs) {
                    c.loadAndMutation();
                    return;
                }
                catch (Throwable t) {
                    c.failure(t);
                    return;
                }
                _mutableEntryOnProgress.sendMutationCommandIfNeeded();
            }

            @Override
            public void loaded(Progress<V, R> c, ExaminationEntry<K, V> e) {
            }
        };
    }

    public static class NeedsLoadRestartException
    extends RestartException {
    }

    static class MutableEntryOnProgress<K, V>
    implements MutableCacheEntry<K, V> {
        ExaminationEntry<K, V> entry;
        Progress<V, ?> progress;
        boolean originalExists = false;
        boolean mutate = false;
        boolean remove = false;
        boolean exists = false;
        V value = null;
        boolean readThrough = false;

        public MutableEntryOnProgress(Progress<V, ?> _progress, ExaminationEntry<K, V> _entry, boolean _readThrough) {
            this.readThrough = _readThrough;
            this.entry = _entry;
            this.progress = _progress;
            if (_progress.isPresentOrMiss()) {
                this.value = this.entry.getValueOrException();
                this.exists = true;
                this.originalExists = true;
            }
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public void setValue(V v) {
            this.mutate = true;
            this.exists = true;
            this.remove = false;
            this.value = v;
        }

        @Override
        public void setException(Throwable ex) {
            this.mutate = true;
            this.exists = true;
            this.remove = false;
            this.value = new ExceptionWrapper(ex);
        }

        @Override
        public void remove() {
            if (this.mutate && !this.originalExists) {
                this.mutate = false;
            } else {
                this.remove = true;
                this.mutate = true;
            }
            this.exists = false;
            this.value = null;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            if (!this.exists && !this.mutate && this.readThrough) {
                throw new NeedsLoadRestartException();
            }
            if (this.value instanceof ExceptionWrapper) {
                return null;
            }
            return this.value;
        }

        @Override
        public Throwable getException() {
            if (this.value instanceof ExceptionWrapper) {
                return ((ExceptionWrapper)this.value).getException();
            }
            return null;
        }

        @Override
        public long getLastModification() {
            return this.entry.getLastModification();
        }

        public void sendMutationCommandIfNeeded() {
            if (this.mutate) {
                if (this.remove) {
                    this.progress.remove();
                    return;
                }
                this.progress.put(this.value);
            }
        }
    }
}

