/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.cache2k.CacheEntry;
import org.cache2k.configuration.CacheConfiguration;
import org.cache2k.core.DefaultResiliencePolicy;
import org.cache2k.core.Entry;
import org.cache2k.core.HeapCache;
import org.cache2k.core.InternalCache;
import org.cache2k.core.util.TunableConstants;
import org.cache2k.core.util.TunableFactory;
import org.cache2k.customization.ExpiryCalculator;
import org.cache2k.customization.ValueWithExpiryTime;
import org.cache2k.integration.LoadExceptionInformation;
import org.cache2k.integration.ResiliencePolicy;

public abstract class TimingHandler<K, V> {
    static final int PURGE_INTERVAL = TunableFactory.get(Tunable.class).purgeInterval;
    static final long SAFETY_GAP_MILLIS = HeapCache.TUNABLE.sharpExpirySafetyGapMillis;
    static final TimingHandler ETERNAL = new Eternal();
    static final TimingHandler IMMEDIATE = new Immediate();
    static final TimingHandler ETERNAL_IMMEDIATE = new EternalImmediate();
    static final ExpiryCalculator<?, ValueWithExpiryTime> ENTRY_EXPIRY_CALCULATOR_FROM_VALUE = new ExpiryCalculator<Object, ValueWithExpiryTime>(){

        @Override
        public long calculateExpiryTime(Object _key, ValueWithExpiryTime _value, long _loadTime, CacheEntry<Object, ValueWithExpiryTime> _oldEntry) {
            return _value.getCacheExpiryTime();
        }
    };

    static boolean realDuration(long t) {
        return t > 0L && t < Long.MAX_VALUE;
    }

    static boolean zeroOrUnspecified(long t) {
        return t == 0L || t == -1L;
    }

    public static <K, V> TimingHandler<K, V> of(CacheConfiguration<K, V> cfg) {
        if (cfg.getExpireAfterWriteMillis() < 0L) {
            throw new IllegalArgumentException("Specify expiry or no expiry explicitly. Either set CacheBuilder.eternal(true) or CacheBuilder.expiryDuration(...). See: https://github.com/cache2k/cache2k/issues/21");
        }
        if (cfg.getExpireAfterWriteMillis() == 0L && TimingHandler.zeroOrUnspecified(cfg.getRetryIntervalMillis())) {
            return IMMEDIATE;
        }
        if (cfg.getExpiryCalculator() != null || ValueWithExpiryTime.class.isAssignableFrom(cfg.getValueType().getType()) || cfg.getResiliencePolicy() != null) {
            Dynamic<K, V> h = new Dynamic<K, V>();
            h.configure(cfg);
            return h;
        }
        if (cfg.getResilienceDurationMillis() > 0L && !cfg.isSuppressExceptions()) {
            throw new IllegalArgumentException("Ambiguous: exceptions suppression is switched off, but resilience duration is specified");
        }
        if (TimingHandler.realDuration(cfg.getExpireAfterWriteMillis()) || TimingHandler.realDuration(cfg.getRetryIntervalMillis()) || TimingHandler.realDuration(cfg.getResilienceDurationMillis())) {
            Static<K, V> h = new Static<K, V>();
            h.configureStatic(cfg);
            return h;
        }
        if (cfg.getExpireAfterWriteMillis() == Long.MAX_VALUE && TimingHandler.zeroOrUnspecified(cfg.getRetryIntervalMillis())) {
            return ETERNAL_IMMEDIATE;
        }
        if (!(cfg.getExpireAfterWriteMillis() != Long.MAX_VALUE && cfg.getExpireAfterWriteMillis() != -1L || cfg.getRetryIntervalMillis() != Long.MAX_VALUE && cfg.getRetryIntervalMillis() != -1L)) {
            return ETERNAL;
        }
        throw new IllegalArgumentException("expiry time ambiguous");
    }

    public void init(InternalCache<K, V> c) {
    }

    public void reset() {
    }

    public void shutdown() {
    }

    public abstract long calculateNextRefreshTime(Entry<K, V> var1, V var2, long var3);

    public abstract long suppressExceptionUntil(Entry<K, V> var1, LoadExceptionInformation var2);

    public abstract long cacheExceptionUntil(Entry<K, V> var1, LoadExceptionInformation var2);

    public long stopStartTimer(long _nextRefreshTime, Entry<K, V> e) {
        return _nextRefreshTime == 0L ? 4L : _nextRefreshTime;
    }

    public void cancelExpiryTimer(Entry<K, V> e) {
    }

    public void scheduleFinalExpiryTimer(Entry<K, V> e) {
    }

    static <K, T> long calcNextRefreshTime(K _key, T _newObject, long now, Entry _entry, ExpiryCalculator<K, T> ec, long _maxLinger) {
        if (_maxLinger == 0L) {
            return 0L;
        }
        if (ec != null) {
            long t = ec.calculateExpiryTime(_key, _newObject, now, _entry);
            return TimingHandler.limitExpiryToMaxLinger(now, _maxLinger, t);
        }
        if (_maxLinger < Long.MAX_VALUE) {
            return _maxLinger + now;
        }
        return _maxLinger;
    }

    static long limitExpiryToMaxLinger(long now, long _maxLinger, long t) {
        if (_maxLinger > 0L && _maxLinger < Long.MAX_VALUE) {
            long _tMaximum = _maxLinger + now;
            if (t > _tMaximum) {
                return _tMaximum;
            }
            if (t < -1L && -t > _tMaximum) {
                return -_tMaximum;
            }
        }
        return t;
    }

    static long sanitizeTime(long _nextRefreshTime, long now) {
        if (_nextRefreshTime > 32L && _nextRefreshTime <= now || _nextRefreshTime < -1L && -_nextRefreshTime <= -now) {
            return 4L;
        }
        return _nextRefreshTime;
    }

    public static class Tunable
    extends TunableConstants {
        public int purgeInterval = 10000;
    }

    static class Dynamic<K, V>
    extends Static<K, V> {
        ExpiryCalculator<K, V> expiryCalculator;

        Dynamic() {
        }

        void configure(CacheConfiguration<K, V> c) {
            this.configureStatic(c);
            this.expiryCalculator = c.getExpiryCalculator();
            if (ValueWithExpiryTime.class.isAssignableFrom(c.getValueType().getType()) && this.expiryCalculator == null) {
                this.expiryCalculator = ENTRY_EXPIRY_CALCULATOR_FROM_VALUE;
            }
        }

        long calcNextRefreshTime(K _key, V _newObject, long now, Entry _entry) {
            return Dynamic.calcNextRefreshTime(_key, _newObject, now, _entry, this.expiryCalculator, this.maxLinger);
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> _entry, V _newValue, long _loadTime) {
            if (_entry.isDataValid() || _entry.isExpired()) {
                return this.calcNextRefreshTime(_entry.getKey(), _newValue, _loadTime, _entry);
            }
            return this.calcNextRefreshTime(_entry.getKey(), _newValue, _loadTime, null);
        }
    }

    static class ExpireTask<K, V>
    extends TimerTask {
        Entry<K, V> entry;
        InternalCache cache;

        public ExpireTask(InternalCache _cache, Entry<K, V> _entry) {
            this.cache = _cache;
            this.entry = _entry;
        }

        @Override
        public void run() {
            this.cache.timerEventExpireEntry(this.entry);
        }
    }

    static class RefreshTask<K, V>
    extends TimerTask {
        Entry<K, V> entry;
        InternalCache cache;

        public RefreshTask(InternalCache _cache, Entry<K, V> _entry) {
            this.cache = _cache;
            this.entry = _entry;
        }

        @Override
        public void run() {
            this.cache.timerEventRefresh(this.entry);
        }
    }

    static class Static<K, V>
    extends TimingHandler<K, V> {
        boolean sharpExpiry;
        boolean refreshAhead;
        Timer timer;
        long maxLinger;
        InternalCache cache;
        int timerCancelCount = 0;
        ResiliencePolicy<K, V> resiliencePolicy;

        Static() {
        }

        void configureStatic(final CacheConfiguration<K, V> c) {
            long _expiryMillis = c.getExpireAfterWriteMillis();
            this.maxLinger = _expiryMillis == Long.MAX_VALUE || _expiryMillis < 0L ? Long.MAX_VALUE : _expiryMillis;
            ResiliencePolicy.Context ctx = new ResiliencePolicy.Context(){

                @Override
                public long getExpireAfterWriteMillis() {
                    return c.getExpireAfterWriteMillis();
                }

                @Override
                public long getResilienceDurationMillis() {
                    return c.isSuppressExceptions() ? c.getResilienceDurationMillis() : 0L;
                }

                @Override
                public long getRetryIntervalMillis() {
                    return c.getRetryIntervalMillis();
                }

                @Override
                public long getMaxRetryIntervalMillis() {
                    return c.getMaxRetryIntervalMillis();
                }
            };
            this.resiliencePolicy = c.getResiliencePolicy();
            if (this.resiliencePolicy == null) {
                this.resiliencePolicy = new DefaultResiliencePolicy();
            }
            this.resiliencePolicy.init(ctx);
            this.refreshAhead = c.isRefreshAhead();
            this.sharpExpiry = c.isSharpExpiry();
        }

        @Override
        public synchronized void init(InternalCache<K, V> c) {
            if (this.cache == null) {
                this.cache = c;
            }
        }

        @Override
        public synchronized void reset() {
            this.shutdown();
            if (this.timer == null) {
                this.timer = new Timer(this.cache.getName(), true);
            }
        }

        @Override
        public synchronized void shutdown() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return Static.calcNextRefreshTime(e.getKey(), v, _loadTime, e, null, this.maxLinger);
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, LoadExceptionInformation inf) {
            return this.resiliencePolicy.suppressExceptionUntil(e.getKey(), inf, e);
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, LoadExceptionInformation inf) {
            return this.resiliencePolicy.retryLoadAfter(e.getKey(), inf);
        }

        long eventuallyStartBackgroundRefresh(Entry e) {
            if (this.refreshAhead) {
                e.setTask(new RefreshTask(this.cache, e));
                this.scheduleTask(0L, e);
                return this.sharpExpiry ? 4L : 16L;
            }
            return 4L;
        }

        @Override
        public long stopStartTimer(long _nextRefreshTime, Entry e) {
            this.cancelExpiryTimer(e);
            if (_nextRefreshTime == 0L) {
                return 4L;
            }
            long now = System.currentTimeMillis();
            if ((_nextRefreshTime = Static.sanitizeTime(_nextRefreshTime, now)) > 0L && _nextRefreshTime < 32L || _nextRefreshTime == Long.MAX_VALUE) {
                if (_nextRefreshTime == 4L) {
                    return this.eventuallyStartBackgroundRefresh(e);
                }
                return _nextRefreshTime;
            }
            if (this.sharpExpiry && _nextRefreshTime > 32L) {
                _nextRefreshTime = -_nextRefreshTime;
            }
            if (_nextRefreshTime >= 32L || _nextRefreshTime < 0L) {
                if (_nextRefreshTime < -1L) {
                    long _timerTime = -_nextRefreshTime - SAFETY_GAP_MILLIS;
                    if (_timerTime >= now) {
                        e.setTask(new ExpireTask(this.cache, e));
                        this.scheduleTask(_timerTime, e);
                        _nextRefreshTime = -_nextRefreshTime;
                    } else {
                        this.scheduleFinalExpireWithOptionalRefresh(e, -_nextRefreshTime);
                    }
                } else if (this.refreshAhead) {
                    e.setTask(new RefreshTask(this.cache, e));
                    this.scheduleTask(_nextRefreshTime, e);
                } else {
                    e.setTask(new ExpireTask(this.cache, e));
                    this.scheduleTask(_nextRefreshTime, e);
                }
            }
            return _nextRefreshTime;
        }

        @Override
        public void scheduleFinalExpiryTimer(Entry<K, V> e) {
            this.cancelExpiryTimer(e);
            this.scheduleFinalExpireWithOptionalRefresh(e, e.nextRefreshTime);
        }

        void scheduleFinalExpireWithOptionalRefresh(Entry<K, V> e, long t) {
            e.setTask(new ExpireTask<K, V>(this.cache, e));
            this.scheduleTask(t, e);
            if (this.sharpExpiry && this.refreshAhead) {
                e.setTask(new RefreshTask<K, V>(this.cache, e));
                this.scheduleTask(t, e);
            }
        }

        void scheduleTask(long _nextRefreshTime, Entry e) {
            Timer _timer = this.timer;
            if (_timer != null) {
                try {
                    _timer.schedule(e.getTask(), new Date(_nextRefreshTime));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void cancelExpiryTimer(Entry<K, V> e) {
            if (e.cancelTimerTask()) {
                ++this.timerCancelCount;
                if (this.timerCancelCount >= PURGE_INTERVAL) {
                    this.timer.purge();
                    this.timerCancelCount = 0;
                }
            }
        }
    }

    static class Immediate<K, V>
    extends TimingHandler<K, V> {
        Immediate() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return 0L;
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, LoadExceptionInformation inf) {
            return 0L;
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, LoadExceptionInformation inf) {
            return 0L;
        }
    }

    static class EternalImmediate<K, V>
    extends TimingHandler<K, V> {
        EternalImmediate() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return Long.MAX_VALUE;
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, LoadExceptionInformation inf) {
            return 0L;
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, LoadExceptionInformation inf) {
            return 0L;
        }
    }

    static class Eternal<K, V>
    extends TimingHandler<K, V> {
        Eternal() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return Long.MAX_VALUE;
        }

        @Override
        public long cacheExceptionUntil(Entry<K, V> e, LoadExceptionInformation inf) {
            return Long.MAX_VALUE;
        }

        @Override
        public long suppressExceptionUntil(Entry<K, V> e, LoadExceptionInformation inf) {
            return Long.MAX_VALUE;
        }
    }
}

