/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.security.SecureRandom;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.CacheMisconfigurationException;
import org.cache2k.configuration.CacheConfiguration;
import org.cache2k.core.AbstractCache;
import org.cache2k.core.CacheBaseInfo;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CacheIntegrityError;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.ClockProPlus64Cache;
import org.cache2k.core.ClockProPlusCache;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.ConcurrentEntryIterator;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.ExpiryCalculationException;
import org.cache2k.core.Hash;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.core.MapValueConverterProxy;
import org.cache2k.core.StandardCommonMetrics;
import org.cache2k.core.TimingHandler;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.operation.Specification;
import org.cache2k.core.threading.DefaultThreadFactoryProvider;
import org.cache2k.core.threading.Futures;
import org.cache2k.core.threading.ThreadFactoryProvider;
import org.cache2k.core.util.Log;
import org.cache2k.core.util.TunableConstants;
import org.cache2k.core.util.TunableFactory;
import org.cache2k.core.util.Util;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheLoader;
import org.cache2k.integration.CacheLoaderException;
import org.cache2k.integration.ExceptionPropagator;
import org.cache2k.integration.LoadCompletedListener;
import org.cache2k.integration.LoadExceptionInformation;
import org.cache2k.processor.CacheEntryProcessor;

public abstract class HeapCache<K, V>
extends AbstractCache<K, V> {
    static final LoadCompletedListener DUMMY_LOAD_COMPLETED_LISTENER = new LoadCompletedListener(){

        @Override
        public void loadCompleted() {
        }

        @Override
        public void loadException(Throwable _exception) {
        }
    };
    static final Random SEED_RANDOM = new Random(new SecureRandom().nextLong());
    static int cacheCnt = 0;
    protected static final Tunable TUNABLE = TunableFactory.get(Tunable.class);
    static final ExceptionPropagator DEFAULT_EXCEPTION_PROPAGATOR = new ExceptionPropagator(){

        public void propagateException(Object key, LoadExceptionInformation exceptionInformation) {
            long _expiry = exceptionInformation.getUntil();
            if (_expiry > 0L) {
                if (_expiry == Long.MAX_VALUE) {
                    throw new CacheLoaderException("(expiry=ETERNAL) " + exceptionInformation.getException(), exceptionInformation.getException());
                }
                throw new CacheLoaderException("(expiry=" + Util.formatMillis(_expiry) + ") " + exceptionInformation.getException(), exceptionInformation.getException());
            }
            throw new CacheLoaderException("propagate previous loader exception", exceptionInformation.getException());
        }
    };
    protected int hashSeed;
    HeapCacheListener<K, V> listener;
    protected long maxSize;
    protected String name;
    public CacheManagerImpl manager;
    protected AdvancedCacheLoader<K, V> loader;
    protected TimingHandler<K, V> timing;
    protected CacheBaseInfo info;
    protected long clearedTime;
    protected long startedTime;
    protected long touchedTime;
    protected long keyMutationCount;
    protected long putButExpiredCnt;
    protected long putNewEntryCnt;
    protected long removedCnt;
    protected long virginRemovedCnt;
    protected long clearedCnt;
    protected long clearCnt;
    protected long expiredKeptCnt;
    protected long expiredRemoveCnt;
    protected long evictedCnt;
    protected long refreshCnt;
    protected long suppressedExceptionCnt;
    protected long loadExceptionCnt;
    protected long peekHitNotFreshCnt;
    protected long peekMissCnt;
    protected long loadWoRefreshCnt;
    protected long loadButHitCnt;
    protected long fetchMillis;
    protected long refreshHitCnt;
    protected long newEntryCnt;
    protected long refreshSubmitFailedCnt;
    protected long internalExceptionCnt;
    CommonMetrics.Updater metrics;
    public final Object lock;
    protected volatile Executor loaderExecutor;
    public Hash<Entry<K, V>> mainHashCtrl;
    protected Entry<K, V>[] mainHash;
    protected Hash<Entry<K, V>> refreshHashCtrl;
    protected Entry<K, V>[] refreshHash;
    protected Futures.WaitForAllFuture<?> shutdownWaitFuture;
    public boolean shutdownInitiated;
    protected boolean evictionNeeded;
    protected Class keyType;
    protected Class valueType;
    protected ExceptionPropagator exceptionPropagator;
    private int featureBits;
    private static final int SHARP_EXPIRY_FEATURE = 1;
    private static final int KEEP_AFTER_EXPIRED = 2;
    private static final int SUPPRESS_EXCEPTIONS = 4;
    private static final int NULL_VALUE_SUPPORT = 8;
    private static final int BACKGROUND_REFRESH = 16;
    final Entry DUMMY_ENTRY_NO_REPLACE;
    static final byte INSERT_STAT_LOAD = 1;
    static final byte INSERT_STAT_PUT = 2;

    public HeapCache() {
        this.hashSeed = HeapCache.TUNABLE.disableHashRandomization ? HeapCache.TUNABLE.hashSeed : SEED_RANDOM.nextInt();
        this.listener = HeapCacheListener.NO_OPERATION;
        this.maxSize = 5000L;
        this.timing = TimingHandler.ETERNAL;
        this.clearedTime = 0L;
        this.keyMutationCount = 0L;
        this.putButExpiredCnt = 0L;
        this.putNewEntryCnt = 0L;
        this.removedCnt = 0L;
        this.virginRemovedCnt = 0L;
        this.clearedCnt = 0L;
        this.clearCnt = 0L;
        this.expiredKeptCnt = 0L;
        this.expiredRemoveCnt = 0L;
        this.evictedCnt = 0L;
        this.refreshCnt = 0L;
        this.suppressedExceptionCnt = 0L;
        this.loadExceptionCnt = 0L;
        this.peekHitNotFreshCnt = 0L;
        this.peekMissCnt = 0L;
        this.loadWoRefreshCnt = 0L;
        this.loadButHitCnt = 0L;
        this.fetchMillis = 0L;
        this.refreshHitCnt = 0L;
        this.newEntryCnt = 0L;
        this.refreshSubmitFailedCnt = 0L;
        this.internalExceptionCnt = 0L;
        this.metrics = new StandardCommonMetrics();
        this.lock = new Object();
        this.loaderExecutor = new DummyExecutor(this);
        this.shutdownInitiated = true;
        this.evictionNeeded = false;
        this.exceptionPropagator = DEFAULT_EXCEPTION_PROPAGATOR;
        this.featureBits = 0;
        this.DUMMY_ENTRY_NO_REPLACE = new Entry();
    }

    protected final boolean hasSharpTimeout() {
        return (this.featureBits & 1) > 0;
    }

    protected final boolean hasKeepAfterExpired() {
        return (this.featureBits & 2) > 0;
    }

    protected final boolean hasNullValueSupport() {
        return (this.featureBits & 8) > 0;
    }

    protected final boolean hasSuppressExceptions() {
        return (this.featureBits & 4) > 0;
    }

    protected final boolean hasBackgroundRefresh() {
        return (this.featureBits & 0x10) > 0;
    }

    protected final void setFeatureBit(int _bitmask, boolean _flag) {
        this.featureBits = _flag ? (this.featureBits |= _bitmask) : (this.featureBits &= ~_bitmask);
    }

    public String getCompleteName() {
        if (this.manager != null) {
            return this.manager.getName() + ":" + this.name;
        }
        return this.name;
    }

    @Override
    public Log getLog() {
        return Log.getLog(Cache.class.getName() + '/' + this.getCompleteName());
    }

    public void setCacheConfig(CacheConfiguration c) {
        this.valueType = c.getValueType().getType();
        this.keyType = c.getKeyType().getType();
        if (this.name != null) {
            throw new IllegalStateException("already configured");
        }
        this.setName(c.getName());
        this.maxSize = c.getEntryCapacity();
        if (c.getHeapEntryCapacity() >= 0) {
            this.maxSize = c.getHeapEntryCapacity();
        }
        if (c.isRefreshAhead()) {
            this.setFeatureBit(16, true);
        }
        if (c.getLoaderThreadCount() > 0) {
            this.loaderExecutor = this.provideDefaultLoaderExecutor(c.getLoaderThreadCount());
        }
        this.setFeatureBit(2, c.isKeepDataAfterExpired());
        this.setFeatureBit(1, c.isSharpExpiry());
        this.setFeatureBit(4, c.isSuppressExceptions());
    }

    String getThreadNamePrefix() {
        String _prefix = "cache2k-loader-";
        if (this.manager != null && !"default".equals(this.manager.getName())) {
            _prefix = _prefix + this.manager.getName() + ":";
        }
        return _prefix + this.name;
    }

    Executor provideDefaultLoaderExecutor(int _threadCount) {
        if (_threadCount <= 0) {
            _threadCount = Runtime.getRuntime().availableProcessors() * HeapCache.TUNABLE.loaderThreadCountCpuFactor;
        }
        return new ThreadPoolExecutor(_threadCount, _threadCount, 21L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), HeapCache.TUNABLE.threadFactoryProvider.newThreadFactory(this.getThreadNamePrefix()), new ThreadPoolExecutor.AbortPolicy());
    }

    public void setTiming(TimingHandler<K, V> rh) {
        this.timing = rh;
    }

    public void setExceptionPropagator(ExceptionPropagator ep) {
        this.exceptionPropagator = ep;
    }

    public void setLoader(final CacheLoader<K, V> l) {
        this.loader = new AdvancedCacheLoader<K, V>(){

            @Override
            public V load(K key, long currentTime, CacheEntry<K, V> previousEntry) throws Exception {
                return l.load(key);
            }
        };
    }

    public void setAdvancedLoader(AdvancedCacheLoader<K, V> al) {
        this.loader = al;
    }

    public void setName(String n) {
        if (n == null) {
            n = this.getClass().getSimpleName() + "#" + cacheCnt++;
        }
        this.name = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setCacheManager(CacheManagerImpl cm) {
        this.manager = cm;
    }

    @Override
    public Class<?> getKeyType() {
        return this.keyType;
    }

    @Override
    public Class<?> getValueType() {
        return this.valueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.lock;
        synchronized (object) {
            if (this.name == null) {
                this.name = String.valueOf(cacheCnt++);
            }
            this.timing.init(this);
            this.initializeHeapCache();
            if (this.hasBackgroundRefresh() && this.loader == null) {
                throw new CacheMisconfigurationException("backgroundRefresh, but no loader defined");
            }
            this.shutdownInitiated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShutdownWaitFuture(Future<?> f) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownWaitFuture == null || this.shutdownWaitFuture.isDone()) {
                this.shutdownWaitFuture = new Futures.WaitForAllFuture(f);
            } else {
                this.shutdownWaitFuture.add(f);
            }
        }
    }

    public void checkClosed() {
        if (this.isClosed()) {
            throw new CacheClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            this.clearLocalCache();
        }
    }

    public final void clearLocalCache() {
        this.iterateAllEntriesAndRemoveFromReplacementList();
        this.clearedCnt += (long)this.getLocalSize();
        ++this.clearCnt;
        this.initializeHeapCache();
        this.touchedTime = this.clearedTime = System.currentTimeMillis();
    }

    protected void iterateAllEntriesAndRemoveFromReplacementList() {
        ConcurrentEntryIterator<K, V> it = this.iterateAllHeapEntries();
        int _count = 0;
        while (it.hasNext()) {
            Entry e = (Entry)it.next();
            e.removedFromList();
            ++_count;
        }
    }

    protected void initializeHeapCache() {
        if (this.mainHashCtrl != null) {
            this.mainHashCtrl.cleared();
            this.refreshHashCtrl.cleared();
        }
        this.mainHashCtrl = new Hash();
        this.refreshHashCtrl = new Hash();
        this.mainHash = this.mainHashCtrl.init(this.newEntry().getClass());
        this.refreshHash = this.refreshHashCtrl.init(this.newEntry().getClass());
        if (this.startedTime == 0L) {
            this.startedTime = System.currentTimeMillis();
        }
        this.timing.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTimingStatistics() {
        Object object = this.lock;
        synchronized (object) {
            this.loadWoRefreshCnt = 0L;
            this.fetchMillis = 0L;
        }
    }

    @Override
    public void cancelTimerJobs() {
        this.timing.shutdown();
    }

    @Override
    public boolean isClosed() {
        return this.shutdownInitiated;
    }

    @Override
    public void destroy() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePart1() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownInitiated) {
                return;
            }
            this.shutdownInitiated = true;
        }
        if (this.loaderExecutor instanceof ExecutorService) {
            ((ExecutorService)this.loaderExecutor).shutdown();
        }
        this.cancelTimerJobs();
        object = this.lock;
        synchronized (object) {
            this.mainHashCtrl.close();
            this.refreshHashCtrl.close();
        }
        try {
            Futures.WaitForAllFuture<?> _future = this.shutdownWaitFuture;
            if (_future != null) {
                _future.get();
            }
        }
        catch (Exception ex) {
            throw new CacheException(ex);
        }
    }

    @Override
    public void close() {
        this.closePart1();
        this.closePart2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePart2() {
        Object object = this.lock;
        synchronized (object) {
            this.timing.shutdown();
            this.refreshHash = null;
            this.mainHash = null;
            if (this.manager != null) {
                this.manager.cacheDestroyed(this);
                this.manager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        Object object = this.lock;
        synchronized (object) {
            return new IteratorFilterEntry2Entry(this, this.iterateAllHeapEntries(), true);
        }
    }

    protected static void removeFromList(Entry e) {
        e.prev.next = e.next;
        e.next.prev = e.prev;
        e.removedFromList();
    }

    protected static void insertInList(Entry _head, Entry e) {
        e.prev = _head;
        e.next = _head.next;
        e.next.prev = e;
        _head.next = e;
    }

    protected static final int getListEntryCount(Entry _head) {
        Entry e = _head.next;
        int cnt = 0;
        while (e != _head) {
            ++cnt;
            if (e == null) {
                return -cnt;
            }
            e = e.next;
        }
        return cnt;
    }

    protected static final <E extends Entry> void moveToFront(E _head, E e) {
        HeapCache.removeFromList(e);
        HeapCache.insertInList(_head, e);
    }

    protected static final <E extends Entry> E insertIntoTailCyclicList(E _head, E e) {
        if (_head == null) {
            return (E)e.shortCircuit();
        }
        e.next = _head;
        e.prev = _head.prev;
        _head.prev = e;
        e.prev.next = e;
        return _head;
    }

    protected static final <E extends Entry> E insertAfterHeadCyclicList(E _head, E e) {
        if (_head == null) {
            return (E)e.shortCircuit();
        }
        e.prev = _head;
        e.next = _head.next;
        _head.next.prev = e;
        _head.next = e;
        return _head;
    }

    protected static final <E extends Entry> E insertIntoHeadCyclicList(E _head, E e) {
        if (_head == null) {
            return (E)e.shortCircuit();
        }
        e.next = _head;
        e.prev = _head.prev;
        _head.prev.next = e;
        _head.prev = e;
        return e;
    }

    protected static <E extends Entry> E removeFromCyclicList(E _head, E e) {
        Entry _eNext;
        if (e.next == e) {
            e.removedFromList();
            return null;
        }
        e.prev.next = _eNext = e.next;
        e.next.prev = e.prev;
        e.removedFromList();
        return (E)(e == _head ? _eNext : _head);
    }

    protected static Entry removeFromCyclicList(Entry e) {
        Entry _eNext;
        e.prev.next = _eNext = e.next;
        e.next.prev = e.prev;
        e.removedFromList();
        return _eNext == e ? null : _eNext;
    }

    protected static int getCyclicListEntryCount(Entry e) {
        if (e == null) {
            return 0;
        }
        Entry _head = e;
        int cnt = 0;
        do {
            ++cnt;
            e = e.next;
            if (e != null) continue;
            return -cnt;
        } while (e != _head);
        return cnt;
    }

    protected static boolean checkCyclicListIntegrity(Entry e) {
        if (e == null) {
            return true;
        }
        Entry _head = e;
        do {
            if (e.next == null) {
                return false;
            }
            if (e.next.prev == null) {
                return false;
            }
            if (e.next.prev == e) continue;
            return false;
        } while ((e = e.next) != _head);
        return true;
    }

    protected abstract void recordHit(Entry var1);

    protected abstract void insertIntoReplacementList(Entry var1);

    protected abstract Entry newEntry();

    protected abstract Entry findEvictionCandidate();

    protected void evictEntry(Entry e) {
        this.removeEntryFromReplacementList(e);
    }

    protected void removeEntryFromReplacementList(Entry e) {
        HeapCache.removeFromList(e);
    }

    protected Entry checkForGhost(K key, int hc) {
        return null;
    }

    protected Entry<K, V> lookupEntryUnsynchronized(K key, int hc) {
        return null;
    }

    protected Entry lookupEntryUnsynchronizedNoHitRecord(K key, int hc) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordHitLocked(Entry e) {
        Object object = this.lock;
        synchronized (object) {
            this.recordHit(e);
        }
    }

    @Override
    public V get(K key) {
        return this.returnValue(this.getEntryInternal(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry<K, V> returnEntry(Entry<K, V> e) {
        if (e == null) {
            return null;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            K _key = e.getKey();
            V _value = e.getValue();
            Throwable _exception = e.getException();
            long _lastModification = e.getLastModification();
            return this.returnCacheEntry(_key, _value, _exception, _lastModification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEntryState(K key) {
        Entry<K, V> e = this.lookupEntrySynchronized(key);
        if (e == null) {
            return null;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            return e.toString(this);
        }
    }

    private CacheEntry<K, V> returnCacheEntry(final K _key, final V _value, final Throwable _exception, final long _lastModification) {
        CacheEntry ce = new CacheEntry<K, V>(){

            @Override
            public K getKey() {
                return _key;
            }

            @Override
            public V getValue() {
                return _value;
            }

            @Override
            public Throwable getException() {
                return _exception;
            }

            @Override
            public long getLastModification() {
                return _lastModification;
            }

            public String toString() {
                return "CacheEntry(key=" + this.getKey() + (this.getException() != null ? ", exception=" + this.getException() + ", " : ", value=" + this.getValue()) + ", updated=" + Util.formatMillis(this.getLastModification());
            }
        };
        return ce;
    }

    @Override
    public CacheEntry<K, V> getEntry(K key) {
        return this.returnEntry(this.getEntryInternal(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Entry getEntryInternal(K key) {
        Entry<K, V> e;
        while (true) {
            if ((e = this.lookupOrNewEntrySynchronized(key)).hasFreshData()) {
                return e;
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (e.hasFreshData()) {
                    return e;
                }
                if (!e.isGone()) break;
            }
        }
        {
            e.startProcessing();
        }
        boolean _finished = false;
        try {
            this.finishFetch(e, this.load(e));
            _finished = true;
        }
        finally {
            e.ensureAbort(_finished);
        }
        this.evictEventually();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishFetch(Entry e, long _nextRefreshTime) {
        Entry entry = e;
        synchronized (entry) {
            e.notifyAll();
            e.processingDone();
            this.restartTimer(e, _nextRefreshTime);
        }
    }

    private void restartTimer(Entry e, long _nextRefreshTime) {
        e.nextRefreshTime = this.timing.stopStartTimer(_nextRefreshTime, e);
        this.checkForImmediateExpiry(e);
    }

    private void checkForImmediateExpiry(Entry e) {
        if (e.isExpired()) {
            this.doExpireEntry(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void evictEventually() {
        int _spinCount = HeapCache.TUNABLE.maximumEvictSpins;
        Entry _previousCandidate = null;
        while (this.evictionNeeded) {
            Entry e;
            if (_spinCount-- <= 0) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                if ((long)this.getLocalSize() <= this.maxSize) {
                    this.evictionNeeded = false;
                    return;
                }
                e = this.findEvictionCandidate();
            }
            object = e;
            synchronized (object) {
                if (e.isGone()) {
                    continue;
                }
                if (e.isProcessing()) {
                    if (e != _previousCandidate) {
                        _previousCandidate = e;
                        continue;
                    }
                    return;
                }
                e.startProcessing(Entry.ProcessingState.EVICT);
            }
            this.listener.onEvictionFromHeap(e);
            object = e;
            synchronized (object) {
                this.finishFetch(e, 8L);
                this.evictEntryFromHeap(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictEntryFromHeap(Entry e) {
        Object object = this.lock;
        synchronized (object) {
            if (e.isRemovedFromReplacementList()) {
                if (this.removeEntryFromHash(e)) {
                    ++this.evictedCnt;
                }
            } else {
                this.evictEntry(e);
                if (this.removeEntryFromHash(e)) {
                    ++this.evictedCnt;
                }
            }
            this.evictionNeeded = (long)this.getLocalSize() > this.maxSize;
        }
    }

    protected boolean removeEntry(Entry e) {
        if (e.isRemovedFromReplacementList()) {
            return this.removeEntryFromHash(e);
        }
        this.removeEntryFromReplacementList(e);
        return this.removeEntryFromHash(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public V peekAndPut(K key, V _value) {
        Entry<K, V> e;
        int hc = this.modifiedHash(key.hashCode());
        V _previousValue = null;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntrySynchronized(key, hc);
            // MONITORENTER : entry
            e.waitForProcessing();
            if (!e.isGone()) break;
            // MONITOREXIT : entry
        }
        boolean _hasFreshData = e.hasFreshData();
        if (_hasFreshData) {
            _previousValue = e.getValueOrException();
            this.metrics.heapHitButNoRead();
        } else {
            ++this.peekMissCnt;
        }
        this.putValue(e, _value);
        // MONITOREXIT : entry
        if (!_hasFreshData) return this.returnValue(_previousValue);
        this.recordHitLocked(e);
        return this.returnValue(_previousValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V peekAndReplace(K key, V _value) {
        Object object;
        Entry<K, V> e;
        while ((e = this.lookupEntrySynchronized(key)) != null) {
            object = e;
            synchronized (object) {
                e.waitForProcessing();
                if (e.isGone()) {
                    continue;
                }
                if (e.hasFreshData()) {
                    V _previousValue = e.getValueOrException();
                    this.putValue(e, _value);
                    return this.returnValue(_previousValue);
                }
                break;
            }
        }
        object = this.lock;
        synchronized (object) {
            ++this.peekMissCnt;
        }
        return null;
    }

    private void putValue(Entry e, V _value) {
        long t = System.currentTimeMillis();
        long _newNrt = this.insertOnPut(e, _value, t, t);
        this.restartTimer(e, _newNrt);
    }

    @Override
    public boolean replace(K key, V _newValue) {
        return this.replace(key, false, null, _newValue) == null;
    }

    @Override
    public boolean replaceIfEquals(K key, V _oldValue, V _newValue) {
        return this.replace(key, true, _oldValue, _newValue) == null;
    }

    @Override
    public CacheEntry<K, V> replaceOrGet(K key, V _oldValue, V _newValue, CacheEntry<K, V> _dummyEntry) {
        Entry<K, V> e = this.replace(key, true, _oldValue, _newValue);
        if (e == this.DUMMY_ENTRY_NO_REPLACE) {
            return _dummyEntry;
        }
        if (e != null) {
            return this.returnEntry(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry<K, V> replace(K key, boolean _compare, V _oldValue, V _newValue) {
        Entry<K, V> e = this.lookupEntrySynchronized(key);
        if (e == null) {
            Object object = this.lock;
            synchronized (object) {
                ++this.peekMissCnt;
            }
            return this.DUMMY_ENTRY_NO_REPLACE;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone() || !e.hasFreshData()) {
                return this.DUMMY_ENTRY_NO_REPLACE;
            }
            if (_compare && !e.equalsValue(_oldValue)) {
                return e;
            }
            this.putValue(e, _newValue);
        }
        return null;
    }

    protected final Entry<K, V> peekEntryInternal(K key) {
        Entry<K, V> e = this.lookupEntrySynchronized(key);
        if (e == null) {
            ++this.peekMissCnt;
            return null;
        }
        if (e.hasFreshData()) {
            return e;
        }
        ++this.peekHitNotFreshCnt;
        return null;
    }

    @Override
    public boolean contains(K key) {
        Entry<K, V> e = this.lookupEntrySynchronized(key);
        if (e != null) {
            this.metrics.containsButHit();
            if (e.hasFreshData()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public V peek(K key) {
        Entry<K, V> e = this.peekEntryInternal(key);
        if (e != null) {
            return this.returnValue(e);
        }
        return null;
    }

    @Override
    public CacheEntry<K, V> peekEntry(K key) {
        return this.returnEntry(this.peekEntryInternal(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean putIfAbsent(K key, V value) {
        Entry<K, V> e;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntrySynchronized(key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
            }
        }
        {
            if (e.hasFreshData()) {
                return false;
            }
            ++this.peekMissCnt;
            this.putValue(e, value);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(K key, V value) {
        Entry<K, V> e;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntrySynchronized(key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
            }
        }
        {
            if (!e.isVirgin()) {
                this.metrics.heapHitButNoRead();
            }
            this.putValue(e, value);
        }
        this.evictEventually();
    }

    @Override
    public boolean removeIfEquals(K key, V _value) {
        return this.removeWithFlag(key, true, _value);
    }

    @Override
    public boolean containsAndRemove(K key) {
        return this.removeWithFlag(key, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWithFlag(K key, boolean _checkValue, V _value) {
        Entry e = this.lookupEntrySynchronizedNoHitRecord(key);
        if (e == null) {
            return false;
        }
        Entry entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone()) {
                return false;
            }
            boolean f = e.hasFreshData();
            if (!(!_checkValue || f && e.equalsValue(_value))) {
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.removeEntry(e)) {
                    ++this.removedCnt;
                    this.metrics.remove();
                }
                return f;
            }
        }
    }

    @Override
    public void remove(K key) {
        this.containsAndRemove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V peekAndRemove(K key) {
        Entry<K, V> e = this.lookupEntrySynchronized(key);
        if (e == null) {
            Object object = this.lock;
            synchronized (object) {
                ++this.peekMissCnt;
            }
            return null;
        }
        Entry<K, V> entry = e;
        synchronized (entry) {
            e.waitForProcessing();
            if (e.isGone()) {
                Object object = this.lock;
                synchronized (object) {
                    ++this.peekMissCnt;
                }
                return null;
            }
            Object object = this.lock;
            synchronized (object) {
                V _value = null;
                boolean f = e.hasFreshData();
                if (f) {
                    _value = e.getValueOrException();
                    this.recordHit(e);
                } else {
                    ++this.peekMissCnt;
                }
                if (this.removeEntry(e)) {
                    ++this.removedCnt;
                    this.metrics.remove();
                }
                return this.returnValue(_value);
            }
        }
    }

    boolean isLoaderThreadAvailableForPrefetching() {
        Executor _loaderExecutor = this.loaderExecutor;
        if (_loaderExecutor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor ex = (ThreadPoolExecutor)_loaderExecutor;
            return ex.getQueue().size() == 0;
        }
        return _loaderExecutor instanceof DummyExecutor;
    }

    @Override
    public void prefetch(final K key) {
        if (this.loader == null) {
            return;
        }
        Entry e = this.lookupEntrySynchronizedNoHitRecord(key);
        if (e != null && e.hasFreshData()) {
            return;
        }
        if (this.isLoaderThreadAvailableForPrefetching()) {
            this.loaderExecutor.execute(new RunWithCatch(this){

                @Override
                public void action() {
                    HeapCache.this.get(key);
                }
            });
        }
    }

    @Override
    public void prefetchAll(Iterable<? extends K> _keys) {
        if (this.loader == null) {
            return;
        }
        Set<K> _keysToLoad = this.checkAllPresent(_keys);
        Iterator<K> iterator = _keysToLoad.iterator();
        while (iterator.hasNext()) {
            K k;
            final K key = k = iterator.next();
            if (!this.isLoaderThreadAvailableForPrefetching()) {
                return;
            }
            RunWithCatch r = new RunWithCatch(this){

                @Override
                public void action() {
                    HeapCache.this.getEntryInternal(key);
                }
            };
            this.loaderExecutor.execute(r);
        }
    }

    @Override
    public void loadAll(Iterable<? extends K> _keys, LoadCompletedListener l) {
        this.checkLoaderPresent();
        final LoadCompletedListener _listener = l != null ? l : DUMMY_LOAD_COMPLETED_LISTENER;
        Set<K> _keysToLoad = this.checkAllPresent(_keys);
        if (_keysToLoad.isEmpty()) {
            _listener.loadCompleted();
            return;
        }
        final AtomicInteger _countDown = new AtomicInteger(_keysToLoad.size());
        Iterator<K> iterator = _keysToLoad.iterator();
        while (iterator.hasNext()) {
            K k;
            final K key = k = iterator.next();
            RunWithCatch r = new RunWithCatch(this){

                @Override
                public void action() {
                    try {
                        HeapCache.this.getEntryInternal(key);
                    }
                    finally {
                        if (_countDown.decrementAndGet() == 0) {
                            _listener.loadCompleted();
                        }
                    }
                }
            };
            this.loaderExecutor.execute(r);
        }
    }

    @Override
    public void reloadAll(Iterable<? extends K> _keys, LoadCompletedListener l) {
        this.checkLoaderPresent();
        final LoadCompletedListener _listener = l != null ? l : DUMMY_LOAD_COMPLETED_LISTENER;
        Set<K> _keySet = this.generateKeySet(_keys);
        final AtomicInteger _countDown = new AtomicInteger(_keySet.size());
        Iterator<K> iterator = _keySet.iterator();
        while (iterator.hasNext()) {
            K k;
            final K key = k = iterator.next();
            RunWithCatch r = new RunWithCatch(this){

                @Override
                public void action() {
                    try {
                        HeapCache.this.loadAndReplace(key);
                    }
                    finally {
                        if (_countDown.decrementAndGet() == 0) {
                            _listener.loadCompleted();
                        }
                    }
                }
            };
            this.loaderExecutor.execute(r);
        }
    }

    public Set<K> generateKeySet(Iterable<? extends K> _keys) {
        HashSet<K> _keySet = new HashSet<K>();
        for (K k : _keys) {
            _keySet.add(k);
        }
        return _keySet;
    }

    public Set<K> checkAllPresent(Iterable<? extends K> keys) {
        HashSet<K> _keysToLoad = new HashSet<K>();
        for (K k : keys) {
            Entry e = this.lookupEntrySynchronizedNoHitRecord(k);
            if (e != null && e.hasFreshData()) continue;
            _keysToLoad.add(k);
        }
        return _keysToLoad;
    }

    public Entry<K, V> lookupEntryUnsynchronized(K k) {
        return this.lookupEntryUnsynchronized(k, this.modifiedHash(k.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadAndReplace(K key) {
        Entry<K, V> e;
        while (true) {
            Entry<K, V> entry = e = this.lookupOrNewEntrySynchronized(key);
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) break;
            }
        }
        {
            e.startProcessing();
        }
        boolean _finished = false;
        try {
            this.finishFetch(e, this.load(e));
            _finished = true;
        }
        finally {
            e.ensureAbort(_finished);
        }
        this.evictEventually();
    }

    protected Entry<K, V> lookupOrNewEntrySynchronized(K key) {
        int hc = this.modifiedHash(key.hashCode());
        return this.lookupOrNewEntrySynchronized(key, hc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry<K, V> lookupOrNewEntrySynchronized(K key, int hc) {
        Entry<K, V> e = this.lookupEntryUnsynchronized(key, hc);
        if (e == null) {
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                e = this.lookupEntry(key, hc);
                if (e == null) {
                    e = this.newEntry(key, hc);
                }
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry<K, V> lookupOrNewEntrySynchronizedNoHitRecord(K key) {
        int hc = this.modifiedHash(key.hashCode());
        Entry<K, V> e = this.lookupEntryUnsynchronizedNoHitRecord(key, hc);
        if (e == null) {
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                e = this.lookupEntryNoHitRecord(key, hc);
                if (e == null) {
                    e = this.newEntry(key, hc);
                }
            }
        }
        return e;
    }

    protected V returnValue(V v) {
        if (v instanceof ExceptionWrapper) {
            ExceptionWrapper w = (ExceptionWrapper)v;
            this.exceptionPropagator.propagateException(w.getKey(), w);
        }
        return v;
    }

    protected V returnValue(Entry<K, V> e) {
        Object v = e.value;
        if (v instanceof ExceptionWrapper) {
            ExceptionWrapper w = (ExceptionWrapper)v;
            this.exceptionPropagator.propagateException(w.getKey(), w);
        }
        return (V)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry<K, V> lookupEntrySynchronized(K key) {
        int hc = this.modifiedHash(key.hashCode());
        Entry<K, V> e = this.lookupEntryUnsynchronized(key, hc);
        if (e == null) {
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                e = this.lookupEntry(key, hc);
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry lookupEntrySynchronizedNoHitRecord(K key) {
        int hc = this.modifiedHash(key.hashCode());
        Entry e = this.lookupEntryUnsynchronizedNoHitRecord(key, hc);
        if (e == null) {
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                e = this.lookupEntryNoHitRecord(key, hc);
            }
        }
        return e;
    }

    protected final Entry<K, V> lookupEntry(K key, int hc) {
        Entry e = Hash.lookup((Entry[])this.mainHash, key, (int)hc);
        if (e != null) {
            this.recordHit(e);
            return e;
        }
        e = this.refreshHashCtrl.remove(this.refreshHash, key, hc);
        if (e != null) {
            ++this.refreshHitCnt;
            this.mainHash = this.mainHashCtrl.insert(this.mainHash, e);
            this.recordHit(e);
            return e;
        }
        return null;
    }

    protected final Entry lookupEntryNoHitRecord(K key, int hc) {
        Entry e = Hash.lookup((Entry[])this.mainHash, key, (int)hc);
        if (e != null) {
            return e;
        }
        e = this.refreshHashCtrl.remove(this.refreshHash, key, hc);
        if (e != null) {
            ++this.refreshHitCnt;
            this.mainHash = this.mainHashCtrl.insert(this.mainHash, e);
            return e;
        }
        return null;
    }

    protected Entry<K, V> newEntry(K key, int hc) {
        Entry e;
        if ((long)this.getLocalSize() >= this.maxSize) {
            this.evictionNeeded = true;
        }
        if ((e = this.checkForGhost(key, hc)) == null) {
            e = this.newEntry();
            e.key = key;
            e.hashCode = hc;
            this.insertIntoReplacementList(e);
        }
        this.mainHash = this.mainHashCtrl.insert(this.mainHash, e);
        ++this.newEntryCnt;
        return e;
    }

    private boolean removeEntryFromHash(Entry<K, V> e) {
        boolean f = this.mainHashCtrl.remove(this.mainHash, e) || this.refreshHashCtrl.remove(this.refreshHash, e);
        this.checkForHashCodeChange(e);
        this.timing.cancelExpiryTimer(e);
        e.setGone();
        return f;
    }

    private void checkForHashCodeChange(Entry<K, V> e) {
        if (this.modifiedHash(e.key.hashCode()) != e.hashCode) {
            if (this.keyMutationCount == 0L) {
                this.getLog().warn("Key mismatch! Key hashcode changed! keyClass=" + e.key.getClass().getName());
                try {
                    String s = e.key.toString();
                    if (s != null) {
                        this.getLog().warn("Key mismatch! key.toString(): " + s);
                    }
                }
                catch (Throwable t) {
                    this.getLog().warn("Key mismatch! key.toString() threw exception", t);
                }
            }
            ++this.keyMutationCount;
        }
    }

    protected long load(Entry<K, V> e) {
        V v;
        long t0 = System.currentTimeMillis();
        try {
            this.checkLoaderPresent();
            v = e.isVirgin() ? this.loader.load(e.key, t0, null) : this.loader.load(e.key, t0, e);
            e.setLastModification(t0);
        }
        catch (Throwable _ouch) {
            long t = System.currentTimeMillis();
            return this.loadGotException(e, new ExceptionWrapper(e.key, _ouch, t0, e), t0, t);
        }
        long t = System.currentTimeMillis();
        return this.insertOrUpdateAndCalculateExpiry(e, v, t0, t, (byte)1);
    }

    protected long loadGotException(Entry<K, V> e, ExceptionWrapper<K> _value, long t0, long t) {
        long _nextRefreshTime = 0L;
        boolean _suppressException = false;
        try {
            if ((e.isDataValid() || e.isExpired()) && e.getException() == null) {
                _nextRefreshTime = this.timing.suppressExceptionUntil(e, _value);
            }
            if (_nextRefreshTime > t0) {
                _suppressException = true;
            } else {
                _nextRefreshTime = this.timing.cacheExceptionUntil(e, _value);
            }
        }
        catch (Exception ex) {
            try {
                this.updateStatistics(e, _value, t0, t, (byte)1, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ExpiryCalculationException(ex);
        }
        if (_suppressException) {
            e.setSuppressedLoadExceptionInformation(_value);
        } else {
            e.value = _value;
        }
        _value.until = Math.abs(_nextRefreshTime);
        _value.until = Math.abs(_nextRefreshTime);
        return this.insertUpdateStats(e, _value, t0, t, (byte)1, _nextRefreshTime, _suppressException);
    }

    private void checkLoaderPresent() {
        if (this.loader == null) {
            throw new UnsupportedOperationException("loader not set");
        }
    }

    protected final long insertOnPut(Entry<K, V> e, V v, long t0, long t) {
        e.setLastModification(t0);
        return this.insertOrUpdateAndCalculateExpiry(e, v, t0, t, (byte)2);
    }

    protected final long insertOrUpdateAndCalculateExpiry(Entry<K, V> e, V v, long t0, long t, byte _updateStatistics) {
        long _nextRefreshTime;
        try {
            _nextRefreshTime = this.timing.calculateNextRefreshTime(e, v, t0);
        }
        catch (Exception ex) {
            try {
                this.updateStatistics(e, v, t0, t, _updateStatistics, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new CacheException("exception in expiry calculation", ex);
        }
        return this.insert(e, v, t0, t, _updateStatistics, _nextRefreshTime);
    }

    protected final long insert(Entry<K, V> e, V _value, long t0, long t, byte _updateStatistics, long _nextRefreshTime) {
        e.value = _value;
        e.resetSuppressedLoadExceptionInformation();
        return this.insertUpdateStats(e, _value, t0, t, _updateStatistics, _nextRefreshTime, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long insertUpdateStats(Entry<K, V> e, V _value, long t0, long t, byte _updateStatistics, long _nextRefreshTime, boolean _suppressException) {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            this.updateStatisticsNeedsLock(e, _value, t0, t, _updateStatistics, _suppressException);
            if (_updateStatistics == 2 && !e.hasFreshData(t, _nextRefreshTime)) {
                ++this.putButExpiredCnt;
            }
        }
        return _nextRefreshTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatistics(Entry e, V _value, long t0, long t, byte _updateStatistics, boolean _suppressException) {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            this.updateStatisticsNeedsLock(e, _value, t0, t, _updateStatistics, _suppressException);
        }
    }

    private void updateStatisticsNeedsLock(Entry e, V _value, long t0, long t, byte _updateStatistics, boolean _suppressException) {
        this.touchedTime = t;
        if (_updateStatistics == 1) {
            if (_suppressException) {
                ++this.suppressedExceptionCnt;
                ++this.loadExceptionCnt;
            } else if (_value instanceof ExceptionWrapper) {
                ++this.loadExceptionCnt;
            }
            this.fetchMillis += t - t0;
            if (e.isGettingRefresh()) {
                ++this.refreshCnt;
            } else {
                ++this.loadWoRefreshCnt;
                if (!e.isVirgin()) {
                    ++this.loadButHitCnt;
                }
            }
        } else if (_updateStatistics == 2) {
            this.metrics.putNewEntry();
            this.eventuallyAdjustPutNewEntryCount(e);
        }
    }

    private void eventuallyAdjustPutNewEntryCount(Entry e) {
        if (e.isVirgin()) {
            ++this.putNewEntryCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveToRefreshHash(Entry e) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return false;
            }
            if (this.mainHashCtrl.remove(this.mainHash, e)) {
                this.refreshHash = this.refreshHashCtrl.insert(this.refreshHash, e);
                if (e.hashCode != this.modifiedHash(e.key.hashCode())) {
                    if (this.removeEntryFromHash(e)) {
                        ++this.expiredRemoveCnt;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventRefresh(final Entry<K, V> e) {
        this.metrics.timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.isGone()) {
                return;
            }
            if (this.moveToRefreshHash(e)) {
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Entry entry = e;
                        synchronized (entry) {
                            e.waitForProcessing();
                            if (e.isGone()) {
                                return;
                            }
                            e.startProcessing(Entry.ProcessingState.REFRESH);
                        }
                        try {
                            HeapCache.this.finishFetch(e, HeapCache.this.load(e));
                        }
                        catch (CacheClosedException cacheClosedException) {
                        }
                        catch (Throwable ex) {
                            e.ensureAbort(false);
                            Object object = HeapCache.this.lock;
                            synchronized (object) {
                                ++HeapCache.this.internalExceptionCnt;
                            }
                            HeapCache.this.getLog().warn("Refresh exception", ex);
                            try {
                                object = e;
                                synchronized (object) {
                                    HeapCache.this.expireEntry(e);
                                }
                            }
                            catch (CacheClosedException cacheClosedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                try {
                    this.loaderExecutor.execute(r);
                    return;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    ++this.refreshSubmitFailedCnt;
                }
            }
            this.expireOrScheduleFinalExpireEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventExpireEntry(Entry<K, V> e) {
        this.metrics.timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.expireOrScheduleFinalExpireEvent(e);
        }
    }

    @Override
    public void expireOrScheduleFinalExpireEvent(Entry<K, V> e) {
        long nrt = e.nextRefreshTime;
        if (nrt >= 0L && nrt < 16L) {
            return;
        }
        long t = System.currentTimeMillis();
        if (t >= Math.abs(nrt)) {
            try {
                this.expireEntry(e);
            }
            catch (CacheClosedException cacheClosedException) {}
        } else {
            if (nrt <= 0L) {
                return;
            }
            this.timing.scheduleFinalExpiryTimer(e);
            e.nextRefreshTime = -nrt;
        }
    }

    protected void expireEntry(Entry e) {
        if (e.isGone() || e.isExpired()) {
            return;
        }
        e.setExpiredState();
        this.doExpireEntry(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExpireEntry(Entry e) {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            if (this.hasKeepAfterExpired() || e.isProcessing()) {
                ++this.expiredKeptCnt;
            } else if (this.removeEntry(e)) {
                ++this.expiredRemoveCnt;
            }
        }
    }

    public final ConcurrentEntryIterator<K, V> iterateAllHeapEntries() {
        return new ConcurrentEntryIterator(this);
    }

    @Override
    public void removeAllAtOnce(Set<K> _keys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<K, V> getAll(Iterable<? extends K> _inputKeys) {
        final HashSet<K> _keys = new HashSet<K>();
        for (K k : _inputKeys) {
            Entry e = this.getEntryInternal(k);
            if (e == null) continue;
            _keys.add(k);
        }
        final AbstractSet set = new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<? extends K> keyIterator;
                    {
                        this.keyIterator = _keys.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Object key = this.keyIterator.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return key;
                            }

                            @Override
                            public V getValue() {
                                return HeapCache.this.get(key);
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return _keys.size();
            }
        };
        return new AbstractMap<K, V>(){

            @Override
            public V get(Object key) {
                if (this.containsKey(key)) {
                    return HeapCache.this.get(key);
                }
                return null;
            }

            @Override
            public boolean containsKey(Object key) {
                return _keys.contains(key);
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return set;
            }
        };
    }

    public Map<K, V> convertValueMap(Map<K, ExaminationEntry<K, V>> _map) {
        return new MapValueConverterProxy<K, V, ExaminationEntry<K, V>>(_map){

            @Override
            protected V convert(ExaminationEntry<K, V> v) {
                return HeapCache.this.returnValue(v.getValueOrException());
            }
        };
    }

    @Override
    public Map<K, V> peekAll(Iterable<? extends K> _inputKeys) {
        HashMap<K, Entry<K, V>> map = new HashMap<K, Entry<K, V>>();
        for (K k : _inputKeys) {
            Entry<K, V> e = this.peekEntryInternal(k);
            if (e == null) continue;
            map.put(k, e);
        }
        return this.convertValueMap(map);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> valueMap) {
        if (valueMap.containsKey(null)) {
            throw new NullPointerException("map contains null key");
        }
        for (Map.Entry<K, V> e : valueMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    Specification<K, V> spec() {
        return Specification.SINGLETON;
    }

    @Override
    protected <R> EntryAction<K, V, R> createEntryAction(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        return new EntryAction<K, V, R>(this, this, op, key, e){

            @Override
            protected TimingHandler<K, V> timing() {
                return HeapCache.this.timing;
            }
        };
    }

    @Override
    public <R> R invoke(K key, CacheEntryProcessor<K, V, R> entryProcessor, Object ... args) {
        return this.execute(key, this.spec().invoke(key, this.loader != null, entryProcessor, args));
    }

    public abstract long getHitCnt();

    protected final int calculateHashEntryCount() {
        return Hash.calcEntryCount(this.mainHash) + Hash.calcEntryCount(this.refreshHash);
    }

    public final int getLocalSize() {
        return this.mainHashCtrl.size + this.refreshHashCtrl.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getTotalEntryCount() {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            return this.getLocalSize();
        }
    }

    public long getExpiredCnt() {
        return this.expiredRemoveCnt + this.expiredKeptCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IntegrityState getIntegrityState() {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            return new IntegrityState().checkEquals("newEntryCnt == getSize() + evictedCnt + expiredRemoveCnt + removeCnt + clearedCnt + virginRemovedCnt", this.newEntryCnt, (long)this.getLocalSize() + this.evictedCnt + this.expiredRemoveCnt + this.removedCnt + this.clearedCnt + this.virginRemovedCnt).checkEquals("newEntryCnt == getSize() + evictedCnt + getExpiredCnt() - expiredKeptCnt + removeCnt + clearedCnt + virginRemovedCnt", this.newEntryCnt, (long)this.getLocalSize() + this.evictedCnt + this.getExpiredCnt() - this.expiredKeptCnt + this.removedCnt + this.clearedCnt + this.virginRemovedCnt).checkEquals("mainHashCtrl.size == Hash.calcEntryCount(mainHash)", this.mainHashCtrl.size, Hash.calcEntryCount(this.mainHash)).checkEquals("refreshHashCtrl.size == Hash.calcEntryCount(refreshHash)", this.refreshHashCtrl.size, Hash.calcEntryCount(this.refreshHash)).check("!!evictionNeeded | (getSize() <= maxSize)", this.evictionNeeded | (long)this.getLocalSize() <= this.maxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkIntegrity() {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            IntegrityState is = this.getIntegrityState();
            if (is.getStateFlags() > 0L) {
                throw new CacheIntegrityError(is.getStateDescriptor(), is.getFailingChecks(), this.toString());
            }
        }
    }

    @Override
    public final InternalCacheInfo getInfo() {
        return this.getInfo(this);
    }

    @Override
    public final InternalCacheInfo getLatestInfo() {
        return this.getLatestInfo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InternalCacheInfo getInfo(InternalCache _userCache) {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            long t = System.currentTimeMillis();
            if (this.info != null && this.info.creationTime + (long)(this.info.creationDeltaMs * HeapCache.TUNABLE.minimumStatisticsCreationTimeDeltaFactor) + (long)HeapCache.TUNABLE.minimumStatisticsCreationDeltaMillis > t) {
                return this.info;
            }
            this.info = this.generateInfo(_userCache, t);
        }
        return this.info;
    }

    public final InternalCacheInfo getLatestInfo(InternalCache _userCache) {
        return this.generateInfo(_userCache, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheBaseInfo generateInfo(InternalCache _userCache, long t) {
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            this.info = new CacheBaseInfo(this, _userCache);
            this.info.creationTime = t;
            this.info.creationDeltaMs = (int)(System.currentTimeMillis() - t);
            return this.info;
        }
    }

    protected String getExtraStatistics() {
        return "";
    }

    @Override
    public CacheManager getCacheManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return "Cache{" + this.name + "}(closed)";
            }
            InternalCacheInfo fo = this.getLatestInfo();
            return fo.toString();
        }
    }

    public final int modifiedHash(int h) {
        h ^= this.hashSeed;
        h ^= h >>> 7;
        h ^= h >>> 15;
        return h;
    }

    public static class Tunable
    extends TunableConstants {
        public Class<? extends InternalCache> defaultImplementation = "64".equals(System.getProperty("sun.arch.data.model")) ? ClockProPlus64Cache.class : ClockProPlusCache.class;
        public int maximumEntryLockSpins = 333333;
        public int maximumEvictSpins = 5;
        public int initialHashSize = 64;
        public int hashLoadPercent = 64;
        public boolean disableHashRandomization = false;
        public int hashSeed = 0;
        public long sharpExpirySafetyGapMillis = 27127L;
        public int minimumStatisticsCreationDeltaMillis = 333;
        public int minimumStatisticsCreationTimeDeltaFactor = 123;
        public ThreadFactoryProvider threadFactoryProvider = new DefaultThreadFactoryProvider();
        public int loaderThreadCountCpuFactor = 2;
    }

    public static abstract class RunWithCatch
    implements Runnable {
        InternalCache cache;

        public RunWithCatch(InternalCache _cache) {
            this.cache = _cache;
        }

        protected abstract void action();

        @Override
        public final void run() {
            if (this.cache.isClosed()) {
                return;
            }
            try {
                this.action();
            }
            catch (CacheClosedException cacheClosedException) {
            }
            catch (Throwable t) {
                this.cache.getLog().warn("Loader thread exception (" + Thread.currentThread().getName() + ")", t);
            }
        }
    }

    static class IteratorFilterEntry2Entry<K, V>
    implements Iterator<CacheEntry<K, V>> {
        HeapCache<K, V> cache;
        Iterator<Entry<K, V>> iterator;
        Entry entry;
        CacheEntry<K, V> lastEntry;
        boolean filter = true;

        IteratorFilterEntry2Entry(HeapCache<K, V> c, Iterator<Entry<K, V>> it, boolean _filter) {
            this.cache = c;
            this.iterator = it;
            this.filter = _filter;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            if (this.iterator == null) {
                return false;
            }
            this.cache.checkClosed();
            while (this.iterator.hasNext()) {
                Entry<K, V> e = this.iterator.next();
                if (this.filter) {
                    if (!e.hasFreshData()) continue;
                    this.entry = e;
                    return true;
                }
                this.entry = e;
                return true;
            }
            this.entry = null;
            return false;
        }

        @Override
        public CacheEntry<K, V> next() {
            if (this.entry == null && !this.hasNext()) {
                throw new NoSuchElementException("not available");
            }
            this.lastEntry = this.cache.returnEntry(this.entry);
            this.entry = null;
            return this.lastEntry;
        }

        @Override
        public void remove() {
            if (this.lastEntry == null) {
                throw new IllegalStateException("hasNext() / next() not called or end of iteration reached");
            }
            this.cache.remove(this.lastEntry.getKey());
        }
    }

    static class DummyExecutor
    implements Executor {
        HeapCache cache;

        public DummyExecutor(HeapCache _cache) {
            this.cache = _cache;
        }

        @Override
        public synchronized void execute(Runnable _command) {
            this.cache.loaderExecutor = this.cache.provideDefaultLoaderExecutor(0);
            this.cache.loaderExecutor.execute(_command);
        }
    }
}

