/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.CustomizationException;
import org.cache2k.core.CacheLockSpinsExceededError;
import org.cache2k.core.CacheUsageExcpetion;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.Entry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.ExpiryCalculationException;
import org.cache2k.core.HeapCache;
import org.cache2k.core.InternalCache;
import org.cache2k.core.StorageMetrics;
import org.cache2k.core.TimingHandler;
import org.cache2k.core.experimentalApi.AsyncCacheLoader;
import org.cache2k.core.experimentalApi.AsyncCacheWriter;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Progress;
import org.cache2k.core.operation.ReadOnlyCacheEntry;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.storageApi.StorageAdapter;
import org.cache2k.core.storageApi.StorageCallback;
import org.cache2k.core.storageApi.StorageEntry;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.CacheWriterException;

public abstract class EntryAction<K, V, R>
implements StorageCallback,
AsyncCacheLoader.Callback<V>,
AsyncCacheWriter.Callback,
Progress<V, R> {
    static final Entry NON_FRESH_DUMMY = new Entry();
    InternalCache<K, V> userCache;
    HeapCache<K, V> heapCache;
    K key;
    Semantic<K, V, R> operation;
    Entry<K, V> entry;
    V newValueOrException;
    V oldValueOrException;
    long previousModificationTime;
    R result;
    long lastModificationTime;
    long loadStartedTime;
    long loadCompletedTime;
    CustomizationException exceptionToPropagate;
    boolean remove;
    boolean expiredImmediately;
    long expiry = 0L;
    boolean entryLocked = false;
    boolean heapDataValid = false;
    boolean storageDataValid = false;
    boolean needsFinish = true;
    boolean storageRead = false;
    boolean storageMiss = false;
    boolean heapMiss = false;
    boolean wantData = false;
    boolean countMiss = false;
    boolean heapHit = false;
    boolean doNotCountAccess = false;
    boolean loadAndMutate = false;
    boolean load = false;
    boolean successfulLoad = false;
    boolean suppressException = false;

    public EntryAction(HeapCache<K, V> _heapCache, InternalCache<K, V> _userCache, Semantic<K, V, R> op, K k, Entry<K, V> e) {
        this.heapCache = _heapCache;
        this.userCache = _userCache;
        this.operation = op;
        this.key = k;
        this.entry = e != null ? e : NON_FRESH_DUMMY;
    }

    protected AdvancedCacheLoader<K, V> loader() {
        return this.heapCache.loader;
    }

    protected CommonMetrics.Updater metrics() {
        return this.heapCache.metrics;
    }

    protected StorageAdapter storage() {
        return null;
    }

    protected CacheWriter<K, V> writer() {
        return null;
    }

    protected boolean mightHaveListeners() {
        return false;
    }

    protected CacheEntryCreatedListener<K, V>[] entryCreatedListeners() {
        return null;
    }

    protected CacheEntryUpdatedListener<K, V>[] entryUpdatedListeners() {
        return null;
    }

    protected CacheEntryRemovedListener<K, V>[] entryRemovedListeners() {
        return null;
    }

    protected CacheEntryExpiredListener<K, V>[] entryExpiredListeners() {
        return null;
    }

    protected StorageMetrics.Updater storageMetrics() {
        return null;
    }

    protected abstract TimingHandler<K, V> timing();

    @Override
    public boolean isPresent() {
        this.doNotCountAccess = true;
        return this.successfulLoad || this.entry.hasFreshData();
    }

    @Override
    public boolean isPresentOrMiss() {
        if (this.successfulLoad || this.entry.hasFreshData()) {
            return true;
        }
        this.countMiss = true;
        return false;
    }

    @Override
    public void wantData() {
        this.wantData = true;
        if (this.storage() == null) {
            this.retrieveDataFromHeap();
            return;
        }
        this.lockEntryForStorageRead();
    }

    public void retrieveDataFromHeap() {
        Entry<K, V> e = this.entry;
        if (e == NON_FRESH_DUMMY && (e = this.heapCache.lookupEntrySynchronized(this.key)) == null) {
            this.heapMiss();
            return;
        }
        this.heapHit(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockEntryForStorageRead() {
        int _spinCount = HeapCache.TUNABLE.maximumEntryLockSpins;
        Entry<K, V> e = this.entry;
        boolean _needStorageRead = false;
        if (e == NON_FRESH_DUMMY) {
            e = this.heapCache.lookupOrNewEntrySynchronized(this.key);
        }
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) {
                    if (e.isVirgin()) {
                        _needStorageRead = true;
                        this.storageRead = true;
                        e.startProcessing(Entry.ProcessingState.READ);
                        this.entryLocked = true;
                        this.heapDataValid = e.isDataValid();
                    }
                    break;
                }
            }
            e = this.heapCache.lookupOrNewEntrySynchronized(this.key);
        }
        if (_needStorageRead) {
            this.entry = e;
            this.storageRead();
            return;
        }
        this.heapHit(e);
    }

    public void storageRead() {
        StorageEntry se;
        try {
            se = this.storage().get(this.entry.key);
        }
        catch (Throwable ex) {
            this.onReadFailure(ex);
            return;
        }
        this.onReadSuccess(se);
    }

    @Override
    public void onReadFailure(Throwable t) {
        this.examinationAbort(new StorageReadException(t));
    }

    @Override
    public void onReadSuccess(StorageEntry se) {
        if (se == null) {
            this.storageReadMiss();
            return;
        }
        this.storageReadHit(se);
    }

    public void storageReadMiss() {
        Entry<K, V> e = this.entry;
        e.nextRefreshTime = 5L;
        this.storageMiss = true;
        this.examine();
    }

    public void storageReadHit(StorageEntry se) {
        boolean _expired;
        Entry<K, V> e = this.entry;
        e.setLastModificationFromStorage(se.getCreatedOrUpdated());
        long now = System.currentTimeMillis();
        Object v = se.getValueOrException();
        e.value = v;
        long _expiryTimeFromStorage = se.getValueExpiryTime();
        boolean bl = _expired = _expiryTimeFromStorage != 0L && _expiryTimeFromStorage <= now;
        if (!_expired) {
            long _nextRefreshTime;
            this.expiry = _nextRefreshTime = this.timing().calculateNextRefreshTime(e, v, now);
            if (_nextRefreshTime == Long.MAX_VALUE) {
                e.nextRefreshTime = 16L;
                this.storageDataValid = true;
            } else if (_nextRefreshTime == 0L) {
                e.nextRefreshTime = 5L;
            } else {
                if (_nextRefreshTime < 0L) {
                    e.nextRefreshTime = _nextRefreshTime;
                    this.storageDataValid = true;
                }
                if (_nextRefreshTime <= now) {
                    e.nextRefreshTime = 5L;
                } else {
                    e.nextRefreshTime = -_nextRefreshTime;
                    this.storageDataValid = true;
                }
            }
        } else {
            e.nextRefreshTime = 5L;
        }
        e.nextProcessingStep(Entry.ProcessingState.READ_COMPLETE);
        this.examine();
    }

    public void heapMiss() {
        this.heapMiss = true;
        this.examine();
    }

    public void heapHit(Entry<K, V> e) {
        this.heapHit = true;
        this.entry = e;
        this.examine();
    }

    public void examine() {
        this.operation.examine(this, this.entry);
        if (this.needsFinish) {
            this.finish();
        }
    }

    @Override
    public void wantMutation() {
        if (!this.entryLocked && this.wantData) {
            this.lockFor(Entry.ProcessingState.MUTATE);
            this.countMiss = false;
            this.operation.examine(this, this.entry);
            if (this.needsFinish) {
                this.finish();
            }
            return;
        }
        this.operation.update(this, this.entry);
        if (this.needsFinish) {
            this.finish();
        }
    }

    public void finish() {
        this.needsFinish = false;
        this.noMutationRequested();
    }

    @Override
    public void loadAndMutation() {
        this.loadAndMutate = true;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        V v;
        AdvancedCacheLoader _loader;
        if (!this.entry.isVirgin() && !this.storageRead) {
            Object object = this.heapCache.lock;
            synchronized (object) {
                ++this.heapCache.loadButHitCnt;
            }
        }
        if ((_loader = this.loader()) == null) {
            this.exceptionToPropagate = new CustomizationException(new CacheUsageExcpetion("source not set"));
            return;
        }
        if (!this.entryLocked) {
            this.lockFor(Entry.ProcessingState.LOAD);
        } else {
            this.entry.nextProcessingStep(Entry.ProcessingState.LOAD);
        }
        this.needsFinish = false;
        this.load = true;
        Entry<K, V> e = this.entry;
        this.lastModificationTime = this.loadStartedTime = System.currentTimeMillis();
        long t0 = this.loadStartedTime;
        try {
            v = e.isVirgin() ? _loader.load(e.key, t0, null) : _loader.load(e.key, t0, e);
        }
        catch (Throwable _ouch) {
            this.onLoadFailure(_ouch);
            return;
        }
        this.onLoadSuccess(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockFor(Entry.ProcessingState ps) {
        if (this.entryLocked) {
            this.entry.nextProcessingStep(ps);
            return;
        }
        Entry<K, V> e = this.entry;
        if (e == NON_FRESH_DUMMY) {
            e = this.heapCache.lookupOrNewEntrySynchronized(this.key);
        }
        int _spinCount = HeapCache.TUNABLE.maximumEntryLockSpins;
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) {
                    e.startProcessing(ps);
                    this.entryLocked = true;
                    this.heapDataValid = e.isDataValid();
                    this.heapHit = !e.isVirgin();
                    this.entry = e;
                    return;
                }
            }
            e = this.heapCache.lookupOrNewEntrySynchronized(this.key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockForNoHit(Entry.ProcessingState ps) {
        if (this.entryLocked) {
            this.entry.nextProcessingStep(ps);
            return;
        }
        Entry<K, V> e = this.entry;
        if (e == NON_FRESH_DUMMY) {
            e = this.heapCache.lookupOrNewEntrySynchronizedNoHitRecord(this.key);
        }
        int _spinCount = HeapCache.TUNABLE.maximumEntryLockSpins;
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            Entry<K, V> entry = e;
            synchronized (entry) {
                e.waitForProcessing();
                if (!e.isGone()) {
                    e.startProcessing(ps);
                    this.entryLocked = true;
                    this.heapDataValid = e.isDataValid();
                    this.heapHit = !e.isVirgin();
                    this.entry = e;
                    return;
                }
            }
            e = this.heapCache.lookupOrNewEntrySynchronizedNoHitRecord(this.key);
        }
    }

    @Override
    public void onLoadSuccess(V value) {
        this.newValueOrException = value;
        this.loadCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoadFailure(Throwable t) {
        Object object = this.heapCache.lock;
        synchronized (object) {
            ++this.heapCache.loadExceptionCnt;
        }
        this.newValueOrException = new ExceptionWrapper<K>(this.key, t, this.loadStartedTime, this.entry);
        this.loadCompleted();
    }

    public void loadCompleted() {
        this.entry.nextProcessingStep(Entry.ProcessingState.LOAD_COMPLETE);
        this.loadCompletedTime = System.currentTimeMillis();
        this.mutationCalculateExpiry();
    }

    @Override
    public void result(R r) {
        this.result = r;
    }

    @Override
    public void put(V value) {
        this.lockFor(Entry.ProcessingState.MUTATE);
        this.needsFinish = false;
        this.newValueOrException = value;
        this.lastModificationTime = System.currentTimeMillis();
        this.mutationCalculateExpiry();
    }

    @Override
    public void remove() {
        this.lockForNoHit(Entry.ProcessingState.MUTATE);
        this.needsFinish = false;
        this.remove = true;
        this.lastModificationTime = System.currentTimeMillis();
        this.mutationMayCallWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationCalculateExpiry() {
        block12: {
            this.entry.nextProcessingStep(Entry.ProcessingState.EXPIRY);
            try {
                if (this.newValueOrException instanceof ExceptionWrapper) {
                    ExceptionWrapper ew = (ExceptionWrapper)this.newValueOrException;
                    if ((this.entry.isDataValid() || this.entry.isExpired()) && this.entry.getException() == null) {
                        this.expiry = this.timing().suppressExceptionUntil(this.entry, ew);
                    }
                    if (this.expiry > this.loadStartedTime) {
                        this.suppressException = true;
                        this.newValueOrException = this.entry.getValue();
                        this.lastModificationTime = this.entry.getLastModification();
                        Object object = this.heapCache.lock;
                        synchronized (object) {
                            ++this.heapCache.suppressedExceptionCnt;
                        }
                        this.entry.setSuppressedLoadExceptionInformation(ew);
                    } else {
                        this.expiry = this.timing().cacheExceptionUntil(this.entry, ew);
                    }
                    if (this.expiry < 0L) {
                        ew.until = -this.expiry;
                    } else if (this.expiry >= 32L) {
                        ew.until = this.expiry;
                    }
                    break block12;
                }
                this.expiry = this.timing().calculateNextRefreshTime(this.entry, this.newValueOrException, this.lastModificationTime);
                this.entry.resetSuppressedLoadExceptionInformation();
            }
            catch (Exception ex) {
                this.expiryCalculationException(ex);
                return;
            }
        }
        this.expiryCalculated();
    }

    public void expiryCalculationException(Throwable t) {
        this.mutationAbort(new ExpiryCalculationException(t));
    }

    public void expiryCalculated() {
        this.entry.nextProcessingStep(Entry.ProcessingState.EXPIRY_COMPLETE);
        if (this.load) {
            if (this.loadAndMutate) {
                this.loadAndExpiryCalculatedMutateAgain();
                return;
            }
            this.checkKeepOrRemove();
            return;
        }
        if (this.expiry > 0L) {
            if (this.entry.isVirgin()) {
                this.metrics().putNewEntry();
            } else if (!this.wantData) {
                this.metrics().putNoReadHit();
            } else {
                this.metrics().putHit();
            }
        }
        this.mutationMayCallWriter();
    }

    public void loadAndExpiryCalculatedMutateAgain() {
        this.loadAndMutate = false;
        this.load = false;
        this.successfulLoad = true;
        this.needsFinish = true;
        ExaminationEntry ee = new ExaminationEntry(){

            public Object getKey() {
                return EntryAction.this.entry.getKey();
            }

            public Object getValueOrException() {
                return EntryAction.this.newValueOrException;
            }

            @Override
            public long getLastModification() {
                return EntryAction.this.lastModificationTime;
            }
        };
        this.operation.update(this, ee);
        if (this.needsFinish) {
            this.updateDidNotTriggerDifferentMutationStoreLoadedValue();
        }
    }

    public void updateDidNotTriggerDifferentMutationStoreLoadedValue() {
        this.checkKeepOrRemove();
    }

    public void mutationMayCallWriter() {
        CacheWriter<K, V> _writer = this.writer();
        if (_writer == null) {
            this.skipWritingNoWriter();
            return;
        }
        if (this.remove) {
            try {
                this.entry.nextProcessingStep(Entry.ProcessingState.WRITE);
                _writer.delete(this.key);
            }
            catch (Throwable t) {
                this.onWriteFailure(t);
                return;
            }
            this.onWriteSuccess();
            return;
        }
        if (this.newValueOrException instanceof ExceptionWrapper) {
            this.skipWritingForException();
            return;
        }
        this.entry.nextProcessingStep(Entry.ProcessingState.WRITE);
        try {
            _writer.write(this.key, this.newValueOrException);
        }
        catch (Throwable t) {
            this.onWriteFailure(t);
            return;
        }
        this.onWriteSuccess();
    }

    @Override
    public void onWriteSuccess() {
        this.entry.nextProcessingStep(Entry.ProcessingState.WRITE_COMPLETE);
        this.checkKeepOrRemove();
    }

    @Override
    public void onWriteFailure(Throwable t) {
        this.mutationAbort(new CacheWriterException(t));
    }

    public void skipWritingForException() {
        this.checkKeepOrRemove();
    }

    public void skipWritingNoWriter() {
        this.checkKeepOrRemove();
    }

    public void checkKeepOrRemove() {
        boolean _hasKeepAfterExpired = this.heapCache.hasKeepAfterExpired();
        if (this.expiry != 0L || this.remove || _hasKeepAfterExpired) {
            this.mutationUpdateHeap();
            return;
        }
        if (_hasKeepAfterExpired) {
            this.expiredImmediatelyKeepData();
            return;
        }
        this.expiredImmediatelyAndRemove();
    }

    public void expiredImmediatelyKeepData() {
        this.expiredImmediately = true;
        this.mutationUpdateHeap();
    }

    public void expiredImmediatelyAndRemove() {
        this.remove = true;
        this.expiredImmediately = true;
        this.mutationUpdateHeap();
    }

    public void mutationUpdateHeap() {
        this.entry.setLastModification(this.lastModificationTime);
        if (this.remove) {
            this.entry.nextRefreshTime = 11L;
        } else {
            this.oldValueOrException = this.entry.value;
            this.previousModificationTime = this.entry.getLastModification();
            this.entry.value = this.newValueOrException;
        }
        this.mutationMayStore();
    }

    public void mutationMayStore() {
        if (this.storage() == null) {
            this.skipStore();
            return;
        }
        this.mutationStore();
    }

    public void mutationStore() {
        this.entry.nextProcessingStep(Entry.ProcessingState.STORE);
        boolean _entryRemoved = false;
        try {
            if (this.remove) {
                _entryRemoved = this.storage().remove(this.key);
            } else {
                this.storage().put(this.entry, this.expiry);
            }
        }
        catch (Throwable t) {
            this.onStoreFailure(t);
            return;
        }
        this.onStoreSuccess(_entryRemoved);
    }

    @Override
    public void onStoreSuccess(boolean _entryRemoved) {
        this.entry.nextProcessingStep(Entry.ProcessingState.STORE_COMPLETE);
        this.callListeners();
    }

    @Override
    public void onStoreFailure(Throwable t) {
        this.mutationAbort(new StorageWriteException(t));
    }

    public void skipStore() {
        this.callListeners();
    }

    public void callListeners() {
        if (!this.mightHaveListeners()) {
            this.mutationReleaseLockAndStartTimer();
            return;
        }
        if (this.expiredImmediately) {
            if ((this.storageDataValid || this.heapDataValid) && this.entryExpiredListeners() != null) {
                for (CacheEntryExpiredListener<K, V> l : this.entryExpiredListeners()) {
                    try {
                        l.onEntryExpired(this.userCache, this.entry);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new ListenerException(t);
                    }
                }
            }
        } else if (this.remove) {
            if ((this.storageDataValid || this.heapDataValid) && this.entryRemovedListeners() != null) {
                for (CacheEntryRemovedListener<K, V> l : this.entryRemovedListeners()) {
                    try {
                        l.onEntryRemoved(this.userCache, this.entry);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new ListenerException(t);
                    }
                }
            }
        } else if (this.storageDataValid || this.heapDataValid) {
            if (this.entryUpdatedListeners() != null) {
                for (CacheEntryUpdatedListener<K, V> l : this.entryUpdatedListeners()) {
                    try {
                        l.onEntryUpdated(this.userCache, new ReadOnlyCacheEntry<K, V>(this.entry.getKey(), this.oldValueOrException, this.previousModificationTime), this.entry);
                    }
                    catch (Throwable t) {
                        this.exceptionToPropagate = new ListenerException(t);
                    }
                }
            }
        } else if (this.entryCreatedListeners() != null) {
            for (CacheEntryCreatedListener<K, V> l : this.entryCreatedListeners()) {
                try {
                    l.onEntryCreated(this.userCache, this.entry);
                }
                catch (Throwable t) {
                    this.exceptionToPropagate = new ListenerException(t);
                }
            }
        }
        this.mutationReleaseLockAndStartTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationReleaseLockAndStartTimer() {
        if (this.load && !this.remove) {
            this.operation.loaded(this, this.entry);
        }
        Object object = this.entry;
        synchronized (object) {
            this.entry.processingDone();
            this.entryLocked = false;
            this.entry.notifyAll();
            if (this.remove) {
                Object object2 = this.heapCache.lock;
                synchronized (object2) {
                    if (this.heapCache.removeEntry(this.entry)) {
                        if (this.expiredImmediately) {
                            ++this.heapCache.expiredRemoveCnt;
                        } else {
                            ++this.heapCache.removedCnt;
                        }
                    }
                }
            } else {
                this.entry.nextRefreshTime = this.timing().stopStartTimer(this.expiry, this.entry);
                if (this.entry.isExpired()) {
                    this.entry.nextRefreshTime = 32L;
                    this.userCache.expireOrScheduleFinalExpireEvent(this.entry);
                }
            }
        }
        object = this.heapCache.lock;
        synchronized (object) {
            this.updateMutationStatisticsInsideLock();
        }
        this.mutationDone();
    }

    public void updateOnlyReadStatisticsInsideLock() {
        if (this.countMiss) {
            if (this.heapHit) {
                ++this.heapCache.peekHitNotFreshCnt;
            }
            if (this.heapMiss) {
                ++this.heapCache.peekMissCnt;
            }
            if (this.storageRead && this.storageMiss) {
                this.storageMetrics().readNonFresh();
                ++this.heapCache.peekHitNotFreshCnt;
            }
        } else if (this.doNotCountAccess && this.heapHit) {
            this.metrics().containsButHit();
        }
        if (this.storageRead && !this.storageMiss) {
            this.storageMetrics().readHit();
        }
    }

    public void updateMutationStatisticsInsideLock() {
        if (this.loadCompletedTime > 0L) {
            ++this.heapCache.loadWoRefreshCnt;
            this.heapCache.fetchMillis += this.loadCompletedTime - this.loadStartedTime;
            if (this.storageRead && this.storageMiss) {
                this.storageMetrics().readMiss();
            }
        } else {
            this.updateOnlyReadStatisticsInsideLock();
            if (this.wantData) {
                this.metrics().casOperation();
            }
            if (this.remove) {
                if (this.heapDataValid) {
                    this.metrics().remove();
                } else if (this.heapHit) {
                    // empty if block
                }
            }
        }
    }

    @Override
    public void failure(Throwable t) {
        this.mutationAbort(new ProcessingFailureException(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void examinationAbort(CustomizationException t) {
        this.exceptionToPropagate = t;
        if (this.entryLocked) {
            Entry<K, V> entry = this.entry;
            synchronized (entry) {
                this.entry.processingDone();
                this.entry.notifyAll();
                this.entryLocked = false;
            }
        }
        this.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutationAbort(CustomizationException t) {
        this.exceptionToPropagate = t;
        Entry<K, V> entry = this.entry;
        synchronized (entry) {
            this.entry.processingDone();
            this.entry.notifyAll();
            this.entryLocked = false;
        }
        this.ready();
    }

    public void mutationDone() {
        this.evictEventuallyAfterMutation();
    }

    public void evictEventuallyAfterMutation() {
        this.heapCache.evictEventually();
        this.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noMutationRequested() {
        Object object;
        if (this.entryLocked) {
            object = this.entry;
            synchronized (object) {
                this.entry.processingDone();
                this.entry.notifyAll();
                if (this.entry.isVirgin()) {
                    Object object2 = this.heapCache.lock;
                    synchronized (object2) {
                        this.heapCache.removeEntry(this.entry);
                        ++this.heapCache.virginRemovedCnt;
                    }
                }
            }
            this.entryLocked = false;
        }
        object = this.heapCache.lock;
        synchronized (object) {
            this.updateOnlyReadStatisticsInsideLock();
        }
        if (!this.heapHit) {
            this.evictEventuallyAfterExamine();
            return;
        }
        this.ready();
    }

    public void evictEventuallyAfterExamine() {
        this.heapCache.evictEventually();
        this.ready();
    }

    public void ready() {
    }

    public static class ListenerException
    extends CustomizationException {
        public ListenerException(Throwable cause) {
            super(cause);
        }
    }

    public static class ProcessingFailureException
    extends CustomizationException {
        public ProcessingFailureException(Throwable cause) {
            super(cause);
        }
    }

    public static class StorageWriteException
    extends CustomizationException {
        public StorageWriteException(Throwable cause) {
            super(cause);
        }
    }

    public static class StorageReadException
    extends CustomizationException {
        public StorageReadException(Throwable cause) {
            super(cause);
        }
    }
}

