/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.lang.reflect.Field;
import java.util.TimerTask;
import org.cache2k.CacheEntry;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.HeapCache;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.storageApi.StorageEntry;
import org.cache2k.core.util.Util;
import org.cache2k.integration.LoadExceptionInformation;

public class Entry<K, T>
implements CacheEntry<K, T>,
StorageEntry,
ExaminationEntry<K, T> {
    public static final int EXPIRY_TIME_MIN = 32;
    static final int DATA_VALID = 16;
    static final int REMOVE_PENDING = 11;
    static final int ABORTED = 8;
    static final int READ_NON_VALID = 5;
    static final int EXPIRED = 4;
    private static final int GONE = 2;
    static final int VIRGIN = 0;
    static final InitialValueInEntryNeverReturned INITIAL_VALUE = new InitialValueInEntryNeverReturned();
    private Object misc;
    long hitCnt;
    private volatile long fetchedTime;
    public volatile long nextRefreshTime;
    public K key;
    public volatile T value = INITIAL_VALUE;
    public int hashCode;
    public volatile Entry<K, T> another;
    public Entry next;
    public Entry prev;
    private static final int MODIFICATION_TIME_BITS = 44;
    private static final long MODIFICATION_TIME_BASE = 0L;
    private static final int MODIFICATION_TIME_SHIFT = 1;
    private static final long MODIFICATION_TIME_MASK = 0xFFFFFFFFFFFL;
    private static final int DIRTY = 0;
    private static final int CLEAN = 1;
    private static final int PS_BITS = 5;
    private static final int PS_MASK = 31;
    private static final int PS_POS = 44;
    private static final int STALE_BITS = 1;
    private static final int STALE_MASK = 1;
    private static final int STALE_POS = 49;

    void setLastModification(long t, int _clean) {
        this.fetchedTime = this.fetchedTime & 0xFFFFF00000000000L | (t - 0L << 1) + (long)_clean & 0xFFFFFFFFFFFL;
    }

    public void setLastModification(long t) {
        this.setLastModification(t, 0);
    }

    public boolean isDirty() {
        return (this.fetchedTime & 1L) == 0L;
    }

    public void setLastModificationFromStorage(long t) {
        this.setLastModification(t, 1);
    }

    public void resetDirty() {
        this.fetchedTime |= 1L;
    }

    @Override
    public long getLastModification() {
        return (this.fetchedTime & 0xFFFFFFFFFFFL) >> 1;
    }

    public ProcessingState getProcessingState() {
        return ProcessingState.values()[(int)(this.fetchedTime >> 44 & 0x1FL)];
    }

    public void setProcessingState(ProcessingState ps) {
        this.fetchedTime = this.fetchedTime & 0xFFFE0FFFFFFFFFFFL | (long)ps.ordinal() << 44;
    }

    public void startProcessing() {
        this.setProcessingState(ProcessingState.FETCH);
    }

    public void startProcessing(ProcessingState ps) {
        this.setProcessingState(ps);
    }

    public void nextProcessingStep(ProcessingState ps) {
        this.setProcessingState(ps);
    }

    public void processingDone() {
        this.setProcessingState(ProcessingState.DONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureAbort(boolean _finished) {
        if (_finished) {
            return;
        }
        Entry entry = this;
        synchronized (entry) {
            if (this.isVirgin()) {
                this.nextRefreshTime = 8L;
            }
            if (this.isProcessing()) {
                this.setProcessingState(ProcessingState.DONE);
                this.notifyAll();
            }
        }
    }

    public boolean isProcessing() {
        return this.getProcessingState() != ProcessingState.DONE;
    }

    public void waitForProcessing() {
        if (!this.isProcessing()) {
            return;
        }
        boolean _interrupt = false;
        do {
            try {
                this.wait();
            }
            catch (InterruptedException ignore) {
                _interrupt = true;
            }
        } while (this.isProcessing());
        if (_interrupt) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isGettingRefresh() {
        return this.getProcessingState() == ProcessingState.REFRESH;
    }

    public final void removedFromList() {
        this.next = null;
        this.prev = null;
    }

    public boolean isRemovedFromReplacementList() {
        return this.isStale() || this.next == null;
    }

    public Entry shortCircuit() {
        this.next = this.prev = this;
        return this.prev;
    }

    public final boolean isVirgin() {
        return this.nextRefreshTime == 0L;
    }

    public final boolean isDataValid() {
        return this.nextRefreshTime >= 16L || this.nextRefreshTime < 0L;
    }

    public final boolean hasFreshData() {
        if (this.nextRefreshTime >= 16L) {
            return true;
        }
        if (this.needsTimeCheck()) {
            return System.currentTimeMillis() < -this.nextRefreshTime;
        }
        return false;
    }

    public final boolean hasFreshData(long now, long _nextRefreshTime) {
        if (_nextRefreshTime >= 16L) {
            return true;
        }
        if (_nextRefreshTime < 0L) {
            return now < -_nextRefreshTime;
        }
        return false;
    }

    public boolean isReadNonValid() {
        return this.nextRefreshTime == 5L;
    }

    public void setExpiredState() {
        this.nextRefreshTime = 4L;
    }

    public boolean isExpired() {
        return this.nextRefreshTime == 4L;
    }

    public void setGone() {
        this.nextRefreshTime = 2L;
    }

    public boolean isGone() {
        return this.nextRefreshTime == 2L;
    }

    public boolean needsTimeCheck() {
        return this.nextRefreshTime < 0L;
    }

    public boolean isStale() {
        return (this.fetchedTime >> 49 & 1L) > 0L;
    }

    public void setStale() {
        this.fetchedTime |= 0x2000000000000L;
    }

    public boolean hasException() {
        return this.value instanceof ExceptionWrapper;
    }

    @Override
    public Throwable getException() {
        if (this.value instanceof ExceptionWrapper) {
            return ((ExceptionWrapper)this.value).getException();
        }
        return null;
    }

    public boolean equalsValue(T v) {
        if (this.value == null) {
            return v == this.value;
        }
        return this.value.equals(v);
    }

    @Override
    public T getValue() {
        if (this.value instanceof ExceptionWrapper) {
            return null;
        }
        return this.value;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public long getValueExpiryTime() {
        if (this.nextRefreshTime < 0L) {
            return -this.nextRefreshTime;
        }
        if (this.nextRefreshTime > 32L) {
            return this.nextRefreshTime;
        }
        return 0L;
    }

    @Override
    public T getValueOrException() {
        return this.value;
    }

    @Override
    public long getCreatedOrUpdated() {
        return this.getLastModification();
    }

    @Override
    public long getEntryExpiryTime() {
        return 0L;
    }

    public String toString(HeapCache c) {
        StringBuilder sb = new StringBuilder();
        sb.append("Entry{");
        sb.append("objId=").append(System.identityHashCode(this));
        sb.append(", lock=").append((Object)this.getProcessingState());
        sb.append(", key=");
        if (this.key == null) {
            sb.append("null");
        } else {
            sb.append(this.key);
            if (c != null && c.modifiedHash(this.key.hashCode()) != this.hashCode) {
                sb.append(", keyMutation=true");
            }
        }
        if (this.value != null) {
            sb.append(", valueIdentityHashCode=").append(System.identityHashCode(this.value));
        } else {
            sb.append(", value=null");
        }
        sb.append(", modified=").append(Util.formatMillis(this.getLastModification()));
        if (this.nextRefreshTime < 0L) {
            sb.append(", nextRefreshTime(sharp)=").append(Util.formatMillis(-this.nextRefreshTime));
        } else if (this.nextRefreshTime == Long.MAX_VALUE) {
            sb.append(", nextRefreshTime=ETERNAL");
        } else if (this.nextRefreshTime >= 32L) {
            sb.append(", nextRefreshTime(timer)=").append(Util.formatMillis(this.nextRefreshTime));
        } else {
            sb.append(", state=").append(this.nextRefreshTime);
        }
        if (Thread.holdsLock(this)) {
            if (this.getTask() != null) {
                String _timerState = "<unavailable>";
                try {
                    Field f = TimerTask.class.getDeclaredField("state");
                    f.setAccessible(true);
                    int _state = f.getInt(this.getTask());
                    _timerState = String.valueOf(_state);
                }
                catch (Exception x) {
                    _timerState = x.toString();
                }
                sb.append(", timerState=").append(_timerState);
            }
        } else {
            sb.append(", timerState=skipped/notLocked");
        }
        sb.append(", dirty=").append(this.isDirty());
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public TimerTask getTask() {
        if (this.misc instanceof TimerTask) {
            return (TimerTask)this.misc;
        }
        TimerTaskPiggyBack pb = this.getPiggyBack(TimerTaskPiggyBack.class);
        if (pb != null) {
            return pb.task;
        }
        return null;
    }

    public boolean cancelTimerTask() {
        TimerTask tt;
        Object o = this.misc;
        if (o instanceof TimerTask) {
            this.misc = null;
            return ((TimerTask)o).cancel();
        }
        TimerTaskPiggyBack pb = this.getPiggyBack(TimerTaskPiggyBack.class);
        if (pb != null && (tt = pb.task) != null) {
            pb.task = null;
            return tt.cancel();
        }
        return false;
    }

    public <X> X getPiggyBack(Class<X> _class) {
        Object obj = this.misc;
        if (!(obj instanceof PiggyBack)) {
            return null;
        }
        PiggyBack pb = (PiggyBack)obj;
        do {
            if (pb.getClass() != _class) continue;
            return (X)pb;
        } while ((pb = pb.next) != null);
        return null;
    }

    public void setTask(TimerTask v) {
        if (this.misc == null || this.misc instanceof TimerTask) {
            this.misc = v;
            return;
        }
        TimerTaskPiggyBack pb = this.getPiggyBack(TimerTaskPiggyBack.class);
        if (pb != null) {
            pb.task = v;
            return;
        }
        this.misc = new TimerTaskPiggyBack(v, (PiggyBack)this.misc);
    }

    public void setSuppressedLoadExceptionInformation(LoadExceptionInformation w) {
        Object _misc = this.misc;
        if (_misc instanceof TimerTask) {
            this.misc = new TimerTaskPiggyBack((TimerTask)_misc, new LoadExceptionPiggyBack(w, null));
            return;
        }
        LoadExceptionPiggyBack inf = this.getPiggyBack(LoadExceptionPiggyBack.class);
        if (inf != null) {
            inf.info = w;
            return;
        }
        this.misc = new LoadExceptionPiggyBack(w, (PiggyBack)_misc);
    }

    public void resetSuppressedLoadExceptionInformation() {
        LoadExceptionPiggyBack inf = this.getPiggyBack(LoadExceptionPiggyBack.class);
        if (inf != null) {
            inf.info = null;
        }
    }

    public LoadExceptionInformation getSuppressedLoadExceptionInformation() {
        LoadExceptionPiggyBack inf = this.getPiggyBack(LoadExceptionPiggyBack.class);
        return inf != null ? inf.info : null;
    }

    static class LoadExceptionPiggyBack
    extends PiggyBack {
        LoadExceptionInformation info;

        public LoadExceptionPiggyBack(LoadExceptionInformation _info, PiggyBack _next) {
            this.info = _info;
            this.next = _next;
        }
    }

    static class TimerTaskPiggyBack
    extends PiggyBack {
        TimerTask task;

        public TimerTaskPiggyBack(TimerTask _task, PiggyBack _next) {
            this.task = _task;
            this.next = _next;
        }
    }

    static class PiggyBack {
        PiggyBack next;

        PiggyBack() {
        }
    }

    static class InitialValueInEntryNeverReturned {
        InitialValueInEntryNeverReturned() {
        }
    }

    static enum ProcessingState {
        DONE,
        READ,
        READ_COMPLETE,
        MUTATE,
        LOAD,
        LOAD_COMPLETE,
        FETCH,
        REFRESH,
        EXPIRY,
        EXPIRY_COMPLETE,
        WRITE,
        WRITE_COMPLETE,
        STORE,
        STORE_COMPLETE,
        NOTIFY,
        PINNED,
        EVICT,
        LAST;

    }
}

