/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cache2k.core.Entry;
import org.cache2k.core.Hash;
import org.cache2k.core.HeapCache;

public class ConcurrentEntryIterator<K, V>
implements Iterator<Entry<K, V>> {
    HeapCache<K, V> cache;
    Entry lastEntry = null;
    Entry nextEntry = null;
    int sequenceCnt = 0;
    int lastSequenceCnt;
    int initialHashSize;
    Hash<Entry<K, V>> hashCtl;
    Entry<K, V>[] hash;
    Hash<Entry<K, V>> iteratedCtl = new Hash();
    Entry<K, V>[] iterated;

    public ConcurrentEntryIterator(HeapCache<K, V> _cache) {
        this.cache = _cache;
        this.iterated = this.iteratedCtl.init(Entry.class);
        this.lastSequenceCnt = 2;
        if (this.cache.hasBackgroundRefresh()) {
            this.lastSequenceCnt = 4;
        }
        this.switchAndCheckAbort();
    }

    private Entry nextEntry() {
        Entry e;
        if (this.hash == null) {
            return null;
        }
        if (this.hashCtl.isCleared()) {
            return null;
        }
        int idx = 0;
        if (this.lastEntry != null) {
            e = this.lastEntry.another;
            if (e != null && (e = this.checkIteratedOrNext(e)) != null) {
                this.lastEntry = e;
                return e;
            }
            idx = Hash.index(this.hash, this.lastEntry.hashCode) + 1;
        }
        while (true) {
            if (idx >= this.hash.length) {
                if (this.switchAndCheckAbort()) {
                    return null;
                }
                idx = 0;
            }
            if ((e = this.hash[idx]) != null && (e = this.checkIteratedOrNext(e)) != null) {
                this.lastEntry = e;
                return e;
            }
            ++idx;
        }
    }

    public void markIterated(Object key, int _hashCode) {
        Entry _newEntryIterated = new Entry();
        _newEntryIterated.key = key;
        _newEntryIterated.hashCode = _hashCode;
        this.iterated = this.iteratedCtl.insert(this.iterated, _newEntryIterated);
    }

    protected Entry<K, V> checkIteratedOrNext(Entry<K, V> e) {
        do {
            boolean _notYetIterated;
            boolean bl = _notYetIterated = !Hash.contains(this.iterated, e.key, e.hashCode);
            if (!_notYetIterated) continue;
            this.markIterated(e.key, e.hashCode);
            return e;
        } while ((e = e.another) != null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean switchAndCheckAbort() {
        Object object = this.cache.lock;
        synchronized (object) {
            boolean _cacheClosed;
            if (this.hasExpansionOccurred()) {
                this.lastSequenceCnt += 2;
            }
            if (this.lastSequenceCnt == this.sequenceCnt) {
                this.hash = null;
                return true;
            }
            int _step = this.sequenceCnt % 6;
            if (_step == 0 || _step == 3 || _step == 4) {
                this.switchToMainHash();
            }
            if (_step == 1 || _step == 2 || _step == 5) {
                this.switchToRefreshHash();
            }
            boolean bl = _cacheClosed = this.hash == null;
            if (_cacheClosed) {
                return true;
            }
            this.initialHashSize = this.hashCtl.size;
            ++this.sequenceCnt;
        }
        return false;
    }

    private boolean hasExpansionOccurred() {
        return this.hashCtl != null && this.initialHashSize != this.hashCtl.size;
    }

    private void switchToMainHash() {
        this.hash = this.cache.mainHash;
        this.hashCtl = this.cache.mainHashCtrl;
    }

    private void switchToRefreshHash() {
        this.hash = this.cache.refreshHash;
        this.hashCtl = this.cache.refreshHashCtrl;
    }

    @Override
    public boolean hasNext() {
        this.nextEntry = this.nextEntry();
        return this.nextEntry != null;
    }

    @Override
    public Entry<K, V> next() {
        if (this.nextEntry != null) {
            Entry e = this.nextEntry;
            this.nextEntry = null;
            return e;
        }
        Entry e = this.nextEntry();
        if (e == null) {
            throw new NoSuchElementException("not available");
        }
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasBeenIterated(Object key, int _hashCode) {
        return Hash.contains(this.iterated, key, _hashCode);
    }
}

