/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.core.ConcurrentEvictionCache;
import org.cache2k.core.Entry;
import org.cache2k.core.Hash;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.util.TunableConstants;
import org.cache2k.core.util.TunableFactory;

public class ClockProPlusCache<K, V>
extends ConcurrentEvictionCache<K, V> {
    private static final Tunable TUNABLE_CLOCK_PRO = TunableFactory.get(Tunable.class);
    long hotHits;
    long coldHits;
    long ghostHits;
    long directRemoveCnt;
    long hotRunCnt;
    long hot24hCnt;
    long hotScanCnt;
    long hotSizeSum;
    long coldRunCnt;
    long cold24hCnt;
    long coldScanCnt;
    int coldSize;
    int hotSize;
    int staleSize;
    long hotMax;
    long ghostMax;
    Entry handCold;
    Entry handHot;
    Entry handGhost;
    Hash<Entry> ghostHashCtrl;
    Entry[] ghostHash;

    private long sumUpListHits(Entry e) {
        if (e == null) {
            return 0L;
        }
        long cnt = 0L;
        Entry _head = e;
        do {
            cnt += e.hitCnt;
        } while ((e = e.next) != _head);
        return cnt;
    }

    @Override
    public long getHitCnt() {
        return this.hotHits + this.coldHits + this.sumUpListHits(this.handCold) + this.sumUpListHits(this.handHot);
    }

    @Override
    protected void initializeHeapCache() {
        super.initializeHeapCache();
        this.ghostMax = this.maxSize;
        this.hotMax = this.maxSize * (long)ClockProPlusCache.TUNABLE_CLOCK_PRO.hotMaxPercentage / 100L;
        this.coldSize = 0;
        this.hotSize = 0;
        this.staleSize = 0;
        this.handCold = null;
        this.handHot = null;
        this.handGhost = null;
        this.ghostHashCtrl = new Hash();
        this.ghostHash = this.ghostHashCtrl.init(Entry.class);
    }

    @Override
    protected void iterateAllEntriesAndRemoveFromReplacementList() {
        Entry _next;
        Entry _head;
        int _count = 0;
        Entry e = _head = this.handCold;
        long _hits = 0L;
        if (e != null) {
            do {
                _hits += e.hitCnt;
                _next = e.prev;
                if (e.isStale()) continue;
                e.removedFromList();
                ++_count;
            } while ((e = _next) != _head);
            this.coldHits += _hits;
        }
        if ((e = (_head = this.handHot)) != null) {
            _hits = 0L;
            do {
                _hits += e.hitCnt;
                _next = e.prev;
                if (e.isStale()) continue;
                e.removedFromList();
                ++_count;
            } while ((e = _next) != _head);
            this.hotHits += _hits;
        }
    }

    @Override
    protected void evictEntry(Entry e) {
        this.insertCopyIntoGhosts(e);
        this.removeEntryFromReplacementList(e);
    }

    @Override
    protected void removeEntryFromReplacementList(Entry e) {
        if (this.handCold == e) {
            this.coldHits += e.hitCnt;
            this.handCold = ClockProPlusCache.removeFromCyclicList(this.handCold, e);
            --this.coldSize;
            ++this.directRemoveCnt;
        } else {
            ++this.staleSize;
            e.setStale();
        }
    }

    private void insertCopyIntoGhosts(Entry<K, V> e) {
        Entry e2 = new Entry();
        e2.key = e.key;
        e2.hashCode = e.hashCode;
        this.ghostHash = this.ghostHashCtrl.insert(this.ghostHash, e2);
        this.handGhost = ClockProPlusCache.insertIntoTailCyclicList(this.handGhost, e2);
        if ((long)this.ghostHashCtrl.size > this.ghostMax) {
            this.runHandGhost();
        }
    }

    private int getListSize() {
        return this.hotSize + this.coldSize - this.staleSize;
    }

    @Override
    protected void recordHit(Entry e) {
        long _hitCnt = e.hitCnt + 1L;
        if ((_hitCnt & 0x100000000L) != 0L) {
            this.scrubCache(e);
            this.recordHit(e);
            return;
        }
        e.hitCnt = _hitCnt;
    }

    private long scrubCounters(Entry e) {
        if (e == null) {
            return 0L;
        }
        int cnt = 0;
        Entry _head = e;
        do {
            long _hitCnt = e.hitCnt;
            long _hitCnt2 = e.hitCnt >>= 1;
            cnt = (int)((long)cnt + (_hitCnt - _hitCnt2));
        } while ((e = e.next) != _head);
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrubCache(Entry e) {
        Object object = this.lock;
        synchronized (object) {
            if (e.hitCnt != Integer.MAX_VALUE) {
                return;
            }
            this.coldHits += this.scrubCounters(this.handCold);
            this.hotHits += this.scrubCounters(this.handHot);
        }
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        ++this.coldSize;
        this.handCold = ClockProPlusCache.insertIntoTailCyclicList(this.handCold, e);
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    protected Entry<K, V> runHandHot() {
        Entry _handStart;
        Entry _hand;
        ++this.hotRunCnt;
        Entry _coldCandidate = _hand = (_handStart = this.handHot);
        long _lowestHits = Long.MAX_VALUE;
        long _hotHits = this.hotHits;
        int _scanCnt = -1;
        long _decrease = (_hand.hitCnt + _hand.next.hitCnt >> ClockProPlusCache.TUNABLE_CLOCK_PRO.hitCounterDecreaseShift) + 1L;
        do {
            ++_scanCnt;
            long _hitCnt = _hand.hitCnt;
            if (_hitCnt < _lowestHits) {
                _lowestHits = _hitCnt;
                _coldCandidate = _hand;
                if (_hitCnt == 0L) break;
            }
            if (_hitCnt < _decrease) {
                _hand.hitCnt = 0L;
                _hotHits += _hitCnt;
                continue;
            }
            _hand.hitCnt = _hitCnt - _decrease;
            _hotHits += _decrease;
        } while ((_hand = _hand.next) != _handStart);
        this.hotHits = _hotHits;
        this.hotScanCnt += (long)_scanCnt;
        if ((long)_scanCnt == this.hotMax) {
            ++this.hot24hCnt;
        }
        this.handHot = ClockProPlusCache.removeFromCyclicList(_hand, _coldCandidate);
        --this.hotSize;
        return _coldCandidate;
    }

    @Override
    protected Entry findEvictionCandidate() {
        this.hotSizeSum += this.hotMax;
        ++this.coldRunCnt;
        Entry _hand = this.handCold;
        int _scanCnt = 0;
        while (true) {
            if (_hand == null) {
                _hand = this.refillFromHot(_hand);
            }
            if (_hand.hitCnt > 0L) {
                _hand = this.refillFromHot(_hand);
                do {
                    ++_scanCnt;
                    this.coldHits += _hand.hitCnt;
                    _hand.hitCnt = 0L;
                    Entry e = _hand;
                    _hand = ClockProPlusCache.removeFromCyclicList(e);
                    --this.coldSize;
                    ++this.hotSize;
                    this.handHot = ClockProPlusCache.insertIntoTailCyclicList(this.handHot, e);
                } while (_hand != null && _hand.hitCnt > 0L);
            }
            if (_hand == null) {
                _hand = this.refillFromHot(_hand);
            }
            if (!_hand.isStale()) break;
            _hand = ClockProPlusCache.removeFromCyclicList(_hand);
            --this.staleSize;
            --this.coldSize;
            --_scanCnt;
        }
        if (_scanCnt > this.coldSize) {
            ++this.cold24hCnt;
        }
        this.coldScanCnt += (long)_scanCnt;
        this.handCold = _hand;
        return _hand;
    }

    private Entry refillFromHot(Entry _hand) {
        while ((long)this.hotSize > this.hotMax || _hand == null) {
            Entry<K, V> e = this.runHandHot();
            if (e == null) continue;
            if (e.isStale()) {
                --this.staleSize;
                continue;
            }
            _hand = ClockProPlusCache.insertIntoTailCyclicList(_hand, e);
            ++this.coldSize;
        }
        return _hand;
    }

    protected void runHandGhost() {
        boolean f = this.ghostHashCtrl.remove(this.ghostHash, this.handGhost);
        Entry e = this.handGhost;
        this.handGhost = ClockProPlusCache.removeFromCyclicList(this.handGhost);
    }

    @Override
    protected Entry checkForGhost(K key, int hc) {
        Entry e = this.ghostHashCtrl.remove(this.ghostHash, key, hc);
        if (e != null) {
            this.handGhost = ClockProPlusCache.removeFromCyclicList(this.handGhost, e);
            ++this.ghostHits;
            ++this.hotSize;
            this.handHot = ClockProPlusCache.insertIntoTailCyclicList(this.handHot, e);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntegrityState getIntegrityState() {
        Object object = this.lock;
        synchronized (object) {
            return super.getIntegrityState().checkEquals("ghostHashCtrl.size == Hash.calcEntryCount(refreshHash)", this.ghostHashCtrl.size, Hash.calcEntryCount(this.ghostHash)).check("hotMax <= maxElements", this.hotMax <= this.maxSize).checkEquals("getListSize() == getSize()", this.getListSize(), this.getLocalSize()).check("checkCyclicListIntegrity(handHot)", ClockProPlusCache.checkCyclicListIntegrity(this.handHot)).check("checkCyclicListIntegrity(handCold)", ClockProPlusCache.checkCyclicListIntegrity(this.handCold)).check("checkCyclicListIntegrity(handGhost)", ClockProPlusCache.checkCyclicListIntegrity(this.handGhost)).checkEquals("getCyclicListEntryCount(handHot) == hotSize", ClockProPlusCache.getCyclicListEntryCount(this.handHot), this.hotSize).checkEquals("getCyclicListEntryCount(handCold) == coldSize", ClockProPlusCache.getCyclicListEntryCount(this.handCold), this.coldSize).checkEquals("getCyclicListEntryCount(handGhost) == ghostSize", ClockProPlusCache.getCyclicListEntryCount(this.handGhost), this.ghostHashCtrl.size);
        }
    }

    @Override
    protected String getExtraStatistics() {
        return ", coldSize=" + this.coldSize + ", hotSize=" + this.hotSize + ", hotMaxSize=" + this.hotMax + ", ghostSize=" + this.ghostHashCtrl.size + ", staleSize=" + this.staleSize + ", coldHits=" + (this.coldHits + this.sumUpListHits(this.handCold)) + ", hotHits=" + (this.hotHits + this.sumUpListHits(this.handHot)) + ", ghostHits=" + this.ghostHits + ", coldRunCnt=" + this.coldRunCnt + ", coldScanCnt=" + this.coldScanCnt + ", cold24hCnt=" + this.cold24hCnt + ", hotRunCnt=" + this.hotRunCnt + ", hotScanCnt=" + this.hotScanCnt + ", hot24hCnt=" + this.hot24hCnt + ", directRemoveCnt=" + this.directRemoveCnt;
    }

    public static class Tunable
    extends TunableConstants {
        int hotMaxPercentage = 97;
        int hitCounterDecreaseShift = 6;
    }
}

