/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.core.ConcurrentEvictionCache;
import org.cache2k.core.Entry;
import org.cache2k.core.IntegrityState;

public class ClockCache<K, V>
extends ConcurrentEvictionCache<K, V> {
    long hits;
    int runCnt;
    int scan24hCnt;
    int scanCnt;
    int size;
    Entry hand;

    @Override
    public long getHitCnt() {
        return this.hits + (long)this.sumUpListHits(this.hand);
    }

    private int sumUpListHits(Entry e) {
        if (e == null) {
            return 0;
        }
        int cnt = 0;
        Entry _head = e;
        do {
            cnt = (int)((long)cnt + e.hitCnt);
        } while ((e = e.prev) != _head);
        return cnt;
    }

    @Override
    protected void initializeHeapCache() {
        super.initializeHeapCache();
        this.size = 0;
        this.hand = null;
    }

    @Override
    protected void iterateAllEntriesAndRemoveFromReplacementList() {
        Entry _head;
        int _count = 0;
        Entry e = _head = this.hand;
        long _hits = 0L;
        if (e != null) {
            Entry _next;
            do {
                _hits += e.hitCnt;
                _next = e.prev;
                e.removedFromList();
                ++_count;
            } while ((e = _next) != _head);
            this.hits += _hits;
        }
    }

    @Override
    protected void removeEntryFromReplacementList(Entry e) {
        this.hand = ClockCache.removeFromCyclicList(this.hand, e);
        this.hits += e.hitCnt;
        --this.size;
    }

    private int getListSize() {
        return this.size;
    }

    @Override
    protected void recordHit(Entry e) {
        ++e.hitCnt;
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        ++this.size;
        this.hand = ClockCache.insertIntoTailCyclicList(this.hand, e);
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    @Override
    protected Entry findEvictionCandidate() {
        ++this.runCnt;
        int _scanCnt = 0;
        while (this.hand.hitCnt > 0L) {
            ++_scanCnt;
            this.hits += this.hand.hitCnt;
            this.hand.hitCnt = 0L;
            this.hand = this.hand.next;
        }
        if (_scanCnt > this.size) {
            ++this.scan24hCnt;
        }
        this.scanCnt += _scanCnt;
        return this.hand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntegrityState getIntegrityState() {
        Object object = this.lock;
        synchronized (object) {
            return super.getIntegrityState().check("checkCyclicListIntegrity(hand)", ClockCache.checkCyclicListIntegrity(this.hand)).checkEquals("getCyclicListEntryCount(hand) == size", ClockCache.getCyclicListEntryCount(this.hand), this.size);
        }
    }

    @Override
    protected String getExtraStatistics() {
        return ", clockRunCnt=" + this.runCnt + ", scanCnt=" + this.scanCnt + ", scan24hCnt=" + this.scan24hCnt;
    }
}

