/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.concurrent.ThreadPoolExecutor;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.Hash;
import org.cache2k.core.HeapCache;
import org.cache2k.core.IntegrityState;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.core.StorageMetrics;
import org.cache2k.core.storageApi.StorageAdapter;
import org.cache2k.core.util.Util;

class CacheBaseInfo
implements InternalCacheInfo {
    StorageAdapter storage;
    CommonMetrics metrics;
    StorageMetrics storageMetrics = StorageMetrics.DUMMY;
    private HeapCache heapCache;
    int size;
    long creationTime;
    int creationDeltaMs;
    long missCnt;
    long storageMissCnt;
    long storageLoadCnt;
    long newEntryCnt;
    long hitCnt;
    long correctedPutCnt;
    long usageCnt;
    Hash.CollisionInfo collisionInfo;
    String extraStatistics;
    IntegrityState integrityState;
    long asyncLoadsStarted = 0L;
    long asyncLoadsInFlight = 0L;
    int loaderThreadsLimit = 0;
    int loaderThreadsMaxActive = 0;
    long totalLoadCnt;

    public CacheBaseInfo(HeapCache _heapCache, InternalCache _userCache) {
        this.heapCache = _heapCache;
        this.metrics = _heapCache.metrics;
        this.integrityState = _heapCache.getIntegrityState();
        this.storageMetrics = _userCache.getStorageMetrics();
        this.collisionInfo = new Hash.CollisionInfo();
        Hash.calcHashCollisionInfo(this.collisionInfo, _heapCache.mainHash);
        Hash.calcHashCollisionInfo(this.collisionInfo, _heapCache.refreshHash);
        this.extraStatistics = _heapCache.getExtraStatistics();
        if (this.extraStatistics.startsWith(", ")) {
            this.extraStatistics = this.extraStatistics.substring(2);
        }
        this.size = _userCache.getTotalEntryCount();
        this.missCnt = _heapCache.loadWoRefreshCnt + _heapCache.peekHitNotFreshCnt + _heapCache.peekMissCnt;
        this.storageMissCnt = this.storageMetrics.getReadMissCount() + this.storageMetrics.getReadNonFreshCount();
        this.storageLoadCnt = this.storageMissCnt + this.storageMetrics.getReadHitCount();
        this.newEntryCnt = _heapCache.newEntryCnt;
        this.hitCnt = _heapCache.getHitCnt();
        this.correctedPutCnt = this.metrics.getPutNewEntryCount() + this.metrics.getPutHitCount() + this.metrics.getPutNoReadHitCount() - _heapCache.putButExpiredCnt;
        this.usageCnt = this.hitCnt + this.newEntryCnt + _heapCache.peekMissCnt + this.metrics.getPutHitCount() + this.metrics.getRemoveCount();
        if (_heapCache.loaderExecutor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor ex = (ThreadPoolExecutor)_heapCache.loaderExecutor;
            this.asyncLoadsInFlight = ex.getActiveCount();
            this.asyncLoadsStarted = ex.getTaskCount();
            this.loaderThreadsLimit = ex.getCorePoolSize();
            this.loaderThreadsMaxActive = ex.getLargestPoolSize();
        }
        this.totalLoadCnt = this.heapCache.loadWoRefreshCnt + this.heapCache.refreshCnt;
    }

    String percentString(double d) {
        String s = Double.toString(d);
        return (s.length() > 5 ? s.substring(0, 5) : s) + "%";
    }

    @Override
    public String getName() {
        return this.heapCache.name;
    }

    @Override
    public String getImplementation() {
        return this.heapCache.getClass().getSimpleName();
    }

    @Override
    public long getLoadButHitCnt() {
        return this.heapCache.loadButHitCnt;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getMaxSize() {
        return this.heapCache.maxSize;
    }

    @Override
    public long getStorageHitCnt() {
        return this.storageMetrics.getReadHitCount();
    }

    @Override
    public long getStorageMissCnt() {
        return this.storageMissCnt;
    }

    @Override
    public long getReadUsageCnt() {
        long _putHit = this.metrics.getPutNoReadHitCount();
        long _containsBitHit = this.metrics.getContainsButHitCount();
        long _heapHitButNoRead = this.metrics.getHeapHitButNoReadCount();
        return this.hitCnt + this.heapCache.peekMissCnt + this.heapCache.loadWoRefreshCnt - this.heapCache.loadButHitCnt - _putHit - _containsBitHit - _heapHitButNoRead;
    }

    @Override
    public long getUsageCnt() {
        return this.usageCnt;
    }

    @Override
    public long getMissCnt() {
        return this.missCnt;
    }

    @Override
    public long getNewEntryCnt() {
        return this.newEntryCnt;
    }

    @Override
    public long getLoadCnt() {
        return this.totalLoadCnt;
    }

    @Override
    public long getRefreshCnt() {
        return this.heapCache.refreshCnt;
    }

    @Override
    public long getInternalExceptionCnt() {
        return this.heapCache.internalExceptionCnt;
    }

    @Override
    public long getRefreshSubmitFailedCnt() {
        return this.heapCache.refreshSubmitFailedCnt;
    }

    @Override
    public long getSuppressedExceptionCnt() {
        return this.heapCache.suppressedExceptionCnt;
    }

    @Override
    public long getLoadExceptionCnt() {
        return this.heapCache.loadExceptionCnt;
    }

    @Override
    public long getRefreshHitCnt() {
        return this.heapCache.refreshHitCnt;
    }

    @Override
    public long getExpiredCnt() {
        return this.heapCache.getExpiredCnt();
    }

    @Override
    public long getEvictedCnt() {
        return this.heapCache.evictedCnt;
    }

    @Override
    public long getRemovedCnt() {
        return this.metrics.getRemoveCount();
    }

    @Override
    public long getPutNewEntryCnt() {
        return this.heapCache.putNewEntryCnt;
    }

    @Override
    public long getPutCnt() {
        return this.correctedPutCnt;
    }

    @Override
    public long getKeyMutationCnt() {
        return this.heapCache.keyMutationCount;
    }

    @Override
    public long getTimerEventCnt() {
        return this.heapCache.metrics.getTimerEventCount();
    }

    @Override
    public double getDataHitRate() {
        long cnt = this.getReadUsageCnt();
        return cnt == 0L ? 0.0 : (double)(cnt - this.missCnt) * 100.0 / (double)cnt;
    }

    @Override
    public String getDataHitString() {
        return this.percentString(this.getDataHitRate());
    }

    @Override
    public double getEntryHitRate() {
        return this.usageCnt == 0L ? 100.0 : (double)(this.usageCnt - this.newEntryCnt + this.metrics.getPutNewEntryCount()) * 100.0 / (double)this.usageCnt;
    }

    @Override
    public String getEntryHitString() {
        return this.percentString(this.getEntryHitRate());
    }

    @Override
    public int getCollisionPercentage() {
        return (this.size - this.collisionInfo.collisionCnt) * 100 / this.size;
    }

    @Override
    public int getSlotsPercentage() {
        return this.collisionInfo.collisionSlotCnt * 100 / this.collisionInfo.collisionCnt;
    }

    @Override
    public int getHq0() {
        return Math.max(0, 105 - this.collisionInfo.longestCollisionSize * 5);
    }

    @Override
    public int getHq1() {
        int _metricPercentageBase = 60;
        int m = this.getCollisionPercentage() * 40 / 100 + 60;
        m = Math.min(100, m);
        m = Math.max(0, m);
        return m;
    }

    @Override
    public int getHq2() {
        int _metricPercentageBase = 80;
        int m = this.getSlotsPercentage() * 20 / 100 + 80;
        m = Math.min(100, m);
        m = Math.max(0, m);
        return m;
    }

    @Override
    public int getHashQualityInteger() {
        int v;
        if (this.size == 0 || this.collisionInfo.collisionSlotCnt == 0) {
            return 100;
        }
        int _metric0 = this.getHq0();
        int _metric1 = this.getHq1();
        int _metric2 = this.getHq2();
        if (_metric1 < _metric0) {
            v = _metric0;
            _metric0 = _metric1;
            _metric1 = v;
        }
        if (_metric2 < _metric0) {
            v = _metric0;
            _metric0 = _metric2;
            _metric2 = v;
        }
        if (_metric2 < _metric1) {
            v = _metric1;
            _metric1 = _metric2;
            _metric2 = v;
        }
        if (_metric0 <= 0) {
            return 0;
        }
        _metric0 += (_metric1 - 50) * 5 / _metric0;
        _metric0 += (_metric2 - 50) * 2 / _metric0;
        _metric0 = Math.max(0, _metric0);
        _metric0 = Math.min(100, _metric0);
        return _metric0;
    }

    @Override
    public double getMillisPerLoad() {
        return this.getLoadCnt() == 0L ? 0.0 : (double)this.heapCache.fetchMillis * 1.0 / (double)this.getLoadCnt();
    }

    @Override
    public long getLoadMillis() {
        return this.heapCache.fetchMillis;
    }

    @Override
    public int getCollisionCnt() {
        return this.collisionInfo.collisionCnt;
    }

    @Override
    public int getCollisionSlotCnt() {
        return this.collisionInfo.collisionSlotCnt;
    }

    @Override
    public int getLongestCollisionSize() {
        return this.collisionInfo.longestCollisionSize;
    }

    @Override
    public String getIntegrityDescriptor() {
        return this.integrityState.getStateDescriptor();
    }

    @Override
    public long getStarted() {
        return this.heapCache.startedTime;
    }

    @Override
    public long getCleared() {
        return this.heapCache.clearedTime;
    }

    @Override
    public long getTouched() {
        return this.heapCache.touchedTime;
    }

    @Override
    public long getInfoCreated() {
        return this.creationTime;
    }

    @Override
    public int getInfoCreationDeltaMs() {
        return this.creationDeltaMs;
    }

    @Override
    public int getHealth() {
        if (this.storage != null && this.storage.getAlert() == 2) {
            return 2;
        }
        if (this.integrityState.getStateFlags() > 0L || this.getHashQualityInteger() < 5) {
            return 2;
        }
        if (this.storage != null && this.storage.getAlert() == 1) {
            return 1;
        }
        if (this.getHashQualityInteger() < 30 || this.getKeyMutationCnt() > 0L || this.getInternalExceptionCnt() > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public long getAsyncLoadsStarted() {
        return this.asyncLoadsStarted;
    }

    @Override
    public long getAsyncLoadsInFlight() {
        return this.asyncLoadsInFlight;
    }

    @Override
    public int getLoaderThreadsLimit() {
        return this.loaderThreadsLimit;
    }

    @Override
    public int getLoaderThreadsMaxActive() {
        return this.loaderThreadsMaxActive;
    }

    @Override
    public String getExtraStatistics() {
        return this.extraStatistics;
    }

    static String timestampToString(long t) {
        if (t == 0L) {
            return "-";
        }
        return Util.formatMillis(t);
    }

    @Override
    public long getClearCnt() {
        return this.heapCache.clearCnt;
    }

    @Override
    public long getClearedCnt() {
        return this.heapCache.clearedCnt;
    }

    public String toString() {
        return "Cache{" + this.heapCache.name + "}(" + "size=" + this.getSize() + ", " + "maxSize=" + this.getMaxSize() + ", " + "usageCnt=" + this.getUsageCnt() + ", " + "missCnt=" + this.getMissCnt() + ", " + "peekMissCnt=" + this.heapCache.peekMissCnt + ", " + "peekHitNotFresh=" + this.heapCache.peekHitNotFreshCnt + ", " + "loadCnt=" + this.getLoadCnt() + ", " + "loadButHitCnt=" + this.getLoadButHitCnt() + ", " + "heapHitCnt=" + this.hitCnt + ", " + "newEntryCnt=" + this.getNewEntryCnt() + ", " + "refreshCnt=" + this.getRefreshCnt() + ", " + "refreshSubmitFailedCnt=" + this.getRefreshSubmitFailedCnt() + ", " + "refreshHitCnt=" + this.getRefreshHitCnt() + ", " + "putCnt=" + this.getPutCnt() + ", " + "putNewEntryCnt=" + this.getPutNewEntryCnt() + ", " + "expiredCnt=" + this.getExpiredCnt() + ", " + "evictedCnt=" + this.getEvictedCnt() + ", " + "removedCnt=" + this.getRemovedCnt() + ", " + "clearedCnt=" + this.getClearedCnt() + ", " + "timerEventCnt=" + this.getTimerEventCnt() + ", " + "hitRate=" + this.getDataHitString() + ", " + "collisionCnt=" + this.getCollisionCnt() + ", " + "collisionSlotCnt=" + this.getCollisionSlotCnt() + ", " + "longestCollisionSize=" + this.getLongestCollisionSize() + ", " + "hashQuality=" + this.getHashQualityInteger() + ", " + "msecs/load=" + (this.getMillisPerLoad() >= 0.0 ? Double.valueOf(this.getMillisPerLoad()) : "-") + ", " + "asyncLoadsStarted=" + this.asyncLoadsStarted + ", " + "asyncLoadsInFlight=" + this.asyncLoadsInFlight + ", " + "loaderThreadsLimit=" + this.loaderThreadsLimit + ", " + "loaderThreadsMaxActive=" + this.loaderThreadsMaxActive + ", " + "created=" + CacheBaseInfo.timestampToString(this.getStarted()) + ", " + "cleared=" + CacheBaseInfo.timestampToString(this.getCleared()) + ", " + "touched=" + CacheBaseInfo.timestampToString(this.getTouched()) + ", " + "clearCnt=" + this.getClearCnt() + ", " + "loadExceptionCnt=" + this.getLoadExceptionCnt() + ", " + "suppressedExceptionCnt=" + this.getSuppressedExceptionCnt() + ", " + "internalExceptionCnt=" + this.getInternalExceptionCnt() + ", " + "keyMutationCnt=" + this.getKeyMutationCnt() + ", " + "infoCreated=" + CacheBaseInfo.timestampToString(this.getInfoCreated()) + ", " + "infoCreationDeltaMs=" + this.getInfoCreationDeltaMs() + ", " + "impl=" + this.getImplementation() + ", " + this.getExtraStatistics() + ", " + "integrityState=" + this.getIntegrityDescriptor() + ")";
    }
}

