/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.core.AbstractCache;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.core.RefreshHandler;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.Progress;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.operation.Specification;
import org.cache2k.core.storageApi.PurgeableStorage;
import org.cache2k.core.storageApi.StorageAdapter;
import org.cache2k.core.storageApi.StorageEntry;
import org.cache2k.core.threading.Futures;
import org.cache2k.core.util.Log;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.integration.LoadCompletedListener;
import org.cache2k.processor.CacheEntryProcessor;

public class WiredCache<K, V>
extends AbstractCache<K, V>
implements StorageAdapter.Parent,
HeapCacheListener<K, V> {
    final Specification<K, V> SPEC = Specification.SINGLETON;
    HeapCache<K, V> heapCache;
    StorageAdapter storage;
    AdvancedCacheLoader<K, V> loader;
    CacheWriter<K, V> writer;
    CacheEntryRemovedListener<K, V>[] syncEntryRemovedListeners;
    CacheEntryCreatedListener<K, V>[] syncEntryCreatedListeners;
    CacheEntryUpdatedListener<K, V>[] syncEntryUpdatedListeners;
    CacheEntryExpiredListener<K, V>[] syncEntryExpiredListeners;

    private CommonMetrics.Updater metrics() {
        return this.heapCache.metrics;
    }

    @Override
    public Log getLog() {
        return this.heapCache.getLog();
    }

    public HeapCache getHeapCache() {
        return this.heapCache;
    }

    @Override
    public String getName() {
        return this.heapCache.getName();
    }

    @Override
    public Class<?> getKeyType() {
        return this.heapCache.getKeyType();
    }

    @Override
    public Class<?> getValueType() {
        return this.heapCache.getValueType();
    }

    @Override
    public CacheManager getCacheManager() {
        return this.heapCache.getCacheManager();
    }

    @Override
    public V peekAndPut(K key, V value) {
        return this.returnValue(this.execute(key, this.SPEC.peekAndPut(key, value)));
    }

    @Override
    public V peekAndRemove(K key) {
        return this.returnValue(this.execute(key, this.SPEC.peekAndRemove(key)));
    }

    @Override
    public V peekAndReplace(K key, V value) {
        return this.returnValue(this.execute(key, this.SPEC.peekAndReplace(key, value)));
    }

    @Override
    public CacheEntry<K, V> peekEntry(K key) {
        return this.execute(key, this.SPEC.peekEntry(key));
    }

    @Override
    public void prefetch(final K key) {
        if (this.loader == null) {
            return;
        }
        if (!this.heapCache.isLoaderThreadAvailableForPrefetching()) {
            return;
        }
        Entry e = this.heapCache.lookupEntrySynchronizedNoHitRecord(key);
        if (e != null && e.hasFreshData()) {
            return;
        }
        this.heapCache.loaderExecutor.execute(new HeapCache.RunWithCatch(this){

            @Override
            public void action() {
                WiredCache.this.load(key);
            }
        });
    }

    @Override
    public void prefetchAll(Iterable<? extends K> keys) {
        if (this.loader == null) {
            return;
        }
        Set<K> _keysToLoad = this.heapCache.checkAllPresent(keys);
        for (K k : _keysToLoad) {
            if (!this.heapCache.isLoaderThreadAvailableForPrefetching()) {
                return;
            }
            final K key = k;
            HeapCache.RunWithCatch r = new HeapCache.RunWithCatch(this){

                @Override
                public void action() {
                    WiredCache.this.load(key);
                }
            };
            this.heapCache.loaderExecutor.execute(r);
        }
    }

    private void load(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData()) {
            return;
        }
        this.load(key, e);
    }

    private void load(K key, Entry<K, V> _e) {
        this.execute(key, _e, this.SPEC.get(key));
    }

    @Override
    public boolean contains(K key) {
        return this.execute(key, this.SPEC.contains(key));
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        return this.execute(key, this.SPEC.putIfAbsent(key, value));
    }

    @Override
    public void put(K key, V value) {
        this.execute(key, this.SPEC.put(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void remove(K key) {
        this.execute(key, this.SPEC.remove(key));
    }

    @Override
    public boolean removeIfEquals(K key, V value) {
        return this.execute(key, this.SPEC.remove(key, value));
    }

    @Override
    public boolean containsAndRemove(K key) {
        return this.execute(key, this.SPEC.containsAndRemove(key));
    }

    @Override
    public boolean replace(K key, V _newValue) {
        return this.execute(key, this.SPEC.replace(key, _newValue));
    }

    @Override
    public boolean replaceIfEquals(K key, V _oldValue, V _newValue) {
        return this.execute(key, this.SPEC.replace(key, _oldValue, _newValue));
    }

    @Override
    public CacheEntry<K, V> replaceOrGet(K key, V _oldValue, V _newValue, CacheEntry<K, V> _dummyEntry) {
        return this.execute(key, this.SPEC.replaceOrGet(key, _oldValue, _newValue, _dummyEntry));
    }

    @Override
    public void loadAll(Iterable<? extends K> _keys, LoadCompletedListener l) {
        this.checkLoaderPresent();
        final LoadCompletedListener _listener = l != null ? l : HeapCache.DUMMY_LOAD_COMPLETED_LISTENER;
        Set<K> _keysToLoad = this.heapCache.checkAllPresent(_keys);
        if (_keysToLoad.isEmpty()) {
            _listener.loadCompleted();
            return;
        }
        final AtomicInteger _countDown = new AtomicInteger(_keysToLoad.size());
        Iterator<K> iterator = _keysToLoad.iterator();
        while (iterator.hasNext()) {
            K k;
            final K key = k = iterator.next();
            HeapCache.RunWithCatch r = new HeapCache.RunWithCatch(this){

                @Override
                public void action() {
                    try {
                        WiredCache.this.load(key);
                    }
                    finally {
                        if (_countDown.decrementAndGet() == 0) {
                            _listener.loadCompleted();
                        }
                    }
                }
            };
            this.heapCache.loaderExecutor.execute(r);
        }
    }

    @Override
    public void reloadAll(Iterable<? extends K> _keys, LoadCompletedListener l) {
        this.checkLoaderPresent();
        final LoadCompletedListener _listener = l != null ? l : HeapCache.DUMMY_LOAD_COMPLETED_LISTENER;
        Set<K> _keySet = this.heapCache.generateKeySet(_keys);
        final AtomicInteger _countDown = new AtomicInteger(_keySet.size());
        Iterator<K> iterator = _keySet.iterator();
        while (iterator.hasNext()) {
            K k;
            final K key = k = iterator.next();
            HeapCache.RunWithCatch r = new HeapCache.RunWithCatch(this){

                @Override
                public void action() {
                    try {
                        Specification cfr_ignored_0 = WiredCache.this.SPEC;
                        WiredCache.this.execute(key, Specification.UNCONDITIONAL_LOAD);
                    }
                    finally {
                        if (_countDown.decrementAndGet() == 0) {
                            _listener.loadCompleted();
                        }
                    }
                }
            };
            this.heapCache.loaderExecutor.execute(r);
        }
    }

    private void checkLoaderPresent() {
        if (this.loader == null) {
            throw new UnsupportedOperationException("loader not set");
        }
    }

    V returnValue(V v) {
        return this.heapCache.returnValue(v);
    }

    V returnValue(Entry<K, V> e) {
        return this.returnValue(e.getValueOrException());
    }

    Entry<K, V> lookupQuick(K key) {
        return this.heapCache.lookupEntryUnsynchronized(key);
    }

    @Override
    public V get(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData()) {
            return this.returnValue(e);
        }
        return this.returnValue(this.execute(key, e, this.SPEC.get(key)));
    }

    @Override
    public Map<K, V> getAll(Iterable<? extends K> keys) {
        this.prefetch((K)keys);
        HashMap<K, ExaminationEntry> map = new HashMap<K, ExaminationEntry>();
        for (K k : keys) {
            ExaminationEntry e = this.execute(k, this.SPEC.getEntry(k));
            if (e == null) continue;
            map.put(k, e);
        }
        return this.convertValueMap(map);
    }

    @Override
    public CacheEntry<K, V> getEntry(K key) {
        return this.execute(key, this.SPEC.getEntry(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalEntryCount() {
        Object object = this.lockObject();
        synchronized (object) {
            if (this.storage != null) {
                return this.storage.getTotalEntryCount();
            }
            return this.heapCache.getLocalSize();
        }
    }

    @Override
    public <R> R invoke(K key, CacheEntryProcessor<K, V, R> entryProcessor, Object ... args) {
        return this.execute(key, this.SPEC.invoke(key, this.loader != null, entryProcessor, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        HeapCache.IteratorFilterEntry2Entry<K, V> tor;
        if (this.storage == null) {
            Object object = this.lockObject();
            synchronized (object) {
                tor = new HeapCache.IteratorFilterEntry2Entry<K, V>(this.heapCache, this.heapCache.iterateAllHeapEntries(), true);
            }
        } else {
            tor = new HeapCache.IteratorFilterEntry2Entry<K, V>(this.heapCache, this.storage.iterateAll(), false);
        }
        final HeapCache.IteratorFilterEntry2Entry<K, V> it = tor;
        Iterator _adapted = new Iterator<CacheEntry<K, V>>(){
            CacheEntry<K, V> entry;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public CacheEntry<K, V> next() {
                this.entry = (CacheEntry)it.next();
                return this.entry;
            }

            @Override
            public void remove() {
                if (this.entry == null) {
                    throw new IllegalStateException("call next first");
                }
                WiredCache.this.remove(this.entry.getKey());
            }
        };
        return _adapted;
    }

    @Override
    public V peek(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData()) {
            return this.returnValue(e);
        }
        return this.returnValue(this.execute(key, this.SPEC.peek(key)));
    }

    @Override
    public Map<K, V> peekAll(Iterable<? extends K> keys) {
        HashMap<K, ExaminationEntry> map = new HashMap<K, ExaminationEntry>();
        for (K k : keys) {
            ExaminationEntry e = this.execute(k, this.SPEC.peekEntry(k));
            if (e == null) continue;
            map.put(k, e);
        }
        return this.convertValueMap(map);
    }

    private Map<K, V> convertValueMap(Map<K, ExaminationEntry<K, V>> _map) {
        return this.heapCache.convertValueMap(_map);
    }

    @Override
    public InternalCacheInfo getLatestInfo() {
        return this.heapCache.getLatestInfo();
    }

    @Override
    public InternalCacheInfo getInfo() {
        return this.heapCache.getInfo();
    }

    @Override
    public void clearTimingStatistics() {
        this.heapCache.clearTimingStatistics();
    }

    @Override
    public void checkIntegrity() {
        this.heapCache.checkIntegrity();
    }

    @Override
    public void destroy() {
        this.close();
    }

    @Override
    public boolean isClosed() {
        return this.heapCache.isClosed();
    }

    @Override
    public String toString() {
        return this.heapCache.toString();
    }

    public void init() {
        if (this.storage == null && this.heapCache.maxSize == 0) {
            throw new IllegalArgumentException("maxElements must be >0");
        }
        if (this.storage != null) {
            this.storage.open();
        }
        this.heapCache.init();
        this.heapCache.refreshHandler.init(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> cancelTimerJobs() {
        Object object = this.lockObject();
        synchronized (object) {
            Future<Void> f;
            Future<Void> _waitFuture = this.heapCache.cancelTimerJobs();
            if (this.storage != null && (f = this.storage.cancelTimerJobs()) != null) {
                _waitFuture = new Futures.WaitForAllFuture<Void>(_waitFuture, f);
            }
            return _waitFuture;
        }
    }

    @Override
    public void purge() {
        if (this.storage != null) {
            this.storage.purge();
        }
    }

    @Override
    public void flush() {
        if (this.storage != null) {
            this.storage.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.storage != null) {
            this.storage.clear();
            return;
        }
        Object object = this.lockObject();
        synchronized (object) {
            this.heapCache.checkClosed();
            this.heapCache.clearLocalCache();
            this.heapCache.refreshHandler.init(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.heapCache.closePart1();
        Future<Void> _waitForStorage = null;
        if (this.storage != null) {
            _waitForStorage = this.storage.shutdown();
        }
        if (_waitForStorage != null) {
            try {
                _waitForStorage.get();
            }
            catch (Exception ex) {
                StorageAdapter.rethrow("shutdown", ex);
            }
        }
        Object object = this.lockObject();
        synchronized (object) {
            this.storage = null;
        }
        this.heapCache.closePart2();
    }

    private Object lockObject() {
        return this.heapCache.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStorage(StorageAdapter _from, StorageAdapter to) {
        Object object = this.lockObject();
        synchronized (object) {
            this.storage = to;
        }
    }

    @Override
    public StorageAdapter getStorage() {
        return this.storage;
    }

    public void lockAndRunForPurge(K key, PurgeableStorage.PurgeAction _action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onEvictionFromHeap(Entry<K, V> e) {
        boolean _shouldStore;
        boolean _storeEvenImmediatelyExpired = this.heapCache.hasKeepAfterExpired() && (e.isDataValid() || e.isExpired());
        boolean bl = _shouldStore = this.storage != null && (_storeEvenImmediatelyExpired || e.hasFreshData());
        if (_shouldStore) {
            this.storage.evict(e);
        }
    }

    public Entry<K, V> insertEntryFromStorage(final StorageEntry se) {
        Semantic.Read op = new Semantic.Read<K, V, Entry<K, V>>(){

            @Override
            public void examine(Progress<V, Entry<K, V>> c, ExaminationEntry<K, V> e) {
                c.result((Entry)e);
            }
        };
        MyEntryAction _action = new MyEntryAction<Entry<K, V>>(op, se.getKey(), null){

            @Override
            public void storageRead() {
                this.onReadSuccess(se);
            }
        };
        Entry e = (Entry)this.execute(op, _action);
        return e;
    }

    @Override
    protected <R> EntryAction<K, V, R> createEntryAction(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        return new MyEntryAction<R>(op, key, e);
    }

    @Override
    public String getEntryState(K key) {
        return this.heapCache.getEntryState(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventExpireEntry(Entry<K, V> e) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.timerEventExpireEntryLocked(e);
        }
    }

    void timerEventExpireEntryLocked(Entry<K, V> e) {
        this.heapCache.timerEventExpireEntryLocked(e);
        if ((e.isExpired() || e.isGone()) && this.syncEntryExpiredListeners != null) {
            for (CacheEntryExpiredListener<K, V> l : this.syncEntryExpiredListeners) {
                l.onEntryExpired(this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventRefresh(final Entry<K, V> e) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.isGone()) {
                return;
            }
            if (this.heapCache.moveToRefreshHash(e)) {
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object;
                        if (WiredCache.this.storage == null) {
                            object = e;
                            synchronized (object) {
                                e.waitForProcessing();
                                if (e.isGone()) {
                                    return;
                                }
                            }
                        }
                        try {
                            Specification cfr_ignored_0 = WiredCache.this.SPEC;
                            WiredCache.this.execute(e.getKey(), e, Specification.UNCONDITIONAL_LOAD);
                            object = WiredCache.this.lockObject();
                            synchronized (object) {
                                ++WiredCache.this.heapCache.refreshCnt;
                            }
                        }
                        catch (CacheClosedException cacheClosedException) {
                        }
                        catch (Throwable ex) {
                            Object object2 = WiredCache.this.lockObject();
                            synchronized (object2) {
                                ++WiredCache.this.heapCache.internalExceptionCnt;
                            }
                            WiredCache.this.getLog().warn("Refresh exception", ex);
                            try {
                                WiredCache.this.heapCache.expireEntry(e);
                            }
                            catch (CacheClosedException cacheClosedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                try {
                    this.heapCache.loaderExecutor.execute(r);
                    return;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    ++this.heapCache.refreshSubmitFailedCnt;
                }
            }
            this.timerEventExpireEntryLocked(e);
        }
    }

    class MyEntryAction<R>
    extends EntryAction<K, V, R> {
        public MyEntryAction(Semantic<K, V, R> op, K _k, Entry<K, V> e) {
            super(WiredCache.this.heapCache, WiredCache.this, op, _k, e);
        }

        @Override
        protected boolean mightHaveListeners() {
            return true;
        }

        @Override
        protected CacheEntryCreatedListener<K, V>[] entryCreatedListeners() {
            return WiredCache.this.syncEntryCreatedListeners;
        }

        @Override
        protected CacheEntryRemovedListener<K, V>[] entryRemovedListeners() {
            return WiredCache.this.syncEntryRemovedListeners;
        }

        @Override
        protected CacheEntryUpdatedListener<K, V>[] entryUpdatedListeners() {
            return WiredCache.this.syncEntryUpdatedListeners;
        }

        @Override
        protected StorageAdapter storage() {
            return WiredCache.this.storage;
        }

        @Override
        protected CacheWriter<K, V> writer() {
            return WiredCache.this.writer;
        }

        @Override
        protected RefreshHandler<K, V> refreshHandler() {
            return this.heapCache.refreshHandler;
        }
    }
}

