/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.core.InternalCache;
import org.cache2k.processor.CacheEntryProcessor;
import org.cache2k.processor.MutableCacheEntry;

public class ConcurrentMapWrapper<K, V>
implements ConcurrentMap<K, V> {
    Cache<K, V> cache;
    Class<?> keyType;
    Class<?> valueType;

    public ConcurrentMapWrapper(InternalCache<K, V> cache) {
        this.cache = cache;
        InternalCache<K, V> bc = cache;
        this.keyType = bc.getKeyType();
        this.valueType = bc.getValueType();
    }

    @Override
    public V putIfAbsent(K key, final V value) {
        CacheEntryProcessor p = new CacheEntryProcessor<K, V, V>(){

            @Override
            public V process(MutableCacheEntry<K, V> entry, Object ... arguments) throws Exception {
                if (!entry.exists()) {
                    entry.setValue(value);
                    return null;
                }
                return entry.getValue();
            }
        };
        return (V)this.cache.invoke(key, p, new Object[0]);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.keyType.isAssignableFrom(key.getClass()) && this.valueType.isAssignableFrom(value.getClass())) {
            return this.cache.removeIfEquals(key, value);
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.cache.replaceIfEquals(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, final V value) {
        CacheEntryProcessor p = new CacheEntryProcessor<K, V, V>(){

            @Override
            public V process(MutableCacheEntry<K, V> entry, Object ... arguments) throws Exception {
                if (entry.exists()) {
                    Object result = entry.getValue();
                    entry.setValue(value);
                    return result;
                }
                return null;
            }
        };
        return (V)this.cache.invoke(key, p, new Object[0]);
    }

    @Override
    public int size() {
        return this.cache.getTotalEntryCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.keyType.isAssignableFrom(key.getClass())) {
            return this.cache.contains(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (CacheEntry<K, V> e : this.cache) {
                if (e.getValue() != null) continue;
                return true;
            }
        } else {
            for (CacheEntry<K, V> e : this.cache) {
                if (!value.equals(e.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.keyType.isAssignableFrom(key.getClass())) {
            return this.cache.peek(key);
        }
        return null;
    }

    @Override
    public V put(K key, final V value) {
        CacheEntryProcessor p = new CacheEntryProcessor<K, V, V>(){

            @Override
            public V process(MutableCacheEntry<K, V> entry, Object ... arguments) throws Exception {
                Object result = entry.getValue();
                entry.setValue(value);
                return result;
            }
        };
        return (V)this.cache.invoke(key, p, new Object[0]);
    }

    @Override
    public V remove(Object key) {
        if (!this.keyType.isAssignableFrom(key.getClass())) {
            return null;
        }
        CacheEntryProcessor p = new CacheEntryProcessor<K, V, V>(){

            @Override
            public V process(MutableCacheEntry<K, V> entry, Object ... arguments) throws Exception {
                Object result = entry.getValue();
                entry.remove();
                return result;
            }
        };
        return (V)this.cache.invoke(key, p, new Object[0]);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cache.putAll(m);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator it = ConcurrentMapWrapper.this.cache.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((CacheEntry)it.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return ConcurrentMapWrapper.this.containsKey(o);
            }

            @Override
            public int size() {
                return this.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                final Iterator it = ConcurrentMapWrapper.this.cache.iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((CacheEntry)it.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator it = ConcurrentMapWrapper.this.cache.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final CacheEntry e = (CacheEntry)it.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return e.getKey();
                            }

                            @Override
                            public V getValue() {
                                return e.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.size();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return this.cache.equals(o);
    }

    @Override
    public int hashCode() {
        return this.cache.hashCode();
    }
}

