/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cache2k.impl.CacheInternalError;
import org.cache2k.impl.util.Log;
import org.cache2k.impl.util.TunableConstants;

public final class TunableFactory {
    static Log log = Log.getLog(TunableFactory.class);
    public static final String DEFAULT_TUNING_FILE_NAME = "/org/cache2k/default-tuning.properties";
    public static final String CUSTOM_TUNING_FILE_NAME = "/org/cache2k/tuning.properties";
    public static final String TUNE_MARKER = "org.cache2k.tuning";
    private static Map<Class<?>, Object> map;
    private static Properties defaultProperties;
    private static Properties customProperties;

    public static synchronized void reload() {
        map = new HashMap();
        customProperties = TunableFactory.loadFile(CUSTOM_TUNING_FILE_NAME);
        defaultProperties = TunableFactory.loadFile(DEFAULT_TUNING_FILE_NAME);
    }

    static Properties loadFile(String _fileName) {
        InputStream in = TunableConstants.class.getResourceAsStream(_fileName);
        if (in != null) {
            try {
                Properties p = new Properties();
                p.load(in);
                in.close();
                return p;
            }
            catch (IOException ex) {
                throw new CacheInternalError("tuning properties not readable", ex);
            }
        }
        return null;
    }

    public static synchronized <T extends TunableConstants> T get(Properties p, Class<T> c) {
        Object cfg = TunableFactory.getDefault(c);
        if (p != null && p.containsKey(TUNE_MARKER) && p.containsKey(cfg.getClass().getName() + ".tuning")) {
            cfg = (TunableConstants)((TunableConstants)cfg).clone();
            TunableFactory.apply(p, cfg);
        }
        return cfg;
    }

    public static synchronized <T extends TunableConstants> T get(Class<T> c) {
        return TunableFactory.getDefault(c);
    }

    private static <T extends TunableConstants> T getDefault(Class<T> c) {
        TunableConstants cfg;
        if (map == null) {
            TunableFactory.reload();
        }
        if ((cfg = (TunableConstants)map.get(c)) == null) {
            try {
                cfg = (TunableConstants)c.newInstance();
            }
            catch (Exception ex) {
                throw new CacheInternalError("cannot instantiate tunables", ex);
            }
            TunableFactory.apply(defaultProperties, cfg);
            TunableFactory.apply(customProperties, cfg);
            TunableFactory.apply(System.getProperties(), cfg);
            map.put(c, cfg);
        }
        return (T)cfg;
    }

    static void apply(Properties p, Object cfg) {
        if (p == null) {
            return;
        }
        String _propName = null;
        try {
            for (Field f : cfg.getClass().getFields()) {
                _propName = cfg.getClass().getName().replace('$', '.') + "." + f.getName();
                String o = p.getProperty(_propName);
                if (o == null) continue;
                Class<?> _fieldType = f.getType();
                if (_fieldType == Boolean.TYPE) {
                    if ("off".equals(o = o.toLowerCase()) || "false".equals(o) || "disable".equals(o)) {
                        f.set(cfg, false);
                    } else {
                        f.set(cfg, true);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug(_propName + "=" + f.get(cfg));
                    continue;
                }
                if (_fieldType == Integer.TYPE) {
                    f.set(cfg, Integer.valueOf(o));
                    if (!log.isDebugEnabled()) continue;
                    log.debug(_propName + "=" + f.get(cfg));
                    continue;
                }
                if (_fieldType == Long.TYPE) {
                    f.set(cfg, Long.valueOf(o));
                    if (!log.isDebugEnabled()) continue;
                    log.debug(_propName + "=" + f.get(cfg));
                    continue;
                }
                if (_fieldType == String.class) {
                    f.set(cfg, o);
                    if (!log.isDebugEnabled()) continue;
                    log.debug(_propName + "=" + f.get(cfg));
                    continue;
                }
                if (_fieldType == Class.class) {
                    Class<?> c = Class.forName(o);
                    f.set(cfg, c);
                    if (!log.isDebugEnabled()) continue;
                    log.debug(_propName + "=" + c.getName());
                    continue;
                }
                throw new CacheInternalError("Changing this tunable type is not supported. Tunable: " + _propName + ", " + _fieldType);
            }
        }
        catch (Exception ex) {
            if (_propName != null) {
                throw new CacheInternalError("error applying tuning setup, property=" + _propName, ex);
            }
            throw new CacheInternalError("error applying tuning setup", ex);
        }
    }
}

