/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class ConfigurationReader {
    Object config;

    public ConfigurationReader(Object config) {
        this.config = config;
    }

    public void apply(String _parameterName, String _content) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Method m = this.findMethod(_parameterName);
        if (m.getParameterTypes().length == 1) {
            Object o = ConfigurationReader.convertSingle(m.getParameterTypes()[0], _content);
            m.invoke(this.config, o);
        } else if (m.getParameterTypes().length == 2 && TimeUnit.class.equals(m.getParameterTypes()[1])) {
            m.invoke(this.config, new Object[]{ConfigurationReader.convertTime(_content), TimeUnit.MILLISECONDS});
        } else {
            throw new IllegalArgumentException("setter not supported by XML configuration");
        }
    }

    static Object convertSingle(Class<?> _class, String _content) throws ClassNotFoundException {
        if (String.class.equals(_class)) {
            return _content;
        }
        if (Integer.class.equals(_class) || Integer.TYPE.equals(_class)) {
            return Integer.parseInt(_content);
        }
        if (Long.class.equals(_class) || Long.TYPE.equals(_class)) {
            return Long.parseLong(_content);
        }
        if (Boolean.class.equals(_class) || Boolean.TYPE.equals(_class)) {
            if ("true".equals(_content)) {
                return true;
            }
            if ("yes".equals(_content)) {
                return true;
            }
            return false;
        }
        if (Class.class.equals(_class)) {
            return Class.forName(_content);
        }
        throw new IllegalArgumentException("Cannot apply parameter type: " + _class);
    }

    Method findMethod(String _parameterName) {
        String _setterName = "set" + Character.toUpperCase(_parameterName.charAt(0)) + _parameterName.substring(1);
        _setterName = _setterName.toLowerCase();
        for (Method m : this.config.getClass().getMethods()) {
            if (!_setterName.equals(m.getName().toLowerCase())) continue;
            return m;
        }
        throw new IllegalArgumentException("Unknown parameter");
    }

    static long convertTime(String _content) {
        String[] _UNIT_STRINGS = new String[]{"d", "h", "m", "s", "ms"};
        TimeUnit[] _UNIT_INSTANCES = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS};
        for (int i = 0; i < _UNIT_STRINGS.length; ++i) {
            String _suffix = _UNIT_STRINGS[i];
            if (!_content.endsWith(_suffix)) continue;
            TimeUnit tu = _UNIT_INSTANCES[i];
            String s = _content.substring(0, _content.length() - _suffix.length());
            return _UNIT_INSTANCES[i].toMillis(Long.parseLong(s));
        }
        throw new IllegalArgumentException("unknown time suffix (must either of: d, h, m, s, ms)");
    }
}

