/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.cache2k.CacheConfig;
import org.cache2k.CacheEntry;
import org.cache2k.customization.ExceptionExpiryCalculator;
import org.cache2k.customization.ExpiryCalculator;
import org.cache2k.customization.ValueWithExpiryTime;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.Entry;
import org.cache2k.impl.ExceptionWrapper;
import org.cache2k.impl.InternalCache;

public abstract class RefreshHandler<K, V> {
    static final long SAFETY_GAP_MILLIS = BaseCache.TUNABLE.sharpExpirySafetyGapMillis;
    static final RefreshHandler ETERNAL = new Eternal();
    static final RefreshHandler IMMEDIATE = new Immediate();
    static final RefreshHandler ETERNAL_IMMEDIATE = new EternalImmediate();
    static final ExpiryCalculator<?, ValueWithExpiryTime> ENTRY_EXPIRY_CALCULATOR_FROM_VALUE = new ExpiryCalculator<Object, ValueWithExpiryTime>(){

        @Override
        public long calculateExpiryTime(Object _key, ValueWithExpiryTime _value, long _loadTime, CacheEntry<Object, ValueWithExpiryTime> _oldEntry) {
            return _value.getCacheExpiryTime();
        }
    };

    public static <K, V> RefreshHandler<K, V> of(CacheConfig<K, V> cfg) {
        if (cfg.getExceptionExpiryCalculator() != null || cfg.getExpiryCalculator() != null || ValueWithExpiryTime.class.isAssignableFrom(cfg.getValueType().getType())) {
            Dynamic<K, V> h = new Dynamic<K, V>();
            h.configure(cfg);
            return h;
        }
        if (cfg.getExpiryMillis() > 0L && cfg.getExpiryMillis() < Long.MAX_VALUE || cfg.getExceptionExpiryMillis() > 0L && cfg.getExceptionExpiryMillis() < Long.MAX_VALUE) {
            Static<K, V> h = new Static<K, V>();
            h.configureStatic(cfg);
            return h;
        }
        if (cfg.getExpiryMillis() == 0L && (cfg.getExceptionExpiryMillis() == 0L || cfg.getExceptionExpiryMillis() == -1L)) {
            return IMMEDIATE;
        }
        if ((cfg.getExpiryMillis() == Long.MAX_VALUE || cfg.getExceptionExpiryMillis() == -1L) && cfg.getExceptionExpiryMillis() == -1L) {
            return ETERNAL_IMMEDIATE;
        }
        if (!(cfg.getExpiryMillis() != Long.MAX_VALUE && cfg.getExpiryMillis() != -1L || cfg.getExceptionExpiryMillis() != Long.MAX_VALUE && cfg.getExceptionExpiryMillis() != -1L)) {
            return ETERNAL;
        }
        throw new IllegalArgumentException("expiry time ambiguous");
    }

    public void init(InternalCache<K, V> c) {
    }

    public void shutdown() {
    }

    public abstract long calculateNextRefreshTime(Entry<K, V> var1, V var2, long var3);

    public long stopStartTimer(long _nextRefreshTime, Entry<K, V> e) {
        return _nextRefreshTime == 0L ? 4L : _nextRefreshTime;
    }

    public void cancelExpiryTimer(Entry<K, V> e) {
    }

    public void scheduleFinalExpiryTimer(Entry<K, V> e) {
    }

    static <K, T> long calcNextRefreshTime(K _key, T _newObject, long now, Entry _entry, ExpiryCalculator<K, T> ec, long _maxLinger, ExceptionExpiryCalculator<K> _exceptionEc, long _exceptionMaxLinger) {
        if (_newObject instanceof ExceptionWrapper) {
            if (_exceptionMaxLinger == 0L) {
                return 0L;
            }
            if (_exceptionEc != null) {
                ExceptionWrapper _wrapper = (ExceptionWrapper)_newObject;
                long t = _exceptionEc.calculateExpiryTime(_key, _wrapper.getException(), now);
                t = RefreshHandler.limitExpiryToMaxLinger(now, _exceptionMaxLinger, t);
                return t;
            }
            if (_exceptionMaxLinger < Long.MAX_VALUE) {
                return _exceptionMaxLinger + now;
            }
            return _exceptionMaxLinger;
        }
        if (_maxLinger == 0L) {
            return 0L;
        }
        if (ec != null) {
            long t = ec.calculateExpiryTime(_key, _newObject, now, _entry);
            return RefreshHandler.limitExpiryToMaxLinger(now, _maxLinger, t);
        }
        if (_maxLinger < Long.MAX_VALUE) {
            return _maxLinger + now;
        }
        return _maxLinger;
    }

    static long limitExpiryToMaxLinger(long now, long _maxLinger, long t) {
        if (_maxLinger > 0L && _maxLinger < Long.MAX_VALUE) {
            long _tMaximum = _maxLinger + now;
            if (t > _tMaximum) {
                return _tMaximum;
            }
            if (t < -1L && -t > _tMaximum) {
                return -_tMaximum;
            }
        }
        return t;
    }

    static long sanitizeTime(long _nextRefreshTime, long _now) {
        if (_nextRefreshTime > 32L && _nextRefreshTime <= _now && _nextRefreshTime < -1L && _now >= -_nextRefreshTime) {
            return 4L;
        }
        return _nextRefreshTime;
    }

    static class Dynamic<K, V>
    extends Static<K, V> {
        ExpiryCalculator<K, V> expiryCalculator;
        ExceptionExpiryCalculator<K> exceptionExpiryCalculator;

        Dynamic() {
        }

        void configure(CacheConfig<K, V> c) {
            this.configureStatic(c);
            this.expiryCalculator = c.getExpiryCalculator();
            this.exceptionExpiryCalculator = c.getExceptionExpiryCalculator();
            if (ValueWithExpiryTime.class.isAssignableFrom(c.getValueType().getType()) && this.expiryCalculator == null) {
                this.expiryCalculator = ENTRY_EXPIRY_CALCULATOR_FROM_VALUE;
            }
        }

        @Override
        boolean isNeedingTimer() {
            return super.isNeedingTimer() || this.expiryCalculator != null || this.exceptionExpiryCalculator != null;
        }

        long calcNextRefreshTime(K _key, V _newObject, long now, Entry _entry) {
            return Dynamic.calcNextRefreshTime(_key, _newObject, now, _entry, this.expiryCalculator, this.maxLinger, this.exceptionExpiryCalculator, this.exceptionMaxLinger);
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> _entry, V _newValue, long _loadTime) {
            if (_entry.isDataValid() || _entry.isExpired()) {
                return this.calcNextRefreshTime(_entry.getKey(), _newValue, _loadTime, _entry);
            }
            return this.calcNextRefreshTime(_entry.getKey(), _newValue, _loadTime, null);
        }
    }

    static class ExpireTask<K, V>
    extends TimerTask {
        Entry<K, V> entry;
        InternalCache cache;

        public ExpireTask(InternalCache _cache, Entry<K, V> _entry) {
            this.cache = _cache;
            this.entry = _entry;
        }

        @Override
        public void run() {
            this.cache.timerEventExpireEntry(this.entry);
        }
    }

    static class RefreshTask<K, V>
    extends TimerTask {
        Entry<K, V> entry;
        InternalCache cache;

        public RefreshTask(InternalCache _cache, Entry<K, V> _entry) {
            this.cache = _cache;
            this.entry = _entry;
        }

        @Override
        public void run() {
            this.cache.timerEventRefresh(this.entry);
        }
    }

    static class Static<K, V>
    extends RefreshHandler<K, V> {
        boolean sharpTimeout;
        boolean backgroundRefresh;
        Timer timer;
        long maxLinger = 600000L;
        long exceptionMaxLinger = 60000L;
        InternalCache cache;
        long timerCancelCount = 0L;

        Static() {
        }

        void configureStatic(CacheConfig<K, V> c) {
            long _expiryMillis = c.getExpiryMillis();
            if (_expiryMillis == Long.MAX_VALUE || _expiryMillis < 0L) {
                this.maxLinger = Long.MAX_VALUE;
            } else if (_expiryMillis >= 0L) {
                this.maxLinger = _expiryMillis;
            }
            long _exceptionExpiryMillis = c.getExceptionExpiryMillis();
            this.exceptionMaxLinger = _exceptionExpiryMillis == -1L ? (this.maxLinger == Long.MAX_VALUE ? Long.MAX_VALUE : this.maxLinger / 10L) : _exceptionExpiryMillis;
            this.backgroundRefresh = c.isRefreshAhead();
            this.sharpTimeout = c.isSharpExpiry();
        }

        boolean isNeedingTimer() {
            return this.maxLinger > 0L || this.exceptionMaxLinger > 0L;
        }

        @Override
        public synchronized void init(InternalCache<K, V> c) {
            this.cache = c;
            if (this.isNeedingTimer()) {
                this.timer = new Timer(this.cache.getName(), true);
            }
        }

        @Override
        public synchronized void shutdown() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return Static.calcNextRefreshTime(e.getKey(), v, _loadTime, e, null, this.maxLinger, null, this.exceptionMaxLinger);
        }

        @Override
        public long stopStartTimer(long _nextRefreshTime, Entry e) {
            this.cancelExpiryTimer(e);
            if (_nextRefreshTime == 0L) {
                return 4L;
            }
            long now = System.currentTimeMillis();
            if ((_nextRefreshTime = Static.sanitizeTime(_nextRefreshTime, now)) > 0L && _nextRefreshTime < 32L || _nextRefreshTime == Long.MAX_VALUE) {
                return _nextRefreshTime;
            }
            if (this.sharpTimeout && _nextRefreshTime > 32L) {
                _nextRefreshTime = -_nextRefreshTime;
            }
            if (this.timer != null && (_nextRefreshTime > 32L || _nextRefreshTime < -1L)) {
                if (_nextRefreshTime < -1L) {
                    long _timerTime = -_nextRefreshTime - SAFETY_GAP_MILLIS;
                    if (_timerTime >= now) {
                        e.task = new ExpireTask(this.cache, e);
                        this.scheduleTask(_timerTime, e);
                        _nextRefreshTime = -_nextRefreshTime;
                    } else {
                        e.task = new ExpireTask(this.cache, e);
                        this.scheduleTask(-_nextRefreshTime, e);
                    }
                } else if (this.backgroundRefresh) {
                    e.task = new RefreshTask(this.cache, e);
                    this.scheduleTask(_nextRefreshTime, e);
                } else {
                    e.task = new ExpireTask(this.cache, e);
                    this.scheduleTask(_nextRefreshTime, e);
                }
            }
            return _nextRefreshTime;
        }

        @Override
        public void scheduleFinalExpiryTimer(Entry<K, V> e) {
            e.task = new ExpireTask<K, V>(this.cache, e);
            this.scheduleTask(e.nextRefreshTime, e);
        }

        void scheduleTask(long _nextRefreshTime, Entry e) {
            Timer _timer = this.timer;
            if (_timer != null) {
                try {
                    _timer.schedule(e.task, new Date(_nextRefreshTime));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void cancelExpiryTimer(Entry<K, V> e) {
            TimerTask _task = e.task;
            if (_task != null && _task.cancel()) {
                ++this.timerCancelCount;
                if (this.timerCancelCount >= 10000L) {
                    this.timer.purge();
                    this.timerCancelCount = 0L;
                }
            }
        }
    }

    static class Immediate<K, V>
    extends RefreshHandler<K, V> {
        Immediate() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return 0L;
        }
    }

    static class EternalImmediate<K, V>
    extends RefreshHandler<K, V> {
        EternalImmediate() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return v instanceof ExceptionWrapper ? 0L : Long.MAX_VALUE;
        }
    }

    static class Eternal<K, V>
    extends RefreshHandler<K, V> {
        Eternal() {
        }

        @Override
        public long calculateNextRefreshTime(Entry<K, V> e, V v, long _loadTime) {
            return Long.MAX_VALUE;
        }
    }
}

