/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import org.cache2k.impl.BaseCache;
import org.cache2k.impl.Entry;
import org.cache2k.impl.IntegrityState;

public class LruCache<K, V>
extends BaseCache<K, V> {
    Entry<K, V> head;
    long hitCnt;

    @Override
    public long getHitCnt() {
        return this.hitCnt;
    }

    @Override
    protected void recordHit(Entry e) {
        if (!e.isRemovedFromReplacementList()) {
            this.removeEntryFromReplacementList(e);
            LruCache.insertInList(this.head, e);
        }
        ++this.hitCnt;
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        LruCache.insertInList(this.head, e);
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    @Override
    protected Entry findEvictionCandidate() {
        return this.head.prev;
    }

    @Override
    protected void initializeHeapCache() {
        super.initializeHeapCache();
        this.head = new Entry().shortCircuit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntegrityState getIntegrityState() {
        Object object = this.lock;
        synchronized (object) {
            return super.getIntegrityState().checkEquals("size = list entry count", this.getLocalSize(), LruCache.getListEntryCount(this.head));
        }
    }
}

