/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.lang.reflect.Array;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.CacheClosedException;
import org.cache2k.impl.Entry;

public class Hash<E extends Entry> {
    public int size = 0;
    public int maxFill = 0;
    private int suppressExpandCount;

    public static int index(Entry[] _hashTable, int _hashCode) {
        if (_hashTable == null) {
            throw new CacheClosedException();
        }
        return _hashCode & _hashTable.length - 1;
    }

    public static <E extends Entry> E lookup(E[] _hashTable, Object key, int _hashCode) {
        int i = Hash.index(_hashTable, _hashCode);
        Object e = _hashTable[i];
        while (e != null) {
            if (((Entry)e).hashCode == _hashCode && key.equals(((Entry)e).key)) {
                return e;
            }
            e = ((Entry)e).another;
        }
        return null;
    }

    public static boolean contains(Entry[] _hashTable, Object key, int _hashCode) {
        int i = Hash.index(_hashTable, _hashCode);
        Entry e = _hashTable[i];
        while (e != null) {
            if (e.hashCode == _hashCode && (key == e.key || key.equals(e.key))) {
                return true;
            }
            e = e.another;
        }
        return false;
    }

    public static void insertWoExpand(Entry[] _hashTable, Entry e) {
        int i = Hash.index(_hashTable, e.hashCode);
        e.another = _hashTable[i];
        _hashTable[i] = e;
    }

    /*
     * WARNING - void declaration
     */
    private static void rehash(Entry[] a1, Entry[] a2) {
        for (Entry entry : a1) {
            void var5_5;
            while (var5_5 != null) {
                Entry _next = var5_5.another;
                Hash.insertWoExpand(a2, (Entry)var5_5);
                Entry entry2 = _next;
            }
        }
    }

    private static <E extends Entry> E[] expandHash(E[] _hashTable) {
        Entry[] a2 = (Entry[])Array.newInstance(_hashTable.getClass().getComponentType(), _hashTable.length * 2);
        Hash.rehash(_hashTable, a2);
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    public static void calcHashCollisionInfo(BaseCache.CollisionInfo inf, Entry[] _hashTable) {
        for (Entry entry : _hashTable) {
            void var5_8;
            Entry entry2;
            if (entry == null || (entry2 = entry.another) == null) continue;
            ++inf.collisionSlotCnt;
            int _size = 1;
            while (var5_8 != null) {
                ++inf.collisionCnt;
                Entry entry3 = var5_8.another;
                ++_size;
            }
            if (inf.longestCollisionSize >= _size) continue;
            inf.longestCollisionSize = _size;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int calcEntryCount(Entry[] _hashTable) {
        int _entryCount = 0;
        for (Entry entry : _hashTable) {
            void var5_5;
            while (var5_5 != null) {
                ++_entryCount;
                Entry entry2 = var5_5.another;
            }
        }
        return _entryCount;
    }

    public boolean remove(Entry[] _hashTable, Entry _entry) {
        int i = Hash.index(_hashTable, _entry.hashCode);
        Entry e = _hashTable[i];
        if (e == _entry) {
            _hashTable[i] = e.another;
            --this.size;
            return true;
        }
        while (e != null) {
            Entry _another = e.another;
            if (_another == _entry) {
                e.another = _another.another;
                --this.size;
                return true;
            }
            e = _another;
        }
        return false;
    }

    public E remove(E[] _hashTable, Object key, int hc) {
        int i = Hash.index(_hashTable, hc);
        Object e = _hashTable[i];
        if (e == null) {
            return null;
        }
        if (((Entry)e).hashCode == hc && key.equals(((Entry)e).key)) {
            _hashTable[i] = ((Entry)e).another;
            --this.size;
            return e;
        }
        Entry _another = ((Entry)e).another;
        while (_another != null) {
            if (_another.hashCode == hc && key.equals(_another.key)) {
                ((Entry)e).another = _another.another;
                --this.size;
                return (E)_another;
            }
            e = _another;
            _another = _another.another;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E[] insert(E[] _hashTable, Entry _entry) {
        ++this.size;
        Hash.insertWoExpand(_hashTable, _entry);
        Hash hash = this;
        synchronized (hash) {
            if (this.size >= this.maxFill && this.suppressExpandCount == 0) {
                this.maxFill *= 2;
                return Hash.expandHash(_hashTable);
            }
            return _hashTable;
        }
    }

    public synchronized void incrementSuppressExpandCount() {
        ++this.suppressExpandCount;
    }

    public synchronized void decrementSuppressExpandCount() {
        --this.suppressExpandCount;
    }

    public void cleared() {
        if (this.size >= 0) {
            this.size = -1;
        }
    }

    public void close() {
        this.size = -2;
    }

    public boolean isCleared() {
        return this.size == -1;
    }

    public boolean isClosed() {
        return this.size == -2;
    }

    public boolean shouldAbort() {
        return this.size < 0;
    }

    public E[] init(Class<E> _entryType) {
        this.size = 0;
        this.maxFill = BaseCache.TUNABLE.initialHashSize * BaseCache.TUNABLE.hashLoadPercent / 100;
        return (Entry[])Array.newInstance(_entryType, BaseCache.TUNABLE.initialHashSize);
    }
}

